/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeaturePath;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeClass;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.impl.TypeSystemUtils;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.cas.TOP;

class FeaturePathImpl
implements FeaturePath {
    private static final String MESSAGE_DIGEST = "org.apache.uima.cas.impl.annot_impl";
    private static final String FEATURE_PATH_SEPARATOR = "/";
    private static final String BUILT_IN_FUNCTION_SEPARATOR = ":";
    private static final byte NO_BUILT_IN_FUNCTION = 0;
    private static final byte FUNCTION_COVERED_TEXT = 1;
    private static final byte FUNCTION_ID = 2;
    private static final byte FUNCTION_TYPE_NAME = 3;
    private static final String FUNCTION_NAME_COVERED_TEXT = "coveredtext()";
    private static final String FUNCTION_NAME_ID = "fsid()";
    private static final String FUNCTION_NAME_TYPE_NAME = "typename()";
    private static final TOP FEATURE_PATH_FAILED = new TOP();
    private byte builtInFunction = 0;
    private String originalBuiltInName = null;
    private final ArrayList<String> featurePathElementNames = new ArrayList();
    private boolean pathStartsWithSlash = true;
    private final ArrayList<FeatureImpl> boundFeatures = new ArrayList();
    private FeatureImpl targetFeature;
    private TypeImpl targetType;
    private TypeImpl boundBaseType = null;

    FeaturePathImpl() {
    }

    @Override
    public void addFeature(Feature feat) {
        if (this.builtInFunction > 0) {
            throw new CASRuntimeException(MESSAGE_DIGEST, "INVALID_FEATURE_PATH_SYNTAX_ADD", new Object[]{this.getFeaturePathString(), feat.getShortName()});
        }
        this.featurePathElementNames.add(feat.getShortName());
        this.boundFeatures.add((FeatureImpl)feat);
        if (this.boundBaseType != null && TypeSystemUtils.PathValid.NEVER == TypeSystemUtils.isPathValid(this.boundBaseType, this.featurePathElementNames)) {
            this.boundBaseType = null;
        }
    }

    @Override
    public FeatureImpl getFeature(int i) {
        return this.size() == this.boundFeatures.size() ? this.boundFeatures.get(i) : null;
    }

    @Override
    public int size() {
        return this.featurePathElementNames.size();
    }

    @Override
    public void initialize(String featurePath) throws CASException {
        this.builtInFunction = 0;
        this.originalBuiltInName = null;
        if (featurePath == null) {
            throw new CASException(MESSAGE_DIGEST, "INVALID_FEATURE_PATH_SYNTAX", new Object[]{featurePath, "null for a feature path"});
        }
        this.pathStartsWithSlash = featurePath.startsWith(FEATURE_PATH_SEPARATOR);
        if (featurePath.indexOf("//") > -1) {
            throw new CASException(MESSAGE_DIGEST, "INVALID_FEATURE_PATH_SYNTAX", new Object[]{featurePath, "//"});
        }
        this.featurePathElementNames.clear();
        StringTokenizer tokenizer = new StringTokenizer(featurePath, FEATURE_PATH_SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                this.featurePathElementNames.add(token);
                continue;
            }
            int index = -1;
            index = token.indexOf(BUILT_IN_FUNCTION_SEPARATOR);
            if (index != -1) {
                if (index > 0) {
                    this.featurePathElementNames.add(token.substring(0, index));
                }
                this.originalBuiltInName = token.substring(index + 1);
                String builtInFunctionName = this.originalBuiltInName.toLowerCase();
                if (builtInFunctionName.equals(FUNCTION_NAME_COVERED_TEXT)) {
                    this.builtInFunction = 1;
                    continue;
                }
                if (builtInFunctionName.equals(FUNCTION_NAME_ID)) {
                    this.builtInFunction = (byte)2;
                    continue;
                }
                if (builtInFunctionName.equals(FUNCTION_NAME_TYPE_NAME)) {
                    this.builtInFunction = (byte)3;
                    continue;
                }
                throw new CASException(MESSAGE_DIGEST, "INVALID_FEATURE_PATH_SYNTAX", new Object[]{featurePath, builtInFunctionName});
            }
            this.featurePathElementNames.add(token);
        }
    }

    @Override
    public void typeInit(Type typeAtStartOfFeaturePath) throws CASException {
        this.boundBaseType = (TypeImpl)typeAtStartOfFeaturePath;
        if (this.featurePathElementNames.size() > 0) {
            String featName;
            FeatureImpl fi;
            this.boundBaseType = (TypeImpl)typeAtStartOfFeaturePath;
            if (TypeSystemUtils.PathValid.NEVER == TypeSystemUtils.isPathValid(typeAtStartOfFeaturePath, this.featurePathElementNames)) {
                throw new CASException(MESSAGE_DIGEST, "ERROR_VALIDATE_FEATURE_PATH", new Object[]{this.getFeaturePathString(), typeAtStartOfFeaturePath.getName()});
            }
            this.boundFeatures.clear();
            TypeImpl currentType = (TypeImpl)typeAtStartOfFeaturePath;
            Iterator<String> iterator = this.featurePathElementNames.iterator();
            while (iterator.hasNext() && (fi = currentType.getFeatureByBaseName(featName = iterator.next())) != null) {
                this.boundFeatures.add(fi);
                currentType = fi.getRangeImpl();
            }
        }
    }

    @Override
    public String getFeaturePath() {
        return this.getFeaturePathString();
    }

    @Override
    public Boolean getBooleanValue(FeatureStructure fs) {
        TOP tgtFs = this.getTargetFs((TOP)fs);
        return tgtFs == FEATURE_PATH_FAILED ? null : Boolean.valueOf(tgtFs.getBooleanValue(this.targetFeature));
    }

    @Override
    public Byte getByteValue(FeatureStructure fs) {
        TOP tgtFs = this.getTargetFs((TOP)fs);
        return tgtFs == FEATURE_PATH_FAILED ? null : Byte.valueOf(tgtFs.getByteValue(this.targetFeature));
    }

    @Override
    public Double getDoubleValue(FeatureStructure fs) {
        TOP tgtFs = this.getTargetFs((TOP)fs);
        return tgtFs == FEATURE_PATH_FAILED ? null : Double.valueOf(tgtFs.getDoubleValue(this.targetFeature));
    }

    @Override
    public Float getFloatValue(FeatureStructure fs) {
        TOP tgtFs = this.getTargetFs((TOP)fs);
        return tgtFs == FEATURE_PATH_FAILED ? null : Float.valueOf(tgtFs.getFloatValue(this.targetFeature));
    }

    @Override
    public FeatureStructure getFSValue(FeatureStructure fs) {
        TOP tgtFs = this.getTargetFs((TOP)fs);
        return tgtFs == FEATURE_PATH_FAILED ? null : tgtFs;
    }

    @Override
    public Integer getIntValue(FeatureStructure fs) {
        TOP tgtFs = this.getTargetFs((TOP)fs);
        return tgtFs == FEATURE_PATH_FAILED ? null : Integer.valueOf(tgtFs.getIntValue(this.targetFeature));
    }

    @Override
    public Long getLongValue(FeatureStructure fs) {
        TOP tgtFs = this.getTargetFs((TOP)fs);
        return tgtFs == FEATURE_PATH_FAILED ? null : Long.valueOf(tgtFs.getLongValue(this.targetFeature));
    }

    @Override
    public Short getShortValue(FeatureStructure fs) {
        TOP tgtFs = this.getTargetFs((TOP)fs);
        return tgtFs == FEATURE_PATH_FAILED ? null : Short.valueOf(tgtFs.getShortValue(this.targetFeature));
    }

    @Override
    public String getStringValue(FeatureStructure fs) {
        TOP tgtFs = this.getTargetFs((TOP)fs);
        return tgtFs == FEATURE_PATH_FAILED ? null : tgtFs.getStringValue(this.targetFeature);
    }

    @Override
    public Type getType(FeatureStructure fs) {
        TOP tgtFs = this.getTargetFs((TOP)fs);
        return tgtFs == FEATURE_PATH_FAILED ? null : this.targetType;
    }

    @Override
    @Deprecated
    public TypeClass getTypClass(FeatureStructure fs) {
        TypeImpl type = (TypeImpl)this.getType(fs);
        return type == null ? null : TypeClass.values()[TypeSystemImpl.getTypeClass(type)];
    }

    @Override
    public TypeClass getTypeClass(FeatureStructure fs) {
        TypeImpl type = (TypeImpl)this.getType(fs);
        return type == null ? null : TypeClass.values()[TypeSystemImpl.getTypeClass(type)];
    }

    @Override
    public String ll_getValueAsString(int fsRef, LowLevelCAS llCas) {
        Object fs = llCas.ll_getFSForRef(fsRef);
        return this.getValueAsString((FeatureStructure)fs);
    }

    @Override
    public String getValueAsString(FeatureStructure fs) {
        TOP tgtFs = this.getTargetFs((TOP)fs);
        if (tgtFs == FEATURE_PATH_FAILED) {
            return null;
        }
        if (this.targetType == null) {
            return null;
        }
        switch (TypeSystemImpl.getTypeClass(this.targetType)) {
            case 0: {
                return null;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                this.verifyNoBuiltInFunction();
                return tgtFs.getFeatureValueAsString(this.targetFeature);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                if (this.builtInFunction > 0) {
                    return this.evaluateBuiltInFunction(tgtFs);
                }
                return ((CommonArrayFS)((Object)tgtFs)).getValuesAsCommaSeparatedString();
            }
            case 8: {
                if (tgtFs == null) {
                    return null;
                }
                if (this.builtInFunction > 0) {
                    return this.evaluateBuiltInFunction(tgtFs);
                }
                return tgtFs.toString();
            }
        }
        return null;
    }

    private void throwBuiltInFunctionException(String typeName) {
        String functionName = null;
        if (this.builtInFunction == 1) {
            functionName = FUNCTION_NAME_COVERED_TEXT;
        } else if (this.builtInFunction == 2) {
            functionName = FUNCTION_NAME_ID;
        } else if (this.builtInFunction == 3) {
            functionName = FUNCTION_NAME_TYPE_NAME;
        }
        throw new CASRuntimeException(MESSAGE_DIGEST, "BUILT_IN_FUNCTION_NOT_SUPPORTED", new Object[]{functionName, typeName});
    }

    private String evaluateBuiltInFunction(TOP returnFS) {
        if (this.builtInFunction == 1) {
            if (returnFS instanceof AnnotationFS) {
                return ((AnnotationFS)((Object)returnFS)).getCoveredText();
            }
            throw new CASRuntimeException(MESSAGE_DIGEST, "BUILT_IN_FUNCTION_NOT_SUPPORTED", new Object[]{FUNCTION_NAME_COVERED_TEXT, returnFS.getType().getName()});
        }
        if (this.builtInFunction == 2) {
            return Integer.toString(returnFS._id);
        }
        if (this.builtInFunction == 3) {
            return returnFS.getType().getName();
        }
        return null;
    }

    private TOP getTargetFs(TOP fs) {
        if (null == fs) {
            return FEATURE_PATH_FAILED;
        }
        if (this.featurePathElementNames.size() == 0) {
            this.targetType = fs._getTypeImpl();
            return fs;
        }
        if (this.boundBaseType == null || !this.boundBaseType.subsumes(fs._getTypeImpl())) {
            this.boundFeatures.clear();
            this.boundBaseType = fs._getTypeImpl();
        }
        TOP currentFs = fs;
        TypeImpl rangeType = null;
        int rangeTypeClass = -1;
        block5: for (int i = 0; i < this.featurePathElementNames.size(); ++i) {
            if (currentFs == null) {
                return FEATURE_PATH_FAILED;
            }
            if (i < this.boundFeatures.size()) {
                this.targetFeature = this.boundFeatures.get(i);
                if (!((TypeImpl)this.targetFeature.getDomain()).subsumes(currentFs._getTypeImpl())) {
                    this.setTargetFeature(currentFs, i);
                }
            } else {
                this.setTargetFeature(currentFs, i);
            }
            this.targetType = rangeType = this.targetFeature.getRangeImpl();
            rangeTypeClass = TypeSystemImpl.getTypeClass(rangeType);
            switch (rangeTypeClass) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    return currentFs;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    return currentFs.getFeatureValue(this.targetFeature);
                }
                case 8: {
                    TypeSystemUtils.PathValid pathValid;
                    currentFs = currentFs.getFeatureValue(this.targetFeature);
                    if (currentFs != null) continue block5;
                    if (i != this.featurePathElementNames.size() - 1 && (pathValid = TypeSystemUtils.isPathValid(this.boundBaseType, this.featurePathElementNames)) == TypeSystemUtils.PathValid.POSSIBLE) {
                        this.targetType = null;
                    }
                    return null;
                }
                default: {
                    throw new CASRuntimeException("INTERNAL_ERROR", new Object[0]);
                }
            }
        }
        return currentFs;
    }

    private void setTargetFeature(TOP currentFs, int i) {
        this.targetFeature = currentFs._getTypeImpl().getFeatureByBaseName(this.featurePathElementNames.get(i));
        if (this.targetFeature == null) {
            throw new CASRuntimeException(MESSAGE_DIGEST, "INVALID_FEATURE_PATH_FEATURE_NOT_DEFINED", new Object[]{this.getFeaturePathString(), currentFs._getTypeImpl().getName(), this.featurePathElementNames.get(i)});
        }
        this.boundFeatures.add(this.targetFeature);
    }

    private void verifyNoBuiltInFunction() {
        if (this.builtInFunction > 0) {
            this.throwBuiltInFunctionException(this.targetFeature.getRangeImpl().getName());
        }
    }

    private String getFeaturePathString() {
        StringBuilder sb = new StringBuilder();
        if (this.featurePathElementNames.size() == 0) {
            if (this.pathStartsWithSlash) {
                sb.append('/');
            }
        } else {
            for (String s : this.featurePathElementNames) {
                sb.append('/').append(s);
            }
        }
        this.appendBuiltInFunction(sb);
        return sb.toString();
    }

    private void appendBuiltInFunction(StringBuilder sb) {
        if (this.builtInFunction > 0) {
            sb.append(':').append(this.originalBuiltInName);
        }
    }
}

