/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.Comparator;
import java.util.NoSuchElementException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.FsIndex_iicp;
import org.apache.uima.cas.impl.FsIndex_set_sorted;
import org.apache.uima.cas.impl.FsIterator_multiple_indexes;
import org.apache.uima.cas.impl.FsIterator_set_sorted2;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;

public class FsIterator_subtypes_ordered<T extends FeatureStructure>
extends FsIterator_multiple_indexes<T> {
    private static final boolean DEBUG = false;
    private static final int SORTED_SECTION = 3;
    protected int lastValidIteratorIndex = -1;
    private boolean wentForward = true;
    private final FsIndex_iicp<T> iicp;

    public FsIterator_subtypes_ordered(FsIndex_iicp<T> iicp, Comparator<TOP> comparatorMaybeNoTypeWithoutId) {
        super(iicp, iicp.getIterators(), comparatorMaybeNoTypeWithoutId);
        this.iicp = iicp;
        FsIndex_set_sorted idx2 = (FsIndex_set_sorted)iicp.fsIndex_singletype;
        this.moveToFirstNoReinit();
    }

    @Override
    public void moveToFirstNoReinit() {
        int lvi = this.nonEmptyIterators.length - 1;
        int i = 0;
        while (i <= lvi) {
            LowLevelIterator it = this.nonEmptyIterators[i];
            it.moveToFirstNoReinit();
            if (it.isValid()) {
                this.heapify_up(it, i, 1);
                ++i;
                continue;
            }
            this.nonEmptyIterators[i] = this.nonEmptyIterators[lvi];
            this.nonEmptyIterators[lvi] = it;
            --lvi;
        }
        this.wentForward = true;
        this.lastValidIteratorIndex = lvi;
    }

    @Override
    public void moveToLastNoReinit() {
        int lvi = this.nonEmptyIterators.length - 1;
        int i = 0;
        while (i <= lvi) {
            LowLevelIterator it = this.nonEmptyIterators[i];
            it.moveToLastNoReinit();
            if (it.isValid()) {
                this.heapify_up(it, i, -1);
                ++i;
                continue;
            }
            this.nonEmptyIterators[i] = this.nonEmptyIterators[lvi];
            this.nonEmptyIterators[lvi] = it;
            --lvi;
        }
        this.wentForward = false;
        this.lastValidIteratorIndex = lvi;
    }

    @Override
    public void moveToNextNvc() {
        LowLevelIterator it0 = this.nonEmptyIterators[0];
        if (this.wentForward) {
            it0.moveToNextNvc();
            this.heapify_down(it0, 1);
        } else {
            this.moveToNextCmn(it0);
        }
    }

    private void moveToNextCmn(LowLevelIterator<T> it0) {
        int lvi = this.nonEmptyIterators.length - 1;
        int i = 1;
        while (i <= lvi) {
            LowLevelIterator it = this.nonEmptyIterators[i];
            if (!it.isValid()) {
                it.moveToFirstNoReinit();
            }
            while (it.isValid() && this.is_before(it, it0, 1)) {
                it.moveToNextNvc();
            }
            if (it.isValid()) {
                this.heapify_up(it, i, 1);
                ++i;
                continue;
            }
            this.nonEmptyIterators[i] = this.nonEmptyIterators[lvi];
            this.nonEmptyIterators[lvi] = it;
            --lvi;
        }
        this.lastValidIteratorIndex = lvi;
        this.wentForward = true;
        it0.moveToNext();
        this.heapify_down(it0, 1);
    }

    @Override
    public void moveToPreviousNvc() {
        LowLevelIterator it0 = this.nonEmptyIterators[0];
        if (!this.wentForward) {
            it0.moveToPreviousNvc();
            this.heapify_down(it0, -1);
        } else {
            int lvi = this.nonEmptyIterators.length - 1;
            int i = 1;
            while (i <= lvi) {
                LowLevelIterator it = this.nonEmptyIterators[i];
                if (!it.isValid()) {
                    it.moveToLastNoReinit();
                }
                while (it.isValid() && this.is_before(it, it0, -1)) {
                    it.moveToPrevious();
                }
                if (it.isValid()) {
                    this.heapify_up(it, i, -1);
                    ++i;
                    continue;
                }
                this.nonEmptyIterators[i] = this.nonEmptyIterators[lvi];
                this.nonEmptyIterators[lvi] = it;
                --lvi;
            }
            this.lastValidIteratorIndex = lvi;
            this.wentForward = false;
            it0.moveToPrevious();
            this.heapify_down(it0, -1);
        }
    }

    private boolean is_before(LowLevelIterator<T> l, LowLevelIterator<T> r, int dir) {
        int d = this.compare((FeatureStructure)l.getNvc(), (FeatureStructure)r.getNvc());
        return d * dir < 0;
    }

    private int compare(FeatureStructure fsLeft, FeatureStructure fsRight) {
        int d = this.comparatorMaybeNoTypeWithoutId.compare((TOP)fsLeft, (TOP)fsRight);
        if (d == 0) {
            d = fsLeft._id() - fsRight._id();
        }
        return d;
    }

    private void heapify_up(LowLevelIterator<T> it, int idx, int dir) {
        int nidx;
        while (idx > 3) {
            nidx = idx + 3 - 1 >> 1;
            if (!this.is_before(it, this.nonEmptyIterators[nidx], dir)) {
                this.nonEmptyIterators[idx] = it;
                return;
            }
            this.nonEmptyIterators[idx] = this.nonEmptyIterators[nidx];
            idx = nidx;
        }
        while (idx > 0) {
            nidx = idx - 1;
            if (!this.is_before(it, this.nonEmptyIterators[nidx], dir)) {
                this.nonEmptyIterators[idx] = it;
                return;
            }
            this.nonEmptyIterators[idx] = this.nonEmptyIterators[nidx];
            idx = nidx;
        }
        this.nonEmptyIterators[idx] = it;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void heapify_down(LowLevelIterator<T> it, int dir) {
        int num;
        if (!it.isValid()) {
            LowLevelIterator itl = this.nonEmptyIterators[this.lastValidIteratorIndex];
            this.nonEmptyIterators[this.lastValidIteratorIndex] = it;
            this.nonEmptyIterators[0] = itl;
            --this.lastValidIteratorIndex;
            it = itl;
        }
        if ((num = this.lastValidIteratorIndex) < 1 || !this.is_before(this.nonEmptyIterators[1], it, dir)) {
            return;
        }
        int idx = 1;
        this.nonEmptyIterators[0] = this.nonEmptyIterators[1];
        int end = Math.min(num, 3);
        int nidx = idx + 1;
        try {
            while (nidx <= end) {
                if (!this.is_before(this.nonEmptyIterators[nidx], it, dir)) {
                    return;
                }
                this.nonEmptyIterators[idx] = this.nonEmptyIterators[nidx];
                idx = nidx;
                nidx = idx + 1;
            }
            nidx = 4;
            while (nidx <= num) {
                if (nidx < num && this.is_before(this.nonEmptyIterators[nidx + 1], this.nonEmptyIterators[nidx], dir)) {
                    ++nidx;
                }
                if (!this.is_before(this.nonEmptyIterators[nidx], it, dir)) {
                    return;
                }
                this.nonEmptyIterators[idx] = this.nonEmptyIterators[nidx];
                idx = nidx;
                nidx = (nidx << 1) - 2;
            }
        }
        finally {
            this.nonEmptyIterators[idx] = it;
        }
    }

    @Override
    public boolean isValid() {
        return this.lastValidIteratorIndex >= 0;
    }

    @Override
    public T getNvc() throws NoSuchElementException {
        return this.nonEmptyIterators[0].get();
    }

    @Override
    public void moveToNoReinit(FeatureStructure fs) {
        int lastValidIterator_local = this.nonEmptyIterators.length - 1;
        int i = 0;
        while (i <= lastValidIterator_local) {
            LowLevelIterator it = this.nonEmptyIterators[i];
            it.moveToNoReinit(fs);
            if (!it.isValid()) {
                it.moveToLastNoReinit();
                boolean wentBack = false;
                while (it.isValid() && this.comparatorMaybeNoTypeWithoutId.compare((TOP)it.get(), (TOP)fs) == 0) {
                    it.moveToPreviousNvc();
                    wentBack = true;
                }
                if (!it.isValid()) {
                    if (wentBack) {
                        it.moveToFirst();
                    }
                } else {
                    it.moveToNext();
                }
            } else {
                it.moveToPrevious();
                while (it.isValid() && this.comparatorMaybeNoTypeWithoutId.compare((TOP)it.get(), (TOP)fs) == 0) {
                    it.moveToPreviousNvc();
                }
                if (!it.isValid()) {
                    it.moveToFirst();
                } else {
                    it.moveToNext();
                }
            }
            if (it.isValid()) {
                this.heapify_up(it, i, 1);
                ++i;
                continue;
            }
            this.nonEmptyIterators[i] = this.nonEmptyIterators[lastValidIterator_local];
            this.nonEmptyIterators[lastValidIterator_local] = it;
            --lastValidIterator_local;
        }
        this.wentForward = true;
        this.lastValidIteratorIndex = lastValidIterator_local;
    }

    @Override
    public FSIterator<T> copy() {
        FsIterator_subtypes_ordered<T> it = new FsIterator_subtypes_ordered<T>(this.iicp, this.comparatorMaybeNoTypeWithoutId);
        if (!this.isValid()) {
            it.moveToPrevious();
        } else {
            T posFs = this.getNvc();
            it.moveToNoReinit((FeatureStructure)posFs);
            while (it.get() != posFs) {
                it.moveToNext();
            }
        }
        return it;
    }

    @Override
    public Comparator<TOP> getComparator() {
        return this.comparatorMaybeNoTypeWithoutId;
    }

    @Override
    public boolean isMoveToSupported() {
        return true;
    }

    private void dumpIteratorInfo(String context) {
        StringBuilder sb = new StringBuilder();
        for (LowLevelIterator it : this.nonEmptyIterators) {
            FsIterator_set_sorted2 it2 = (FsIterator_set_sorted2)it;
            sb.append(String.format("  [%s@%d] %s %b pos:%d ", it.getClass().getSimpleName(), System.identityHashCode(it), it.getType(), it.isValid(), it2.pos));
            if (it.isValid()) {
                Annotation a = (Annotation)it.get();
                sb.append(String.format("%s@[%d-%d]", a.getType().getShortName(), a.getBegin(), a.getEnd()));
            } else {
                sb.append("<invalid>");
            }
            sb.append("\n");
        }
        System.out.printf("[%s@%d] %s (lvi: %d  wentForward:%b)%n%s", this.getClass().getSimpleName(), System.identityHashCode(this), context, this.lastValidIteratorIndex, this.wentForward, sb);
    }
}

