/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.common;

import java.io.Serializable;

public interface IDuccCompletionType
extends Serializable {

    public static enum ReservationCompletionType {
        Error,
        CanceledByAdmin,
        CanceledByUser,
        CanceledBySystem,
        ResourcesUnavailable,
        Undefined;


        public static String getToolTip(ReservationCompletionType type) {
            String retVal = null;
            switch (type) {
                case Error: {
                    retVal = "Reservation finished with error";
                    break;
                }
                case CanceledByAdmin: {
                    retVal = "Reservation was canceled by administrator";
                    break;
                }
                case CanceledByUser: {
                    retVal = "Reservation was canceled by user";
                    break;
                }
                case CanceledBySystem: {
                    retVal = "Reservation was canceled by system";
                    break;
                }
                case ResourcesUnavailable: {
                    retVal = "Job was terminated by system - insufficient resources";
                }
            }
            return retVal;
        }
    }

    public static enum JobCompletionType {
        Premature,
        Lost,
        EndOfJob,
        Error,
        Warning,
        NoWorkItemsFound,
        CanceledByUser,
        CanceledByAdministrator,
        CanceledByDriver,
        CanceledBySystem,
        ServicesUnavailable,
        ResourcesUnavailable,
        DriverInitializationFailure,
        CanceledByHealthMonitor,
        DriverProcessFailed,
        ExcessiveInitializationFailures,
        ExcessiveProcessFailures,
        ProcessInitializationFailure,
        ProcessFailure,
        LaunchFailure,
        ProgramExit,
        Undefined;


        public static String getToolTip(JobCompletionType type) {
            String retVal = null;
            switch (type) {
                case Premature: {
                    retVal = "Job was terminated, but not all work items processed";
                    break;
                }
                case EndOfJob: {
                    retVal = "Job finished without error";
                    break;
                }
                case Error: {
                    retVal = "Job finished with error";
                    break;
                }
                case CanceledByUser: {
                    retVal = "Job was canceled by user";
                    break;
                }
                case CanceledByDriver: {
                    retVal = "Job was canceled by driver";
                    break;
                }
                case CanceledBySystem: {
                    retVal = "Job was canceled by system";
                    break;
                }
                case ServicesUnavailable: {
                    retVal = "Job was terminated by system - one or more services unavailable";
                    break;
                }
                case ResourcesUnavailable: {
                    retVal = "Job was terminated by system - insufficient resources";
                    break;
                }
                case DriverInitializationFailure: {
                    retVal = "Job was terminated by system - driver initialization failure";
                    break;
                }
                case CanceledByHealthMonitor: {
                    retVal = "Job was terminated by health monitor";
                    break;
                }
                case DriverProcessFailed: {
                    retVal = "Job was terminated by health monitor - driver process failed";
                    break;
                }
                case ProcessInitializationFailure: {
                    retVal = "Job was terminated by health monitor - (excessive) process initialization failure";
                    break;
                }
                case ProcessFailure: {
                    retVal = "Job was terminated by health monitor - (excessive) process failure";
                }
            }
            return retVal;
        }
    }
}

