/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.common;

import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IProcessState;

public class DuccProcessHelper {
    public static boolean isFailedProcess(IDuccProcess process) {
        boolean retVal = false;
        if (process != null) {
            IProcessState.ProcessState processState = process.getProcessState();
            switch (processState) {
                case Failed: 
                case Stopped: 
                case Killed: {
                    DuccProcessHelper.normalizeReasonForStoppingProcess(process);
                    retVal = DuccProcessHelper.isUserFailureReasonForStoppingProcess(process);
                }
            }
        }
        return retVal;
    }

    private static String normalizeReasonForStoppingProcess(IDuccProcess process) {
        String retVal = IDuccProcess.ReasonForStoppingProcess.Unexplained.name();
        if (process != null) {
            String reason = process.getReasonForStoppingProcess();
            if (reason != null) {
                if (reason.trim().length() > 0) {
                    retVal = reason;
                } else {
                    process.setReasonForStoppingProcess(retVal);
                }
            } else {
                process.setReasonForStoppingProcess(retVal);
            }
        }
        return retVal;
    }

    public static boolean isUserFailureReasonForStoppingProcess(IDuccProcess process) {
        String reason;
        boolean retVal = false;
        if (process != null && (reason = process.getReasonForStoppingProcess()) != null) {
            if (reason.equals(IDuccProcess.ReasonForStoppingProcess.Croaked.name())) {
                retVal = true;
            } else if (reason.equals(IDuccProcess.ReasonForStoppingProcess.ExceededShareSize.name())) {
                retVal = true;
            } else if (reason.equals(IDuccProcess.ReasonForStoppingProcess.ExceededSwapThreshold.name())) {
                retVal = true;
            } else if (reason.equals(IDuccProcess.ReasonForStoppingProcess.ExceededErrorThreshold.name())) {
                retVal = true;
            } else if (reason.equals(IDuccProcess.ReasonForStoppingProcess.Unexplained.name())) {
                retVal = true;
            }
        }
        return retVal;
    }
}

