/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.state.monitoring;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.uima.ducc.common.persistence.rm.IRmPersistence;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.ws.state.monitoring.INodeState;

public class NodeState
implements INodeState {
    private static DuccLogger logger = DuccLogger.getLogger(NodeState.class);
    private static DuccId jobid = null;
    private static INodeState instance = null;
    private Map<String, Map<String, Object>> map_empty = new HashMap<String, Map<String, Object>>();
    private Map<String, Map<String, Object>> map = this.map_empty;
    private Monitor monitor = null;
    private String key_online = "online";
    private String key_quiesced = "quiesced";

    public static INodeState getInstance() {
        if (instance == null) {
            instance = new NodeState();
        }
        return instance;
    }

    private NodeState() {
        this.start();
    }

    @Override
    public void start() {
        if (this.monitor == null) {
            this.monitor = new Monitor();
            this.monitor.start();
            this.monitor.up();
        }
    }

    @Override
    public void stop() {
        if (this.monitor != null) {
            this.monitor.down();
            this.monitor = null;
        }
    }

    @Override
    public boolean status() {
        boolean retVal = false;
        if (this.monitor != null) {
            this.monitor.status();
        }
        return retVal;
    }

    @Override
    public String getOnline(String node, String otherwise) {
        String location = "getOnline";
        String retVal = otherwise;
        if (node != null) {
            if (this.map.size() > 0) {
                for (Map.Entry<String, Map<String, Object>> entry : this.map.entrySet()) {
                    String key = entry.getKey();
                    if (key.equals(node)) {
                        logger.debug(location, jobid, new Object[]{key + "==" + node});
                        Map<String, Object> value = entry.getValue();
                        Boolean value_online = (Boolean)value.get(this.key_online);
                        retVal = "" + value_online;
                        logger.debug(location, jobid, new Object[]{node + "==" + retVal});
                        break;
                    }
                    logger.debug(location, jobid, new Object[]{key + "!=" + node});
                }
            } else {
                logger.warn(location, jobid, new Object[]{"size:0"});
            }
        } else {
            logger.error(location, jobid, new Object[]{"node:" + node});
        }
        return retVal;
    }

    @Override
    public String getQuiesced(String node, String otherwise) {
        String location = "getQuiesced";
        String retVal = otherwise;
        if (node != null) {
            if (this.map.size() > 0) {
                for (Map.Entry<String, Map<String, Object>> entry : this.map.entrySet()) {
                    String key = entry.getKey();
                    if (key.equals(node)) {
                        logger.debug(location, jobid, new Object[]{key + "==" + node});
                        Map<String, Object> value = entry.getValue();
                        Boolean value_quiesced = (Boolean)value.get(this.key_quiesced);
                        retVal = "" + value_quiesced;
                        logger.debug(location, jobid, new Object[]{node + "==" + retVal});
                        break;
                    }
                    logger.debug(location, jobid, new Object[]{key + "!=" + node});
                }
            } else {
                logger.warn(location, jobid, new Object[]{"size:0"});
            }
        } else {
            logger.error(location, jobid, new Object[]{"node:" + node});
        }
        return retVal;
    }

    private class Monitor
    extends Thread {
        private AtomicBoolean run_flag = new AtomicBoolean(true);
        private long sleep_seconds = 60L;
        private long sleep_millis = this.sleep_seconds * 1000L;
        private IRmPersistence persistence = null;

        public Monitor() {
            this.initialize();
        }

        private void initialize() {
            String location = "initialize";
            try {
                this.up();
                this.persistence = this.configure();
            }
            catch (Exception e) {
                this.down();
                logger.error(location, jobid, (Throwable)e, new Object[0]);
            }
        }

        @Override
        public void run() {
            String location = "";
            logger.info(location, jobid, new Object[]{"start"});
            while (this.run_flag.get()) {
                try {
                    NodeState.this.map = this.fetch();
                    Thread.sleep(this.sleep_millis);
                }
                catch (Exception exception) {}
            }
            logger.info(location, jobid, new Object[]{"stop"});
        }

        public void up() {
            this.run_flag.set(true);
        }

        public void down() {
            this.run_flag.set(false);
        }

        public boolean status() {
            return this.run_flag.get();
        }

        private IRmPersistence configure() throws Exception {
            String location = "configure";
            IRmPersistence retVal = null;
            String class_name = System.getProperty("ducc.rm.persistence.impl");
            logger.debug(location, jobid, new Object[]{class_name});
            Class<?> iss = Class.forName(class_name);
            retVal = (IRmPersistence)iss.newInstance();
            retVal.init(logger);
            return retVal;
        }

        private Map<String, Map<String, Object>> fetch() throws Exception {
            String location = "fetch";
            Map retVal = NodeState.this.map_empty;
            try {
                if (this.persistence != null) {
                    retVal = this.persistence.getAllMachines();
                }
                logger.debug(location, jobid, new Object[]{"map:" + retVal.size()});
            }
            catch (Exception e) {
                logger.error(location, jobid, (Throwable)e, new Object[0]);
            }
            return retVal;
        }
    }
}

