/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;

public class DuccCookies {
    private static DuccLogger duccLogger = DuccLogger.getLogger(DuccCookies.class);
    private static DuccId jobid = null;
    private static Messages messages = Messages.getInstance();
    public static final String cookieUri = "/";
    public static final String duccCookiePrefix = "DUCC";
    private static final String refreshmode = "refreshmode";
    private static final String valueRefreshmodeAutomatic = "automatic";
    private static final String valueRefreshmodeManual = "manual";
    private static final String jobs = "jobs";
    private static final String reservations = "reservations";
    private static final String services = "services";
    public static final String max = "max";
    public static final String users = "users";
    public static final String cookieRefreshMode = "DUCCrefreshmode";
    public static final String cookieJobsMax = "DUCCjobsmax";
    public static final String cookieJobsUsers = "DUCCjobsusers";
    public static final String cookieReservationsMax = "DUCCreservationsmax";
    public static final String cookieReservationsUsers = "DUCCreservationsusers";
    public static final String cookieServicesMax = "DUCCservicesmax";
    public static final String cookieServicesUsers = "DUCCservicesusers";
    private static final String agents = "agents";
    public static final String cookieAgents = "DUCCagents";
    public static final String valueAgentsShow = "show";
    private static final String table_style = "table_style";
    private static final String date_style = "date_style";
    private static final String description_style = "description_style";
    private static final String display_style = "display_style";
    private static final String filter_users_style = "filter_users_style";
    private static final String role = "role";
    private static final String uid = "uid";
    public static final String cookieStyleTable = "DUCCtable_style";
    public static final String cookieStyleDate = "DUCCdate_style";
    public static final String cookieStyleDescription = "DUCCdescription_style";
    public static final String cookieStyleDisplay = "DUCCdisplay_style";
    public static final String cookieStyleFilterUsers = "DUCCfilter_users_style";
    public static final String cookieRole = "DUCCrole";
    public static final String cookieUid = "DUCCuid";
    public static final String valueStyleDateLong = "long";
    public static final String valueStyleDateMedium = "medium";
    public static final String valueStyleDateShort = "short";
    public static final String valueStyleDateDefault = "long";
    public static final String valueStyleDescriptionLong = "long";
    public static final String valueStyleDescriptionShort = "short";
    public static final String valueStyleDescriptionDefault = "long";
    public static final String valueStyleDisplayTextual = "textual";
    public static final String valueStyleDisplayVisual = "visual";
    public static final String valueStyleDisplayDefault = "textual";
    public static final String valueStyleFilterUsersInclude = "include";
    public static final String valueStyleFilterUsersIncludePlusActive = "include+active";
    public static final String valueStyleFilterUsersExclude = "exclude";
    public static final String valueStyleFilterUsersExcludePlusActive = "exclude+active";
    public static final String valueRoleAdministrator = "administrator";
    public static final String valueRoleUser = "user";

    protected static final String getCookieKey(String name) {
        return "DUCCname";
    }

    public static String getCookie(String defaultValue, HttpServletRequest request, String name) {
        String methodName = "getCookie";
        String retVal = defaultValue;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                String cookieName;
                Cookie cookie = cookies[i];
                if (cookie == null || (cookieName = cookie.getName()) == null || !cookieName.equals(name)) continue;
                retVal = cookie.getValue();
                break;
            }
        }
        duccLogger.trace(methodName, null, new Object[]{messages.fetchLabel("name") + name + " " + messages.fetchLabel("value") + retVal});
        return retVal;
    }

    public static String getCookie(HttpServletRequest request, String name) {
        return DuccCookies.getCookie("", request, name);
    }

    protected static String getCookieOrNull(HttpServletRequest request, String name) {
        return DuccCookies.getCookie(null, request, name);
    }

    protected static void putCookie(HttpServletResponse response, String name, String value) {
        String methodName = "putCookie";
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(cookieUri);
        response.addCookie(cookie);
        duccLogger.trace(methodName, null, new Object[]{messages.fetchLabel("name") + name + " " + messages.fetchLabel("value") + value});
    }

    protected static void expireCookie(HttpServletResponse response, String name, String value) {
        String methodName = "expireCookie";
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(0);
        response.addCookie(cookie);
        duccLogger.trace(methodName, null, new Object[]{messages.fetchLabel("name") + name + " " + messages.fetchLabel("value") + value});
    }

    public static DateStyle getDateStyle(HttpServletRequest request) {
        DateStyle dateStyle = DateStyle.Long;
        try {
            String cookie = DuccCookies.getCookie(request, cookieStyleDate);
            if (cookie.equals("long")) {
                dateStyle = DateStyle.Long;
            } else if (cookie.equals(valueStyleDateMedium)) {
                dateStyle = DateStyle.Medium;
            } else if (cookie.equals("short")) {
                dateStyle = DateStyle.Short;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dateStyle;
    }

    public static RefreshMode getRefreshMode(HttpServletRequest request) {
        RefreshMode refreshMode = RefreshMode.Automatic;
        try {
            String cookie = DuccCookies.getCookie(request, cookieRefreshMode);
            if (cookie.equals(valueRefreshmodeAutomatic)) {
                refreshMode = RefreshMode.Automatic;
            } else if (cookie.equals(valueRefreshmodeManual)) {
                refreshMode = RefreshMode.Manual;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return refreshMode;
    }

    public static DescriptionStyle getDescriptionStyle(HttpServletRequest request) {
        DescriptionStyle descriptionStyle = DescriptionStyle.Long;
        try {
            String cookie = DuccCookies.getCookie(request, cookieStyleDescription);
            if (cookie.equals("long")) {
                descriptionStyle = DescriptionStyle.Long;
            } else if (cookie.equals("short")) {
                descriptionStyle = DescriptionStyle.Short;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return descriptionStyle;
    }

    public static DisplayStyle getDisplayStyle(HttpServletRequest request) {
        DisplayStyle displayStyle = DisplayStyle.Textual;
        try {
            String cookie = DuccCookies.getCookie(request, cookieStyleDisplay);
            if (cookie.equals("textual")) {
                displayStyle = DisplayStyle.Textual;
            } else if (cookie.equals(valueStyleDisplayVisual)) {
                displayStyle = DisplayStyle.Visual;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return displayStyle;
    }

    public static FilterUsersStyle getFilterUsersStyle(HttpServletRequest request) {
        FilterUsersStyle filterUsersStyle = FilterUsersStyle.Include;
        try {
            String cookie = DuccCookies.getCookie(request, cookieStyleFilterUsers);
            if (cookie.equals(valueStyleFilterUsersInclude)) {
                filterUsersStyle = FilterUsersStyle.Include;
            } else if (cookie.equals(valueStyleFilterUsersIncludePlusActive)) {
                filterUsersStyle = FilterUsersStyle.IncludePlusActive;
            } else if (cookie.equals(valueStyleFilterUsersExclude)) {
                filterUsersStyle = FilterUsersStyle.Exclude;
            } else if (cookie.equals(valueStyleFilterUsersExcludePlusActive)) {
                filterUsersStyle = FilterUsersStyle.ExcludePlusActive;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return filterUsersStyle;
    }

    public static RequestRole getRole(HttpServletRequest request) {
        RequestRole role = RequestRole.User;
        try {
            String cookie = DuccCookies.getCookie(request, cookieRole);
            if (cookie.equals(valueRoleAdministrator)) {
                role = RequestRole.Administrator;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return role;
    }

    public static String getUid(HttpServletRequest request) {
        String location = "getUid";
        String uid = null;
        try {
            String cookie;
            uid = cookie = DuccCookies.getCookie(null, request, cookieUid);
            duccLogger.debug(location, jobid, new Object[]{"DUCCuid:" + uid});
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uid;
    }

    public static enum RequestRole {
        Administrator,
        User;

    }

    public static enum FilterUsersStyle {
        Include,
        IncludePlusActive,
        Exclude,
        ExcludePlusActive;

    }

    public static enum DisplayStyle {
        Textual,
        Visual;

    }

    public static enum DescriptionStyle {
        Long,
        Short;

    }

    public static enum RefreshMode {
        Automatic,
        Manual;

    }

    public static enum DateStyle {
        Long,
        Medium,
        Short;

    }
}

