/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws;

import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.ws.PagingInfo;

public class PagingObserver {
    private static PagingObserver instance = new PagingObserver();
    public static int intervalInSeconds = 60;
    private ConcurrentSkipListMap<DuccId, PagingInfo> mapData = new ConcurrentSkipListMap();
    private ConcurrentSkipListMap<DuccId, PagingInfo> mapDiff = new ConcurrentSkipListMap();

    public static PagingObserver getInstance() {
        return instance;
    }

    public void put(IDuccWork dw) {
        IDuccWorkJob job;
        if (dw != null && dw instanceof IDuccWorkJob && !(job = (IDuccWorkJob)dw).isCompleted()) {
            this.put(job);
        }
    }

    private void update(DuccId id, PagingInfo pCurr, PagingInfo pPrev) {
        PagingInfo pDiff = new PagingInfo(pCurr.total - pPrev.total, pCurr.procs - pPrev.procs);
        this.mapData.put(id, pCurr);
        this.mapDiff.put(id, pDiff);
    }

    public void put(IDuccWorkJob job) {
        DuccId id;
        if (job != null && (id = job.getDuccId()) != null) {
            PagingInfo pCurr = new PagingInfo(job);
            PagingInfo pPrev = this.mapData.get(id);
            if (pPrev == null) {
                this.update(id, pCurr, pCurr);
            } else {
                long elapsedMillis = pCurr.timestamp - pPrev.timestamp;
                if (elapsedMillis > (long)(intervalInSeconds * 1000)) {
                    this.update(id, pCurr, pPrev);
                }
            }
        }
    }

    public void remove(DuccId duccId) {
        if (duccId != null) {
            this.mapData.remove(duccId);
            this.mapDiff.remove(duccId);
        }
    }

    public PagingInfo getData(DuccId duccId) {
        PagingInfo retVal = null;
        if (duccId != null) {
            retVal = this.mapData.get(duccId);
        }
        if (retVal == null) {
            retVal = new PagingInfo();
        }
        return retVal;
    }

    public PagingInfo getDiff(DuccId duccId) {
        PagingInfo retVal = null;
        if (duccId != null) {
            retVal = this.mapDiff.get(duccId);
        }
        if (retVal == null) {
            retVal = new PagingInfo();
        }
        return retVal;
    }

    public long getDiffCount(DuccId duccId) {
        return this.getDiff((DuccId)duccId).total;
    }

    public boolean isPaging(DuccId duccId) {
        return this.getDiffCount(duccId) > 0L;
    }

    public boolean isPaging(IDuccWorkJob job) {
        boolean retVal = false;
        if (job != null) {
            DuccId duccId = job.getDuccId();
            retVal = this.isPaging(duccId);
        }
        return retVal;
    }

    public static void main(String[] args) {
        PagingObserver po = PagingObserver.getInstance();
        DuccId id = null;
        po.remove(id);
        id = new DuccId(0L);
        po.remove(id);
        PagingInfo pi = new PagingInfo();
        pi.display();
        DuccWorkJob job = new DuccWorkJob();
        pi = new PagingInfo((IDuccWorkJob)job);
        pi.display();
    }
}

