/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.launcher;

import org.apache.uima.ducc.agent.launcher.CommandBuilder;
import org.apache.uima.ducc.agent.launcher.ICommand;
import org.apache.uima.ducc.agent.launcher.ManagedProcess;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.transport.cmdline.ICommandLine;
import org.apache.uima.ducc.transport.cmdline.NonJavaCommandLine;

public class SigKillCommand
implements ICommand {
    private static final String SIGKILL = "-9";
    private String[] sigKillCmdLine;
    private final DuccLogger logger;
    private final ManagedProcess deployProcess;

    public SigKillCommand(ManagedProcess managedProcess, DuccLogger logger) {
        NonJavaCommandLine cmdL = new NonJavaCommandLine("/bin/kill");
        this.logger = logger;
        this.deployProcess = managedProcess;
        cmdL.addArgument(SIGKILL);
        cmdL.addArgument(managedProcess.getPid());
        this.sigKillCmdLine = CommandBuilder.deployableStopCommand((ICommandLine)cmdL, managedProcess);
    }

    @Override
    public Integer call() {
        String methodName = "SigKillCommand.call";
        ProcessBuilder processBuilder = new ProcessBuilder(this.sigKillCmdLine);
        try {
            StringBuilder sb = new StringBuilder("--->Killing Process ");
            sb.append(" Using command line:");
            int inx = 0;
            for (String cmdPart : this.sigKillCmdLine) {
                sb.append("\n\t[").append(inx++).append("]").append(cmdPart);
            }
            this.logger.info(methodName, this.deployProcess.getDuccId(), new Object[]{sb.toString()});
            Process process = processBuilder.start();
            this.deployProcess.drainProcessStreams(process, this.logger, System.out, true);
            return process.waitFor();
        }
        catch (Exception e) {
            this.logger.warn(methodName, null, (Throwable)e, new Object[0]);
            return -1;
        }
    }
}

