/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.launcher;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.apache.uima.ducc.agent.launcher.ManagedProcess;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.common.utils.id.DuccIdFactory;
import org.apache.uima.ducc.transport.event.common.DuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IProcessState;

public class DefunctProcessDetector
implements Runnable {
    ManagedProcess childProcess;
    DuccLogger logger;

    public DefunctProcessDetector(ManagedProcess process, DuccLogger logger) {
        this.childProcess = process;
        this.logger = logger;
    }

    private boolean isDefunctProcess(String pid) throws Exception {
        boolean zombie = false;
        InputStreamReader in = null;
        String[] command = new String[]{"/bin/ps", "-ef", pid};
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command(command);
            pb.redirectErrorStream(true);
            Process childProcess = pb.start();
            in = new InputStreamReader(childProcess.getInputStream());
            BufferedReader reader = new BufferedReader(in);
            String line = null;
            while ((line = reader.readLine()) != null) {
                zombie = line.indexOf("defunct") > 0;
                if (!zombie) continue;
                this.logger.info("DefunctProcessDetector.isDefunctProcess", null, new Object[]{"Process with PID:" + pid + " Is Defunct - OS reports:" + line});
                break;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return zombie;
    }

    @Override
    public void run() {
        try {
            if (this.isDefunctProcess(this.childProcess.getPid())) {
                this.logger.info("DefunctProcessDetector.run()", this.childProcess.getDuccProcess().getDuccId(), new Object[]{"Process with PID:" + this.childProcess.getPid() + " Is Defunct - Changing State to Stopped"});
                this.childProcess.getDuccProcess().setProcessState(IProcessState.ProcessState.Stopped);
                this.childProcess.getDuccProcess().setReasonForStoppingProcess(IDuccProcess.ReasonForStoppingProcess.Defunct.name());
            } else {
                this.logger.debug("DefunctProcessDetector.run()", this.childProcess.getDuccProcess().getDuccId(), new Object[]{"Process with PID:" + this.childProcess.getPid() + " Not Defunct"});
            }
        }
        catch (Exception e) {
            this.logger.error("DefunctProcessDetector.run()", this.childProcess.getDuccProcess().getDuccId(), (Throwable)e, new Object[0]);
        }
    }

    public static void main(String[] args) {
        try {
            DuccLogger logger = new DuccLogger(DefunctProcessDetector.class);
            DuccIdFactory factory = new DuccIdFactory();
            DuccId duccId = factory.next();
            NodeIdentity nid = new NodeIdentity();
            DuccProcess process = new DuccProcess(duccId, nid);
            ManagedProcess p = new ManagedProcess((IDuccProcess)process, null);
            process.setProcessState(IProcessState.ProcessState.Initializing);
            process.setPID(args[0]);
            p.setPid(args[0]);
            DefunctProcessDetector detector = new DefunctProcessDetector(p, logger);
            detector.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

