/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sxpath.AbstractStaticContext;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.QNameValue;

public class IndependentContext
extends AbstractStaticContext
implements XPathStaticContext,
NamespaceResolver,
Serializable,
Container {
    private HashMap namespaces = new HashMap(10);
    private IntHashMap variables = new IntHashMap(20);
    private NamespaceResolver externalResolver = null;
    private Set importedSchemaNamespaces = Collections.EMPTY_SET;

    public IndependentContext() {
        this(new Configuration());
    }

    public IndependentContext(Configuration configuration) {
        this.setConfiguration(configuration);
        this.clearNamespaces();
        this.setDefaultFunctionLibrary();
    }

    public IndependentContext copy() {
        IndependentContext independentContext = new IndependentContext(this.getConfiguration());
        independentContext.setBaseURI(this.getBaseURI());
        independentContext.setLocationMap(this.getLocationMap());
        independentContext.setDefaultElementNamespace(this.getDefaultElementNamespace());
        independentContext.setDefaultFunctionNamespace(this.getDefaultFunctionNamespace());
        independentContext.namespaces = new HashMap(this.namespaces);
        independentContext.variables = new IntHashMap(10);
        independentContext.importedSchemaNamespaces = this.importedSchemaNamespaces;
        independentContext.externalResolver = this.externalResolver;
        return independentContext;
    }

    public void declareNamespace(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Null prefix supplied to declareNamespace()");
        }
        if (string2 == null) {
            throw new NullPointerException("Null namespace URI supplied to declareNamespace()");
        }
        if ("".equals(string)) {
            this.setDefaultElementNamespace(string2);
        } else {
            this.namespaces.put(string, string2);
            this.getNamePool().allocateNamespaceCode(string, string2);
        }
    }

    public void clearNamespaces() {
        this.namespaces.clear();
        this.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.declareNamespace("xsl", "http://www.w3.org/1999/XSL/Transform");
        this.declareNamespace("saxon", "http://saxon.sf.net/");
        this.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        this.declareNamespace("", "");
    }

    public void clearAllNamespaces() {
        this.namespaces.clear();
        this.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.declareNamespace("", "");
    }

    public void setNamespaces(NodeInfo nodeInfo) {
        this.namespaces.clear();
        int n = nodeInfo.getNodeKind();
        if (n == 2 || n == 3 || n == 8 || n == 7 || n == 13) {
            nodeInfo = nodeInfo.getParent();
        }
        if (nodeInfo == null) {
            return;
        }
        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)8);
        NodeInfo nodeInfo2;
        while ((nodeInfo2 = (NodeInfo)axisIterator.next()) != null) {
            String string = nodeInfo2.getLocalPart();
            if ("".equals(string)) {
                this.setDefaultElementNamespace(nodeInfo2.getStringValue());
                continue;
            }
            this.declareNamespace(nodeInfo2.getLocalPart(), nodeInfo2.getStringValue());
        }
        return;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.externalResolver = namespaceResolver;
    }

    public XPathVariable declareVariable(QNameValue qNameValue) {
        XPathVariable xPathVariable = XPathVariable.make(qNameValue, this.getConfiguration());
        int n = qNameValue.allocateNameCode(this.getNamePool()) & 0xFFFFF;
        int n2 = this.variables.size();
        xPathVariable.setSlotNumber(n2);
        this.variables.put(n, xPathVariable);
        return xPathVariable;
    }

    public int getSlotNumber(QNameValue qNameValue) {
        int n = qNameValue.allocateNameCode(this.getNamePool()) & 0xFFFFF;
        XPathVariable xPathVariable = (XPathVariable)this.variables.get(n);
        if (xPathVariable == null) {
            return -1;
        }
        return xPathVariable.getLocalSlotNumber();
    }

    public void issueWarning(String string, SourceLocator sourceLocator) {
        System.err.println(string);
    }

    public String getURIForPrefix(String string) throws XPathException {
        String string2 = this.getURIForPrefix(string, false);
        if (string2 == null) {
            throw new StaticError("Prefix " + string + " has not been declared");
        }
        return string2;
    }

    public NamespaceResolver getNamespaceResolver() {
        if (this.externalResolver != null) {
            return this.externalResolver;
        }
        return this;
    }

    public String getURIForPrefix(String string, boolean bl) {
        if (this.externalResolver != null) {
            return this.externalResolver.getURIForPrefix(string, bl);
        }
        if (string.equals("") && !bl) {
            if (bl) {
                return this.getDefaultElementNamespace();
            }
            return "";
        }
        return (String)this.namespaces.get(string);
    }

    public Iterator iteratePrefixes() {
        if (this.externalResolver != null) {
            return this.externalResolver.iteratePrefixes();
        }
        return this.namespaces.keySet().iterator();
    }

    public VariableReference bindVariable(int n) throws StaticError {
        XPathVariable xPathVariable = (XPathVariable)this.variables.get(n);
        if (xPathVariable == null) {
            throw new StaticError("Undeclared variable in a standalone expression");
        }
        return new VariableReference(xPathVariable);
    }

    public SlotManager getStackFrameMap() {
        SlotManager slotManager = this.getConfiguration().makeSlotManager();
        Iterator iterator = this.variables.valueIterator();
        while (iterator.hasNext()) {
            XPathVariable xPathVariable = (XPathVariable)iterator.next();
            QNameValue qNameValue = xPathVariable.getVariableQName();
            int n = this.getConfiguration().getNamePool().allocate(qNameValue.getPrefix(), qNameValue.getNamespaceURI(), qNameValue.getLocalName());
            slotManager.allocateSlotNumber(n & 0xFFFFF);
        }
        return slotManager;
    }

    public boolean isImportedSchema(String string) {
        return this.importedSchemaNamespaces.contains(string);
    }

    public Set getImportedSchemaNamespaces() {
        return this.importedSchemaNamespaces;
    }

    public void setImportedSchemaNamespaces(Set set) {
        this.importedSchemaNamespaces = set;
    }
}

