/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator.maintenance;

import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.OrchestratorCommonArea;
import org.apache.uima.ducc.orchestrator.StateManager;
import org.apache.uima.ducc.orchestrator.maintenance.HealthMonitor;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;

public class MaintenanceThread
extends Thread {
    private static final DuccLogger logger = DuccLogger.getLogger(MaintenanceThread.class);
    private static MaintenanceThread instance = new MaintenanceThread();
    private static DuccId jobid = null;
    private OrchestratorCommonArea orchestratorCommonArea = OrchestratorCommonArea.getInstance();
    private StateManager stateManager = StateManager.getInstance();
    private HealthMonitor healthMonitor = HealthMonitor.getInstance();
    private long minMillis = 1000L;
    private long wakeUpMillis;
    private long sleepTime = this.wakeUpMillis = 120000L;
    private long lastTime = System.currentTimeMillis();
    private boolean die = false;

    public static MaintenanceThread getInstance() {
        return instance;
    }

    private MaintenanceThread() {
        this.initialize();
    }

    private void initialize() {
        String location = "initialize";
        String maintenance_rate = DuccPropertiesResolver.getInstance().getProperty("ducc.orchestrator.maintenance.rate");
        if (maintenance_rate != null) {
            try {
                long rate = Long.parseLong(maintenance_rate);
                if (rate < this.minMillis) {
                    logger.error(location, jobid, new Object[]{"ducc.orchestrator.maintenance.rate < minimum of " + this.minMillis});
                } else {
                    this.sleepTime = this.wakeUpMillis = rate;
                }
            }
            catch (Throwable t) {
                logger.error(location, jobid, t, new Object[0]);
            }
        }
        logger.info(location, jobid, new Object[]{"rate:" + this.wakeUpMillis});
    }

    private boolean isTime() {
        boolean retVal = true;
        long currTime = System.currentTimeMillis();
        long diffTime = currTime - this.lastTime;
        if (diffTime < this.wakeUpMillis) {
            retVal = false;
            this.sleepTime = diffTime;
        } else {
            this.lastTime = currTime;
            this.sleepTime = this.wakeUpMillis;
        }
        return retVal;
    }

    @Override
    public void run() {
        String location = "run";
        logger.trace(location, jobid, new Object[]{"enter"});
        while (!this.die) {
            try {
                if (this.isTime()) {
                    DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
                    this.stateManager.prune(workMap);
                    this.healthMonitor.ajudicate();
                }
            }
            catch (Throwable t) {
                logger.error(location, jobid, t, new Object[0]);
            }
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (Throwable t) {
                logger.error(location, jobid, t, new Object[0]);
            }
        }
        logger.trace(location, jobid, new Object[]{"exit"});
    }
}

