/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator.database;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.uima.ducc.common.head.IDuccHead;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.database.DbOrchestratorProperties;
import org.apache.uima.ducc.orchestrator.DuccHead;

public class OrDbOrchestratorProperties
extends DbOrchestratorProperties {
    private static DuccLogger logger = DuccLogger.getLogger(OrDbOrchestratorProperties.class);
    private static DuccId jobid = null;
    private static OrDbOrchestratorProperties instance = null;
    private IDuccHead dh = DuccHead.getInstance();
    private AtomicBoolean resumeAnnounced = new AtomicBoolean(true);
    private AtomicBoolean suspendAnnounced = new AtomicBoolean(false);

    public static OrDbOrchestratorProperties getInstance() {
        String location = "getInstance";
        try {
            if (instance == null) {
                instance = new OrDbOrchestratorProperties();
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return instance;
    }

    private OrDbOrchestratorProperties() throws Exception {
        super(logger);
        super.dbInit();
    }

    private void resume() {
        String location = "resume";
        if (!this.resumeAnnounced.get()) {
            logger.warn(location, jobid, new Object[]{"operations resumed - master mode"});
            this.resumeAnnounced.set(true);
            this.suspendAnnounced.set(false);
        }
    }

    private void suspend() {
        String location = "suspend";
        if (!this.suspendAnnounced.get()) {
            logger.warn(location, jobid, new Object[]{"operations suspended - backup mode"});
            this.suspendAnnounced.set(true);
            this.resumeAnnounced.set(false);
        }
    }

    public void upsert(String name, String value) throws Exception {
        if (this.dh.is_ducc_head_virtual_master()) {
            this.resume();
            super.upsert(name, value);
        } else {
            this.suspend();
        }
    }
}

