/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator;

import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.TimeStamp;
import org.apache.uima.ducc.common.utils.id.IDuccIdFactory;
import org.apache.uima.ducc.orchestrator.OrchestratorCommonArea;
import org.apache.uima.ducc.orchestrator.utilities.MemorySpecification;
import org.apache.uima.ducc.transport.event.cli.ReservationRequestProperties;
import org.apache.uima.ducc.transport.event.cli.ReservationSpecificationProperties;
import org.apache.uima.ducc.transport.event.common.DuccSchedulingInfo;
import org.apache.uima.ducc.transport.event.common.DuccStandardInfo;
import org.apache.uima.ducc.transport.event.common.DuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IDuccSchedulingInfo;
import org.apache.uima.ducc.transport.event.common.IDuccStandardInfo;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;

public class ReservationFactory {
    private static ReservationFactory reservationFactory = new ReservationFactory();
    private static final DuccLogger logger = DuccLogger.getLogger(ReservationFactory.class);
    private OrchestratorCommonArea orchestratorCommonArea = OrchestratorCommonArea.getInstance();
    private Messages messages = this.orchestratorCommonArea.getSystemMessages();

    public static ReservationFactory getInstance() {
        return reservationFactory;
    }

    public DuccWorkReservation create(ReservationRequestProperties reservationRequestProperties) {
        String methodName = "create";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        IDuccIdFactory duccIdFactory = this.orchestratorCommonArea.getDuccIdFactory();
        DuccWorkReservation duccWorkReservation = new DuccWorkReservation();
        duccWorkReservation.setDuccId(duccIdFactory.next());
        duccWorkReservation.setDuccType(IDuccTypes.DuccType.Reservation);
        DuccStandardInfo standardInfo = new DuccStandardInfo();
        duccWorkReservation.setStandardInfo((IDuccStandardInfo)standardInfo);
        standardInfo.setUser(reservationRequestProperties.getProperty(ReservationSpecificationProperties.key_user));
        standardInfo.setSubmitter(reservationRequestProperties.getProperty(ReservationSpecificationProperties.key_submitter_pid_at_host));
        standardInfo.setDateOfSubmission(TimeStamp.getCurrentMillis());
        standardInfo.setDateOfCompletion(null);
        standardInfo.setDescription(reservationRequestProperties.getProperty(ReservationSpecificationProperties.key_description));
        DuccSchedulingInfo schedulingInfo = new DuccSchedulingInfo();
        duccWorkReservation.setSchedulingInfo((IDuccSchedulingInfo)schedulingInfo);
        schedulingInfo.setSchedulingClass(reservationRequestProperties.getProperty(ReservationSpecificationProperties.key_scheduling_class));
        String memorySize = reservationRequestProperties.getProperty(ReservationSpecificationProperties.key_memory_size);
        MemorySpecification memorySpecification = new MemorySpecification(memorySize);
        schedulingInfo.setMemorySizeRequested(memorySpecification.getSize());
        schedulingInfo.setMemoryUnits(memorySpecification.getMemoryUnits());
        logger.info(methodName, duccWorkReservation.getDuccId(), new Object[]{this.messages.fetchLabel("user") + standardInfo.getUser()});
        logger.info(methodName, duccWorkReservation.getDuccId(), new Object[]{this.messages.fetchLabel("description") + standardInfo.getDescription()});
        logger.info(methodName, duccWorkReservation.getDuccId(), new Object[]{this.messages.fetchLabel("class") + schedulingInfo.getSchedulingClass()});
        logger.info(methodName, duccWorkReservation.getDuccId(), new Object[]{this.messages.fetchLabel("priority") + schedulingInfo.getSchedulingPriority()});
        logger.info(methodName, duccWorkReservation.getDuccId(), new Object[]{this.messages.fetchLabel("memory") + schedulingInfo.getMemorySizeRequested() + schedulingInfo.getMemoryUnits()});
        logger.info(methodName, duccWorkReservation.getDuccId(), new Object[]{this.messages.fetchLabel("instances") + schedulingInfo.getInstancesCount()});
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
        return duccWorkReservation;
    }
}

