/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.uima.ducc.cli.IUiOption;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;

public class CommandLine {
    private String[] args;
    private IUiOption[] opts;
    private Map<String, IUiOption> name_to_option;
    private Map<IUiOption, String> option_to_value;
    private Map<IUiOption, IUiOption> legal_options;
    private Properties properties;
    private int help_width = 100;

    public CommandLine(String[] args, IUiOption[] opts) {
        this(args, opts, null);
    }

    public CommandLine(String[] args, IUiOption[] opts, Properties props) {
        this.args = args;
        this.opts = opts;
        this.properties = props;
        this.name_to_option = new HashMap<String, IUiOption>();
        this.option_to_value = new HashMap<IUiOption, String>();
        this.legal_options = new HashMap<IUiOption, IUiOption>();
        for (IUiOption o : opts) {
            this.name_to_option.put(o.pname(), o);
            this.legal_options.put(o, o);
            if (o.sname() == null) continue;
            this.name_to_option.put(o.sname(), o);
        }
    }

    public boolean contains(IUiOption opt) {
        return this.option_to_value.containsKey(opt);
    }

    public boolean contains(String opt) {
        IUiOption o = this.name_to_option.get(opt);
        if (o == null) {
            return false;
        }
        return this.contains(o);
    }

    public boolean isOption(String s) {
        if (s.startsWith("--")) {
            s = s.substring(2);
        } else if (s.startsWith("-")) {
            s = s.substring(1);
        } else {
            return false;
        }
        return this.name_to_option.containsKey(s);
    }

    public boolean isOptionName(String s) {
        return this.name_to_option.containsKey(s);
    }

    public boolean isOption(IUiOption k) {
        return this.legal_options.containsKey(k);
    }

    public String get(IUiOption k) throws IllegalArgumentException {
        if (this.legal_options.containsKey(k)) {
            return this.option_to_value.get(k);
        }
        throw new IllegalArgumentException("Option '" + k.pname() + "' is not a legal option.");
    }

    public Map<IUiOption, String> allOptions() {
        return this.option_to_value;
    }

    public int getInt(IUiOption k) throws IllegalArgumentException, NumberFormatException {
        return Integer.parseInt(this.get(k));
    }

    public long getLong(IUiOption k) throws IllegalArgumentException, NumberFormatException {
        return Long.parseLong(this.get(k));
    }

    public boolean getBoolean(IUiOption k) throws IllegalArgumentException {
        String v = this.get(k);
        if (v == null || v.isEmpty()) {
            return true;
        }
        if ((v = v.toUpperCase()).equals("TRUE") || v.equals("T") || v.equals("YES") || v.equals("Y") || v.equals("1")) {
            return true;
        }
        if (v.equals("FALSE") || v.equals("F") || v.equals("NO") || v.equals("N") || v.equals("0")) {
            return false;
        }
        throw new IllegalArgumentException("Value is not true | false for argument " + k.pname());
    }

    private void add(IUiOption k, String v) {
        if (this.contains(k)) {
            throw new IllegalArgumentException("Duplicate argument " + k.pname() + " not allowed.");
        }
        this.option_to_value.put(k, v);
    }

    private String justify(int leader, String txt) {
        int real_width = this.help_width - leader;
        String blanks = String.format("%" + leader + "s", " ");
        if (txt.length() < real_width) {
            return blanks + txt;
        }
        ArrayList<String> pieces_parts = new ArrayList<String>();
        while (txt.length() > real_width) {
            int lastBlank = txt.lastIndexOf(32, real_width);
            pieces_parts.add(txt.substring(0, lastBlank));
            txt = txt.substring(lastBlank + 1);
        }
        pieces_parts.add(txt);
        StringBuffer sb = new StringBuffer();
        for (String s : pieces_parts) {
            sb.append(blanks);
            sb.append(s);
            sb.append("\n");
        }
        return sb.toString();
    }

    public String formatHelp(String commandName) {
        StringBuffer sb = new StringBuffer();
        sb.append("Usage:\n");
        sb.append("   ");
        sb.append(commandName);
        sb.append(" [options]\n");
        sb.append("Where options are:\n");
        int len = 0;
        for (IUiOption o : this.opts) {
            int namelen = o.pname().length();
            if (o.sname() != null) {
                namelen += o.sname().length() + 3;
            }
            len = Math.max(len, namelen);
        }
        String fmt1 = "%-" + len + "s";
        String fmt2 = "%-" + (len + 3) + "s";
        for (IUiOption o : this.opts) {
            sb.append("--");
            String cmd = o.pname();
            if (o.sname() != null) {
                cmd = cmd + ", -" + o.sname();
            }
            sb.append(String.format(fmt1, cmd));
            if (o.argname() != null) {
                sb.append(" <");
                sb.append(o.argname());
                sb.append(">");
            }
            if (o.required()) {
                sb.append(" (required)");
            }
            if (o.optargs()) {
                if ("true".equals(o.deflt())) {
                    sb.append(" (optional boolean)");
                } else {
                    sb.append(" (optional)");
                }
            }
            if (o.noargs()) {
                sb.append(" (no arguments)");
            }
            if (o.deflt() != null && !o.deflt().isEmpty()) {
                String deflt = o.deflt();
                if (deflt.startsWith("$$")) {
                    deflt = DuccPropertiesResolver.get((String)deflt.substring(2));
                }
                sb.append("\n");
                sb.append(String.format(fmt2, ""));
                sb.append("Default:  ");
                sb.append(deflt);
            }
            if (o.description() != null) {
                sb.append("\n");
                sb.append(this.justify(len + 3, o.description()));
            }
            if (o.example() != null) {
                sb.append("\n");
                sb.append(String.format(fmt2, ""));
                sb.append("Example:  ");
                sb.append(o.example());
            }
            sb.append("\n\n");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (IUiOption k : this.option_to_value.keySet()) {
            sb.append(k.pname());
            sb.append("=");
            sb.append(this.option_to_value.get(k));
            sb.append(" ");
        }
        return sb.toString();
    }

    public void sanity() {
        boolean error = false;
        StringBuffer sb = new StringBuffer();
        for (IUiOption o : this.opts) {
            if (o.multiargs() && o.noargs()) {
                if (error) {
                    sb.append("\n");
                }
                sb.append("Option '");
                sb.append(o.pname());
                sb.append("': multiargs() is true but noargs() is also true.");
                error = true;
                continue;
            }
            if (o.noargs() && o.optargs()) {
                if (error) {
                    sb.append("\n");
                }
                sb.append("Option '");
                sb.append(o.pname());
                sb.append("': optargs() is true but noargs() is also true.");
                error = true;
                continue;
            }
            if (o.noargs() && o.deflt() != null) {
                try {
                    this.getBoolean(o);
                }
                catch (IllegalArgumentException e) {
                    if (error) {
                        sb.append("\n");
                    }
                    sb.append("Option '");
                    sb.append(o.pname());
                    sb.append("': noargs() is true but a non-boolean default is defined.");
                    error = true;
                }
            }
            if (!o.optargs() || o.deflt() != null) continue;
            if (error) {
                sb.append("\n");
            }
            sb.append("Option '");
            sb.append(o.pname());
            sb.append("': optargs() is true but no default is provided.");
            error = true;
        }
        if (error) {
            throw new IllegalArgumentException(sb.toString());
        }
    }

    private void addProperties() {
        for (String p : this.properties.stringPropertyNames()) {
            IUiOption opt = this.name_to_option.get(p);
            if (opt == null) {
                throw new IllegalArgumentException("Illegal keyword for this command: " + p);
            }
            if (this.contains(opt)) continue;
            if (opt.multiargs()) {
                throw new IllegalArgumentException("multiargs() is not yet implemented.");
            }
            String v = this.properties.getProperty(p);
            if (opt.noargs()) {
                if (v == null) {
                    this.add(opt, null);
                    continue;
                }
                try {
                    this.getBoolean(opt);
                    this.add(opt, v);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Argument " + opt.pname() + ": no value allowed.  Found " + v);
                }
            }
            if (opt.optargs()) {
                if (v == null) {
                    this.add(opt, opt.deflt());
                    continue;
                }
                this.add(opt, v);
                continue;
            }
            if (v == null) {
                throw new IllegalArgumentException("Missing required value for argument " + opt.pname());
            }
            this.add(opt, v);
        }
    }

    private void addCommandLine() {
        int i = 0;
        for (i = 0; i < this.args.length; ++i) {
            String k;
            if (this.args[i] == null) continue;
            if (this.args[i].startsWith("--")) {
                k = this.args[i].substring(2);
            } else if (this.args[i].startsWith("-")) {
                k = this.args[i].substring(1);
            } else {
                throw new IllegalArgumentException("Unrecognized keyword:  " + this.args[i]);
            }
            IUiOption opt = this.name_to_option.get(k);
            if (opt == null) {
                throw new IllegalArgumentException("Illegal keyword for this command: " + this.args[i]);
            }
            if (opt.multiargs()) {
                throw new IllegalArgumentException("multiargs() is not yet implemented.");
            }
            String v = i + 1 < this.args.length ? this.args[i + 1] : null;
            if (opt.noargs()) {
                if (v == null || this.isOption(v)) {
                    this.add(opt, null);
                    continue;
                }
                throw new IllegalArgumentException("Argument " + opt.pname() + ": no value allowed.  Found " + v);
            }
            if (opt.optargs()) {
                if (v == null || this.isOption(v)) {
                    this.add(opt, opt.deflt());
                    continue;
                }
                this.add(opt, v);
                ++i;
                continue;
            }
            if (v == null || this.isOption(v)) {
                throw new IllegalArgumentException("Missing required value for argument " + opt.pname());
            }
            ++i;
            this.add(opt, v);
        }
    }

    public void verify() {
        for (IUiOption o : this.opts) {
            if (!o.required() || this.contains(o)) continue;
            throw new IllegalArgumentException("Missing required argument " + o.pname());
        }
    }

    public void parse() {
        this.sanity();
        if (this.args != null) {
            this.addCommandLine();
        }
        if (this.properties != null) {
            this.addProperties();
        }
    }
}

