/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.utils;

import java.math.RoundingMode;
import java.text.DecimalFormat;

public class FormatHelper {
    private static DecimalFormat df = new DecimalFormat("#.0");

    public static String duration(long millis, Precision precision) {
        long seconds = millis / 1000L;
        long dd = seconds / 86400L;
        long hh = seconds % 86400L / 3600L;
        long mm = seconds % 86400L % 3600L / 60L;
        long ss = seconds % 86400L % 3600L % 60L;
        String text = String.format("%d:%02d:%02d:%02d", dd, hh, mm, ss);
        if (dd == 0L) {
            text = String.format("%02d:%02d:%02d", hh, mm, ss);
            if (hh == 0L) {
                text = String.format("%02d:%02d", mm, ss);
                if (mm == 0L) {
                    text = String.format("%02d", ss);
                }
            }
        }
        switch (precision) {
            case Tenths: {
                double subseconds = (double)millis % 1000.0 / 1000.0;
                String frac = df.format(subseconds);
                text = text + frac;
                break;
            }
        }
        return text;
    }

    static {
        df.setRoundingMode(RoundingMode.DOWN);
    }

    public static enum Precision {
        Whole,
        Tenths;

    }
}

