/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.utils;

public class ExceptionHelper {
    public static String summarize(Throwable t) {
        StringBuffer sb = new StringBuffer();
        if (t != null) {
            sb.append(t.getClass().getCanonicalName());
            StackTraceElement[] steArray = t.getStackTrace();
            if (steArray != null && steArray.length > 0) {
                StackTraceElement ste = steArray[0];
                sb.append(" at ");
                sb.append(ste.getClassName());
                sb.append(".");
                sb.append(ste.getMethodName());
                sb.append("(");
                sb.append(ste.getFileName());
                sb.append(":");
                sb.append(ste.getLineNumber());
                sb.append(")");
                if (t.getCause() != null) {
                    sb.append(" cause: ");
                    sb.append(t.getCause());
                }
            }
        }
        return sb.toString();
    }
}

