/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.uima;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.impl.AnalysisEngineDescription_impl;
import org.apache.uima.analysis_engine.metadata.FlowConstraints;
import org.apache.uima.analysis_engine.metadata.FlowControllerDeclaration;
import org.apache.uima.analysis_engine.metadata.impl.FixedFlow_impl;
import org.apache.uima.analysis_engine.metadata.impl.FlowControllerDeclaration_impl;
import org.apache.uima.ducc.common.uima.InvalidOverrideParameterException;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.resource.RelativePathResolver;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.impl.RelativePathResolver_impl;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.impl.ConfigurationParameter_impl;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;

public class UimaHelper {
    public static final String FlowControllerKey = "FixedFlowController";
    public static final String FlowControllerResourceSpecifier = "ducc.flow-controller.specifier";
    public static RelativePathResolver resolver = new RelativePathResolver_impl();

    public static AnalysisEngineDescription createAggregateDescription(boolean multipleDeploymentsAllowed, String ... descriptorPaths) throws Exception {
        ArrayList<List<String>> overrides = new ArrayList<List<String>>();
        return UimaHelper.createAggregateDescription(multipleDeploymentsAllowed, overrides, descriptorPaths);
    }

    public static AnalysisEngineDescription createAggregateDescription(boolean multipleDeploymentAllowed, List<List<String>> overrides, String ... descriptorPaths) throws Exception {
        AnalysisEngineDescription_impl desc = new AnalysisEngineDescription_impl();
        resolver.setPathResolverClassLoader(desc.getClass().getClassLoader());
        desc.setFrameworkImplementation("org.apache.uima.java");
        desc.setPrimitive(false);
        ResourceSpecifier[] specifiers = new ResourceSpecifier[descriptorPaths.length];
        desc.getAnalysisEngineMetaData().getOperationalProperties().setMultipleDeploymentAllowed(multipleDeploymentAllowed);
        ArrayList<String> flowNames = new ArrayList<String>();
        int inx = 0;
        for (String aeDescription : descriptorPaths) {
            specifiers[inx++] = UimaHelper.getResourceSpecifier(aeDescription);
        }
        for (String aeDescription : descriptorPaths) {
            Import_impl descriptorImport = new Import_impl();
            if (aeDescription.endsWith(".xml")) {
                if (!(aeDescription = Utils.resolvePlaceholderIfExists(aeDescription, System.getProperties())).startsWith("file:")) {
                    aeDescription = "file:" + aeDescription;
                }
                descriptorImport.setLocation(aeDescription);
            } else {
                descriptorImport.setName(aeDescription);
            }
            String key = new String(aeDescription);
            if (key.startsWith("file:")) {
                key = key.substring(5);
            }
            if (key.endsWith(".xml")) {
                key = key.substring(0, key.indexOf(".xml"));
            }
            if (key.indexOf("/") != -1) {
                key = key.replaceAll("/", ".");
            }
            if (key.indexOf("\\") != -1) {
                key = key.replaceAll("\\\\", ".");
            }
            key = key.substring(key.lastIndexOf(".") + 1);
            desc.getDelegateAnalysisEngineSpecifiersWithImports().put(key, descriptorImport);
            flowNames.add(key);
        }
        String fcsn = DuccPropertiesResolver.getInstance().getProperty(FlowControllerResourceSpecifier);
        if (fcsn != null) {
            FlowControllerDeclaration_impl fcd = new FlowControllerDeclaration_impl();
            desc.setFlowControllerDeclaration((FlowControllerDeclaration)fcd);
            fcd.setImport((Import)new Import_impl());
            fcd.setKey(FlowControllerKey);
            fcd.getImport().setName(fcsn);
        }
        FixedFlow_impl fixedFlow = new FixedFlow_impl();
        fixedFlow.setFixedFlow(flowNames.toArray(new String[flowNames.size()]));
        desc.getAnalysisEngineMetaData().setFlowConstraints((FlowConstraints)fixedFlow);
        UimaHelper.addOverrides(overrides, (AnalysisEngineDescription)desc, specifiers, flowNames);
        return desc;
    }

    public static ResourceSpecifier getResourceSpecifier(String resourceFile) throws Exception {
        return UIMAFramework.getXMLParser().parseResourceSpecifier(UimaHelper.getXMLInputSource(resourceFile));
    }

    public static XMLInputSource getXMLInputSource(String resourceFile) throws InvalidXMLException {
        try {
            resourceFile = Utils.resolvePlaceholderIfExists(resourceFile, System.getProperties());
            XMLInputSource in = null;
            if (resourceFile.endsWith(".xml")) {
                in = new XMLInputSource(resourceFile);
            } else {
                resourceFile = resourceFile.replace('.', '/') + ".xml";
                URL relativeURL = resolver.resolveRelativePath(UimaHelper.getRelativePathWithProtocol(resourceFile));
                in = new XMLInputSource(relativeURL);
            }
            return in;
        }
        catch (NullPointerException npe) {
            throw new InvalidXMLException("import_by_name_target_not_found", (Object[])new String[]{resourceFile});
        }
        catch (IOException e) {
            throw new InvalidXMLException("import_failed_could_not_read_from_url", (Object[])new String[]{resourceFile});
        }
    }

    public static URL getRelativePathWithProtocol(String aRelativePath) throws MalformedURLException {
        URL relativeUrl;
        try {
            relativeUrl = new URL(aRelativePath);
        }
        catch (MalformedURLException e) {
            relativeUrl = new URL("file", "", aRelativePath);
        }
        return relativeUrl;
    }

    private static void addOverrides(List<List<String>> overrides, AnalysisEngineDescription desc, ResourceSpecifier[] specifiers, List<String> flowNames) throws Exception {
        ConfigurationParameterDeclarations aggregateDeclarations = desc.getAnalysisEngineMetaData().getConfigurationParameterDeclarations();
        ConfigurationParameterSettings aggregateSetttings = desc.getAnalysisEngineMetaData().getConfigurationParameterSettings();
        int indx = 0;
        for (List<String> componentOverrides : overrides) {
            if (specifiers[indx] instanceof ResourceCreationSpecifier) {
                UimaHelper.addComponentOverrides(flowNames.get(indx), componentOverrides, (ResourceCreationSpecifier)specifiers[indx], aggregateDeclarations, aggregateSetttings);
            }
            ++indx;
        }
    }

    private static void addComponentOverrides(String key, List<String> componentOverrides, ResourceCreationSpecifier specifier, ConfigurationParameterDeclarations aggregateDeclarations, ConfigurationParameterSettings aggregateSetttings) throws Exception {
        if (componentOverrides == null || componentOverrides.isEmpty()) {
            return;
        }
        UimaHelper.processOverrides(key, componentOverrides, specifier, aggregateDeclarations, aggregateSetttings);
    }

    private static void processOverrides(String key, List<String> componentOverrides, ResourceCreationSpecifier specifier, ConfigurationParameterDeclarations aggregateDeclarations, ConfigurationParameterSettings aggregateSetttings) throws Exception {
        for (String cmOverride : componentOverrides) {
            System.out.println(".... Processing Override:" + cmOverride);
            String[] nvp = cmOverride.split("=", 2);
            ConfigurationParameterDeclarations componentParameterDeclarations = specifier.getMetaData().getConfigurationParameterDeclarations();
            boolean found = false;
            for (ConfigurationParameter parameter : componentParameterDeclarations.getConfigurationParameters()) {
                if (!nvp[0].equals(parameter.getName())) continue;
                UimaHelper.addParam(key, nvp, parameter, aggregateDeclarations);
                UimaHelper.addParamValue(nvp, parameter, aggregateSetttings);
                found = true;
                break;
            }
            if (found) continue;
            throw new UIMARuntimeException((Throwable)new InvalidOverrideParameterException("Override Parameter:" + nvp[0] + " is not defined for the component with key: " + key));
        }
    }

    private static void addParam(String key, String[] nvp, ConfigurationParameter parameter, ConfigurationParameterDeclarations aggregateDeclarations) {
        ConfigurationParameter_impl cfgParam = new ConfigurationParameter_impl();
        cfgParam.setName(nvp[0]);
        if (parameter == null) {
            cfgParam.setType("String");
        } else {
            cfgParam.setType(parameter.getType());
        }
        cfgParam.addOverride(key + "/" + nvp[0]);
        aggregateDeclarations.addConfigurationParameter((ConfigurationParameter)cfgParam);
    }

    private static void addParamValue(String[] nvp, ConfigurationParameter parameter, ConfigurationParameterSettings aggregateSettings) {
        Object value = nvp[1];
        if (parameter != null) {
            if (parameter.getType().equals("Integer")) {
                value = Integer.parseInt(nvp[1]);
            } else if (parameter.getType().equals("Boolean")) {
                value = Boolean.parseBoolean(nvp[1]);
            } else if (parameter.getType().equals("Float")) {
                value = Float.valueOf(Float.parseFloat(nvp[1]));
            }
            aggregateSettings.setParameterValue(nvp[0], value);
        } else {
            aggregateSettings.setParameterValue(nvp[0], value);
        }
    }
}

