/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.jd.files.workitem;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.uima.ducc.common.jd.files.IWorkItemState;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;

public class ActiveMap {
    private DuccLogger logger = DuccLogger.getLogger(ActiveMap.class, null);
    private DuccId jobid = null;
    protected ConcurrentSkipListMap<Long, IWorkItemState> activeMap = new ConcurrentSkipListMap();

    public ActiveMap(String component) {
        this.logger = DuccLogger.getLogger(ActiveMap.class, component);
    }

    public Set<Map.Entry<Long, IWorkItemState>> entrySet() {
        return this.activeMap.entrySet();
    }

    public void remove(Long key) {
        String location = "remove";
        IWorkItemState value = this.get(key);
        if (value != null) {
            this.activeMap.remove(key);
            this.logger.debug(location, this.jobid, "seqNo:" + value.getSeqNo() + " state:" + (Object)((Object)value.getState()) + " size:" + this.activeMap.size());
        }
        this.getOperatingLeast();
    }

    public void put(Long key, IWorkItemState value) {
        String location = "put";
        if (value != null) {
            this.activeMap.put(key, value);
            this.logger.debug(location, this.jobid, "seqNo:" + value.getSeqNo() + " state:" + (Object)((Object)value.getState()) + " size:" + this.activeMap.size());
        }
        this.getOperatingLeast();
    }

    public IWorkItemState get(Long key) {
        return this.activeMap.get(key);
    }

    public int size() {
        return this.activeMap.size();
    }

    public long getOperatingLeast() {
        String location = "getOperatingLeast";
        long operatingLeast = Long.MAX_VALUE;
        for (Map.Entry<Long, IWorkItemState> entry : this.activeMap.entrySet()) {
            long candidate = entry.getValue().getMillisProcessing();
            if (candidate >= operatingLeast) continue;
            operatingLeast = candidate;
        }
        if (operatingLeast == Long.MAX_VALUE) {
            operatingLeast = 0L;
        }
        this.logger.debug(location, this.jobid, operatingLeast);
        return operatingLeast;
    }
}

