/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.db;

import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;

public class DbHelper {
    public static final String ducc_database_host = "ducc.database.host";
    private static final DuccPropertiesResolver dpr = DuccPropertiesResolver.getInstance();
    private static String[] emptyList = new String[0];

    public static boolean isDbEnabled() {
        boolean retVal = true;
        String value = dpr.getProperty("ducc.database.host.list");
        if (value != null) {
            if (value.equalsIgnoreCase("--disabled--")) {
                retVal = false;
            }
        } else {
            value = dpr.getProperty(ducc_database_host);
            if (value != null) {
                if (value.equalsIgnoreCase("--disabled--")) {
                    retVal = false;
                }
            } else {
                retVal = false;
            }
        }
        return retVal;
    }

    public static boolean isDbDisabled() {
        return !DbHelper.isDbEnabled();
    }

    public static String getHostListString() {
        String retVal = dpr.getProperty("ducc.database.host.list");
        if (retVal == null) {
            dpr.getProperty(ducc_database_host);
        }
        return retVal;
    }

    public static String getJxmHostString() {
        String retVal = dpr.getProperty("ducc.database.jmx.host");
        return retVal;
    }

    public static String getJxmPortString() {
        String retVal = dpr.getProperty("ducc.database.jmx.port");
        return retVal;
    }

    public static Integer getJxmPortInteger() {
        Integer retVal = new Integer(7199);
        String jmx_port = dpr.getProperty("ducc.database.jmx.port");
        try {
            retVal = Integer.parseInt(jmx_port);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public static String[] getHostList() {
        String[] retVal = emptyList;
        String hostListString = DbHelper.getHostListString();
        if (hostListString != null) {
            retVal = DbHelper.stringToArray(hostListString);
        }
        return retVal;
    }

    public static String[] stringToArray(String input) {
        String[] output = null;
        output = input == null ? new String[]{} : input.split("\\s+");
        return output;
    }
}

