/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.database.lifetime;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.uima.ducc.common.db.DbHelper;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.database.DbHandle;
import org.apache.uima.ducc.database.DbManager;
import org.apache.uima.ducc.database.DbUtil;
import org.apache.uima.ducc.database.lifetime.DbDaemonLifetimeCommon;
import org.apache.uima.ducc.database.lifetime.IDbDaemonLifetime;

public class DbDaemonLifetime
implements IDbDaemonLifetime {
    private DuccLogger logger = null;
    private DuccId id = null;
    public static final Integer RC_Success = DbDaemonLifetimeCommon.RC_Success;
    private static DbManager dbManager = null;
    private static String KEYSPACE = "DUCC";
    private static String DAEMON_LIFETIME_TABLE = IDbDaemonLifetime.DaemonLifetimeProperties.TABLE_NAME.pname();
    private static String key_host = IDbDaemonLifetime.DaemonLifetimeProperties.host.name();
    private static String key_daemon = IDbDaemonLifetime.DaemonLifetimeProperties.daemon.name();
    private static String key_state = IDbDaemonLifetime.DaemonLifetimeProperties.state.name();
    private static String key_tod = IDbDaemonLifetime.DaemonLifetimeProperties.tod.name();

    public DbDaemonLifetime() {
        this.logger = DuccLogger.getLogger(DbDaemonLifetime.class);
        this.init();
    }

    public DbDaemonLifetime(Level level) {
        this.logger = DuccLogger.getLogger(DbDaemonLifetime.class);
        this.logger.setLevel(level);
        this.init();
    }

    public DbDaemonLifetime(DuccLogger ducclogger) {
        this.logger = ducclogger;
        this.init();
    }

    private List<SimpleStatement> db_mkSchema() throws Exception {
        ArrayList<SimpleStatement> ret = new ArrayList<SimpleStatement>();
        StringBuffer buf = new StringBuffer("CREATE TABLE IF NOT EXISTS " + DAEMON_LIFETIME_TABLE + " (");
        buf.append(DbUtil.mkSchema(IDbDaemonLifetime.DaemonLifetimeProperties.values()));
        buf.append(")");
        ret.add(new SimpleStatement(buf.toString()));
        List<String> indexes = DbUtil.mkIndices(IDbDaemonLifetime.DaemonLifetimeProperties.values(), DAEMON_LIFETIME_TABLE);
        for (String s : indexes) {
            ret.add(new SimpleStatement(s));
        }
        return ret;
    }

    private boolean db_init() {
        String mn = "db_init";
        boolean retVal = false;
        try {
            List<SimpleStatement> specificationsSchema = this.db_mkSchema();
            DbHandle h = dbManager.open();
            for (SimpleStatement s : specificationsSchema) {
                this.logger.debug(mn, this.id, new Object[]{"EXECUTE STATEMENT:" + s.toString()});
                h.execute(s);
            }
            retVal = true;
        }
        catch (Exception e) {
            this.logger.error(mn, this.id, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    private boolean init(String[] dburls) throws Exception {
        String mn = "init";
        boolean retVal = false;
        try {
            dbManager = new DbManager(dburls, this.logger);
            dbManager.init();
            retVal = true;
        }
        catch (Exception e) {
            this.logger.error(mn, this.id, new Object[]{"Errors contacting database.  No connetion made."});
            this.logger.error(mn, this.id, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    private boolean init() {
        String mn = "init";
        boolean retVal = false;
        try {
            String[] dbUrls = DbHelper.getHostList();
            StringBuffer sb = new StringBuffer();
            for (String dbUrl : dbUrls) {
                sb.append(dbUrl + " ");
            }
            this.logger.debug(mn, this.id, new Object[]{dbUrls.length + " " + sb.toString()});
            retVal = this.init(dbUrls);
        }
        catch (Exception e) {
            this.logger.error(mn, this.id, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    private void shutdown() {
        dbManager.shutdown();
    }

    private IDbDaemonLifetime.DbResult db_upsert(String host, String daemon, String state, Long tod) {
        String mn = "db_upsert";
        IDbDaemonLifetime.DbResult dbResult = new IDbDaemonLifetime.DbResult();
        try {
            DbHandle h = dbManager.open();
            PreparedStatement ps = h.prepare("INSERT INTO " + DAEMON_LIFETIME_TABLE + " (host, daemon, state, tod) values(?, ?, ?, ?);");
            this.logger.debug(mn, this.id, new Object[]{"EXECUTE STATEMENT:" + ps.toString() + " (" + host + "," + daemon + "," + state + "," + tod + ")"});
            this.logger.debug(mn, this.id, new Object[]{host, daemon, state, tod});
            ResultSet rs = h.execute(ps, host, daemon, state, tod);
            for (Row row : rs) {
                int width = row.getColumnDefinitions().size();
                if (width <= 1) continue;
                StringBuffer sb = new StringBuffer();
                sb.append(key_host + "=" + row.getString(key_host));
                sb.append(" ");
                sb.append(key_daemon + "=" + row.getString(key_daemon));
                sb.append(" ");
                sb.append(key_state + "=" + row.getString(key_state));
                sb.append(" ");
                sb.append(key_tod + "=" + row.getLong(key_tod));
                this.logger.debug(mn, this.id, new Object[]{sb.toString()});
            }
            dbResult.rc = RC_Success;
        }
        catch (Exception e) {
            this.logger.error(mn, this.id, (Throwable)e, new Object[0]);
        }
        this.logger.debug(mn, this.id, new Object[]{dbResult.rc});
        return dbResult;
    }

    private IDbDaemonLifetime.DbResult db_update(String host, String daemon, String state, Long tod) {
        String mn = "db_update";
        IDbDaemonLifetime.DbResult dbResult = new IDbDaemonLifetime.DbResult();
        try {
            ResultSet rs;
            PreparedStatement ps;
            DbHandle h = dbManager.open();
            if (host.equals("*")) {
                ps = h.prepare("UPDATE " + DAEMON_LIFETIME_TABLE + " SET state=?, tod=? WHERE daemon=? IF EXISTS;");
                this.logger.debug(mn, this.id, new Object[]{"EXECUTE STATEMENT:" + ps.toString() + " (" + state + "," + tod + "," + daemon + ")"});
                this.logger.debug(mn, this.id, new Object[]{daemon, state, tod});
                rs = h.execute(ps, state, tod, daemon);
            } else {
                ps = h.prepare("UPDATE " + DAEMON_LIFETIME_TABLE + " SET state=?, tod=? WHERE host=? AND daemon=? IF EXISTS;");
                this.logger.debug(mn, this.id, new Object[]{"EXECUTE STATEMENT:" + ps.toString() + " (" + state + "," + tod + "," + host + "," + daemon + ")"});
                this.logger.debug(mn, this.id, new Object[]{host, daemon, state, tod});
                rs = h.execute(ps, state, tod, host, daemon);
            }
            for (Row row : rs) {
                int width = row.getColumnDefinitions().size();
                if (width <= 1) continue;
                StringBuffer sb = new StringBuffer();
                sb.append(key_host + "=" + row.getString(key_host));
                sb.append(" ");
                sb.append(key_daemon + "=" + row.getString(key_daemon));
                sb.append(" ");
                sb.append(key_state + "=" + row.getString(key_state));
                sb.append(" ");
                sb.append(key_tod + "=" + row.getLong(key_tod));
                this.logger.debug(mn, this.id, new Object[]{sb.toString()});
                System.out.println(sb.toString());
            }
            dbResult.rc = RC_Success;
        }
        catch (Exception e) {
            this.logger.error(mn, this.id, (Throwable)e, new Object[0]);
            e.printStackTrace();
        }
        this.logger.debug(mn, this.id, new Object[]{dbResult.rc});
        return dbResult;
    }

    private IDbDaemonLifetime.DbResult db_delete(String host, String daemon) {
        String mn = "db_delete";
        IDbDaemonLifetime.DbResult dbResult = new IDbDaemonLifetime.DbResult();
        try {
            String w_host = key_host + "='" + host + "'";
            String w_daemon = key_daemon + "='" + daemon + "'";
            String w_clause = "WHERE " + w_host + " AND " + w_daemon;
            String cql = "DELETE FROM " + KEYSPACE + "." + DAEMON_LIFETIME_TABLE + " " + w_clause + ";";
            this.logger.debug(mn, this.id, new Object[]{"EXECUTE STATEMENT:" + cql});
            DbHandle h = dbManager.open();
            ResultSet rs = h.execute(cql);
            for (Row row : rs) {
                int width = row.getColumnDefinitions().size();
                if (width <= 1) continue;
                StringBuffer sb = new StringBuffer();
                sb.append(key_host + "=" + row.getString(key_host));
                sb.append(" ");
                sb.append(key_daemon + "=" + row.getString(key_daemon));
                sb.append(" ");
                sb.append(key_tod + "=" + row.getLong(key_tod));
                this.logger.debug(mn, this.id, new Object[]{sb.toString()});
            }
            dbResult.rc = RC_Success;
        }
        catch (InvalidQueryException e) {
            if (e.getMessage().equals("unconfigured table daemonlifetime")) {
                this.logger.debug(mn, this.id, (Throwable)e, new Object[0]);
            } else {
                this.logger.error(mn, this.id, (Throwable)e, new Object[0]);
            }
        }
        catch (Exception e) {
            this.logger.error(mn, this.id, (Throwable)e, new Object[0]);
        }
        this.logger.debug(mn, this.id, new Object[]{dbResult.rc});
        return dbResult;
    }

    private void add_kw_where(StringBuffer sb, String host, String daemon) {
        if (host != null) {
            sb.append("WHERE");
            sb.append(" ");
        } else if (daemon != null) {
            sb.append("WHERE");
            sb.append(" ");
        }
    }

    private void add_host(StringBuffer sb, String host) {
        if (host != null) {
            sb.append("host = ");
            sb.append("'");
            sb.append(host);
            sb.append("'");
            sb.append(" ");
        }
    }

    private void add_kw_and(StringBuffer sb, String host, String daemon) {
        if (host != null && daemon != null) {
            sb.append("AND");
            sb.append(" ");
        }
    }

    private void add_daemon(StringBuffer sb, String daemon) {
        if (daemon != null) {
            sb.append("daemon = ");
            sb.append("'");
            sb.append(daemon);
            sb.append("'");
            sb.append(" ");
        }
    }

    private String get_where_clause(String host, String daemon) {
        StringBuffer where_clause = new StringBuffer();
        this.add_kw_where(where_clause, host, daemon);
        this.add_host(where_clause, host);
        this.add_kw_and(where_clause, host, daemon);
        this.add_daemon(where_clause, daemon);
        String retVal = where_clause.toString().trim();
        return retVal;
    }

    private IDbDaemonLifetime.DbResult db_query(String host, String daemon) {
        String mn = "db_query";
        IDbDaemonLifetime.DbResult dbResult = new IDbDaemonLifetime.DbResult();
        ArrayList<IDbDaemonLifetime.DaemonInfo> list = new ArrayList<IDbDaemonLifetime.DaemonInfo>();
        try {
            String where_clause = this.get_where_clause(host, daemon);
            String cql = "SELECT * FROM " + KEYSPACE + "." + DAEMON_LIFETIME_TABLE + " " + where_clause + ";";
            this.logger.debug(mn, this.id, new Object[]{cql});
            DbHandle h = dbManager.open();
            ResultSet rs = h.execute(cql);
            Iterator iterator = rs.iterator();
            int rows = 0;
            while (iterator.hasNext()) {
                ++rows;
                Row row = (Row)iterator.next();
                int width = row.getColumnDefinitions().size();
                if (width <= 1) continue;
                IDbDaemonLifetime.DaemonInfo daemonInfo = new IDbDaemonLifetime.DaemonInfo(row.getString(key_host), row.getString(key_daemon), row.getString(key_state), row.getLong(key_tod));
                list.add(daemonInfo);
                StringBuffer sb = new StringBuffer();
                sb.append(key_host + "=" + daemonInfo.host);
                sb.append(" ");
                sb.append(key_daemon + "=" + daemonInfo.daemon);
                sb.append(" ");
                sb.append(key_state + "=" + daemonInfo.state);
                sb.append(" ");
                sb.append(key_tod + "=" + daemonInfo.tod);
                this.logger.debug(mn, this.id, new Object[]{sb.toString()});
            }
            dbResult.list = list;
            dbResult.rc = RC_Success;
        }
        catch (InvalidQueryException e) {
            if (e.getMessage().equals("unconfigured table daemonlifetime")) {
                this.logger.debug(mn, this.id, (Throwable)e, new Object[0]);
            } else {
                this.logger.error(mn, this.id, (Throwable)e, new Object[0]);
            }
        }
        catch (Exception e) {
            this.logger.error(mn, this.id, (Throwable)e, new Object[0]);
        }
        this.logger.debug(mn, this.id, new Object[]{dbResult.rc});
        return dbResult;
    }

    private IDbDaemonLifetime.DbResult db_quiesce(String host, String daemon, Long tod) {
        String mn = "db_quiesce";
        IDbDaemonLifetime.DbResult dbResult = new IDbDaemonLifetime.DbResult();
        if (this.init()) {
            if (this.db_init()) {
                dbResult = this.db_update(host, daemon, IDbDaemonLifetime.DesiredState.Quiesce.name(), tod);
            }
            this.shutdown();
        }
        this.logger.debug(mn, this.id, new Object[]{dbResult.rc});
        return dbResult;
    }

    private IDbDaemonLifetime.DbResult db_start(String host, String daemon, Long tod) {
        String mn = "db_start";
        IDbDaemonLifetime.DbResult dbResult = new IDbDaemonLifetime.DbResult();
        if (this.init()) {
            if (this.db_init()) {
                dbResult = this.db_upsert(host, daemon, IDbDaemonLifetime.DesiredState.Start.name(), tod);
            }
            this.shutdown();
        }
        this.logger.debug(mn, this.id, new Object[]{dbResult.rc});
        return dbResult;
    }

    private IDbDaemonLifetime.DbResult db_stop(String host, String daemon, Long tod) {
        String mn = "db_stop";
        IDbDaemonLifetime.DbResult dbResult = new IDbDaemonLifetime.DbResult();
        if (this.init()) {
            if (this.db_init()) {
                dbResult = this.db_update(host, daemon, IDbDaemonLifetime.DesiredState.Stop.name(), tod);
            }
            this.shutdown();
        }
        this.logger.debug(mn, this.id, new Object[]{dbResult.rc});
        return dbResult;
    }

    @Override
    public IDbDaemonLifetime.DbResult delete(String host, String daemon) {
        IDbDaemonLifetime.DbResult dbResult = new IDbDaemonLifetime.DbResult();
        if (this.init()) {
            dbResult = this.db_delete(host, daemon);
            this.shutdown();
        }
        return dbResult;
    }

    @Override
    public IDbDaemonLifetime.DbResult query(String host, String daemon) {
        IDbDaemonLifetime.DbResult dbResult = new IDbDaemonLifetime.DbResult();
        if (this.init()) {
            dbResult = this.db_query(host, daemon);
            this.shutdown();
        }
        return dbResult;
    }

    @Override
    public IDbDaemonLifetime.DbResult quiesce(String host, String daemon, Long tod) {
        IDbDaemonLifetime.DbResult dbResult = new IDbDaemonLifetime.DbResult();
        if (this.init()) {
            dbResult = this.db_quiesce(host, daemon, tod);
            this.shutdown();
        }
        return dbResult;
    }

    @Override
    public IDbDaemonLifetime.DbResult start(String host, String daemon, Long tod) {
        IDbDaemonLifetime.DbResult dbResult = new IDbDaemonLifetime.DbResult();
        if (this.init()) {
            dbResult = this.db_start(host, daemon, tod);
            this.shutdown();
        }
        return dbResult;
    }

    @Override
    public IDbDaemonLifetime.DbResult stop(String host, String daemon, Long tod) {
        IDbDaemonLifetime.DbResult dbResult = new IDbDaemonLifetime.DbResult();
        if (this.init()) {
            dbResult = this.db_stop(host, daemon, tod);
            this.shutdown();
        }
        return dbResult;
    }
}

