/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.17.0", label="dataformat,transformation", title="MIME Multipart")
@XmlRootElement(name="mime-multipart")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MimeMultipartDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    @Metadata(defaultValue="mixed")
    private String multipartSubType = "mixed";
    @XmlAttribute
    @Metadata(defaultValue="false")
    private Boolean multipartWithoutAttachment;
    @XmlAttribute
    @Metadata(defaultValue="false")
    private Boolean headersInline;
    @XmlAttribute
    private String includeHeaders;
    @XmlAttribute
    @Metadata(defaultValue="false")
    private Boolean binaryContent;

    public MimeMultipartDataFormat() {
        super("mime-multipart");
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        if (this.getMultipartSubType() != null) {
            this.setProperty(camelContext, dataFormat, "multipartSubType", this.getMultipartSubType());
        }
        if (this.getMultipartWithoutAttachment() != null) {
            this.setProperty(camelContext, dataFormat, "multipartWithoutAttachment", this.getMultipartWithoutAttachment());
        }
        if (this.getHeadersInline() != null) {
            this.setProperty(camelContext, dataFormat, "headersInline", this.getHeadersInline());
        }
        if (this.getIncludeHeaders() != null) {
            this.setProperty(camelContext, dataFormat, "includeHeaders", this.getIncludeHeaders());
        }
        if (this.getBinaryContent() != null) {
            this.setProperty(camelContext, dataFormat, "binaryContent", this.getBinaryContent());
        }
    }

    public String getMultipartSubType() {
        return this.multipartSubType;
    }

    public void setMultipartSubType(String multipartSubType) {
        this.multipartSubType = multipartSubType;
    }

    public Boolean getMultipartWithoutAttachment() {
        return this.multipartWithoutAttachment;
    }

    public void setMultipartWithoutAttachment(Boolean multipartWithoutAttachment) {
        this.multipartWithoutAttachment = multipartWithoutAttachment;
    }

    public Boolean getHeadersInline() {
        return this.headersInline;
    }

    public void setHeadersInline(Boolean headersInline) {
        this.headersInline = headersInline;
    }

    public Boolean getBinaryContent() {
        return this.binaryContent;
    }

    public void setIncludeHeaders(String includeHeaders) {
        this.includeHeaders = includeHeaders;
    }

    public String getIncludeHeaders() {
        return this.includeHeaders;
    }

    public void setBinaryContent(Boolean binaryContent) {
        this.binaryContent = binaryContent;
    }
}

