/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.user.common.main;

import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.uima.ducc.user.common.investment.Investment;
import org.apache.uima.ducc.user.common.main.DuccJobService;
import org.apache.uima.ducc.user.common.main.IServiceWrapper;
import org.apache.uima.ducc.user.jp.iface.IProcessContainer;

public class UimaAsServiceWrapper
implements IServiceWrapper {
    private Method stopMethod;
    private Method startMethod;
    private Object duccContainerInstance;
    private Logger logger = Logger.getLogger(UimaAsServiceWrapper.class.getName());
    private Investment investment = new Investment();
    boolean DEBUG = false;

    @Override
    public void initialize(String[] args) throws Exception {
        try {
            ClassLoader sysCL = Thread.currentThread().getContextClassLoader();
            String duccContainerClasspath = System.getProperty("ducc.deploy.DuccClasspath");
            URLClassLoader ucl = DuccJobService.create(duccContainerClasspath);
            if (System.getProperty("ducc.debug") != null) {
                this.DEBUG = true;
            }
            if (this.DEBUG) {
                DuccJobService.dump(ucl, 4);
            }
            Class<?> duccServiceClass = ucl.loadClass("org.apache.uima.ducc.common.main.DuccService");
            Method bootMethod = duccServiceClass.getMethod("boot", String[].class);
            Method setProcessorMethod = duccServiceClass.getMethod("setProcessor", Object.class, String[].class);
            Method registerInvestmentInstanceMethod = duccServiceClass.getMethod("registerInvestmentInstance", Object.class);
            this.startMethod = duccServiceClass.getMethod("start", new Class[0]);
            this.stopMethod = duccServiceClass.getMethod("stop", new Class[0]);
            this.logger.log(Level.INFO, ">>>>>>>>> Booting Ducc Container");
            HashMap<String, String> savedPropsMap = UimaAsServiceWrapper.hideLoggingProperties();
            Thread.currentThread().setContextClassLoader(ucl);
            this.duccContainerInstance = duccServiceClass.newInstance();
            bootMethod.invoke(this.duccContainerInstance, new Object[]{args});
            this.logger.log(Level.INFO, "<<<<<<<< Ducc Container booted");
            UimaAsServiceWrapper.restoreLoggingProperties(savedPropsMap);
            String processorClass = System.getProperty("ducc.deploy.JpProcessorClass");
            Class<?> processorClz = sysCL.loadClass(processorClass);
            IProcessContainer pc = (IProcessContainer)processorClz.newInstance();
            this.logger.log(Level.INFO, ">>>>>>>>> Running Ducc Container class:" + pc.getClass().getName());
            setProcessorMethod.invoke(this.duccContainerInstance, pc, args);
            registerInvestmentInstanceMethod.invoke(this.duccContainerInstance, this.investment);
            this.logger.log(Level.INFO, "<<<<<<<< Ducc Container ended");
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.out.println("Exiting Process Due to Unrecoverable Error");
            Runtime.getRuntime().halt(99);
        }
    }

    @Override
    public void start() throws Exception {
        this.startMethod.invoke(this.duccContainerInstance, new Object[0]);
    }

    public static HashMap<String, String> hideLoggingProperties() {
        String[] propsToSave = new String[]{"log4j.configuration", "java.util.logging.config.file", "java.util.logging.config.class", "org.apache.uima.logger.class"};
        HashMap<String, String> savedPropsMap = new HashMap<String, String>();
        for (String prop : propsToSave) {
            String val = System.getProperty(prop);
            if (val == null) continue;
            savedPropsMap.put(prop, val);
            System.getProperties().remove(prop);
        }
        return savedPropsMap;
    }

    public static void restoreLoggingProperties(HashMap<String, String> savedPropsMap) {
        for (String prop : savedPropsMap.keySet()) {
            System.setProperty(prop, savedPropsMap.get(prop));
        }
    }

    @Override
    public void stop() throws Exception {
        try {
            this.stopMethod.invoke(this.duccContainerInstance, new Object[0]);
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "Stop failed");
            t.printStackTrace();
        }
    }
}

