/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.json.JsonWriter;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.StaxReader;
import com.thoughtworks.xstream.io.xml.StaxWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.xstream.AbstractXStreamWrapper;
import org.apache.camel.spi.ClassResolver;
import org.codehaus.jettison.mapped.MappedXMLInputFactory;
import org.codehaus.jettison.mapped.MappedXMLOutputFactory;

public class JsonDataFormat
extends AbstractXStreamWrapper {
    private final MappedXMLOutputFactory mof;
    private final MappedXMLInputFactory mif;
    private boolean prettyPrint;

    public JsonDataFormat() {
        HashMap nstjsons = new HashMap();
        this.mof = new MappedXMLOutputFactory(nstjsons);
        this.mif = new MappedXMLInputFactory(nstjsons);
    }

    public String getDataFormatName() {
        return "json-xstream";
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    @Override
    public void marshal(Exchange exchange, Object body, OutputStream stream) throws Exception {
        super.marshal(exchange, body, stream);
        if (this.isContentTypeHeader()) {
            if (exchange.hasOut()) {
                exchange.getOut().setHeader("Content-Type", (Object)"application/json");
            } else {
                exchange.getIn().setHeader("Content-Type", (Object)"application/json");
            }
        }
    }

    @Override
    protected XStream createXStream(ClassResolver resolver, ClassLoader classLoader) {
        XStream xs = super.createXStream(resolver, classLoader);
        if (this.getMode() != null) {
            xs.setMode(this.getModeFromString(this.getMode()));
        } else {
            xs.setMode(1001);
        }
        return xs;
    }

    @Override
    protected HierarchicalStreamWriter createHierarchicalStreamWriter(Exchange exchange, Object body, OutputStream stream) throws XMLStreamException {
        if (this.isPrettyPrint()) {
            try {
                return new JsonWriter((Writer)new OutputStreamWriter(stream, "UTF-8"));
            }
            catch (UnsupportedEncodingException uee) {
                throw new XMLStreamException(uee);
            }
        }
        return new StaxWriter(new QNameMap(), this.mof.createXMLStreamWriter(stream));
    }

    @Override
    protected HierarchicalStreamReader createHierarchicalStreamReader(Exchange exchange, InputStream stream) throws XMLStreamException {
        return new StaxReader(new QNameMap(), this.mif.createXMLStreamReader(stream));
    }
}

