/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ps.service.processor.uima;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.ducc.ps.service.IScaleable;
import org.apache.uima.ducc.ps.service.IServiceState;
import org.apache.uima.ducc.ps.service.ServiceConfiguration;
import org.apache.uima.ducc.ps.service.dgen.DeployableGenerator;
import org.apache.uima.ducc.ps.service.dgen.DuccUimaReferenceByName;
import org.apache.uima.ducc.ps.service.errors.IServiceErrorHandler;
import org.apache.uima.ducc.ps.service.errors.ServiceInitializationException;
import org.apache.uima.ducc.ps.service.metrics.builtin.ProcessWindowStats;
import org.apache.uima.ducc.ps.service.monitor.IServiceMonitor;
import org.apache.uima.ducc.ps.service.monitor.builtin.RemoteStateObserver;
import org.apache.uima.ducc.ps.service.processor.IProcessResult;
import org.apache.uima.ducc.ps.service.processor.IServiceProcessor;
import org.apache.uima.ducc.ps.service.processor.IServiceResultSerializer;
import org.apache.uima.ducc.ps.service.processor.uima.AbstractServiceProcessor;
import org.apache.uima.ducc.ps.service.processor.uima.UimaProcessResult;
import org.apache.uima.ducc.ps.service.processor.uima.UimaServiceProcessor;
import org.apache.uima.ducc.ps.service.processor.uima.utils.PerformanceMetrics;
import org.apache.uima.ducc.ps.service.processor.uima.utils.UimaResultDefaultSerializer;
import org.apache.uima.ducc.ps.service.utils.UimaSerializer;
import org.apache.uima.ducc.ps.service.utils.Utils;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.TypeSystemDescription_impl;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class UimaAsServiceProcessor
extends AbstractServiceProcessor
implements IServiceProcessor,
IScaleable {
    private static final Class<?> CLASS_NAME = UimaAsServiceProcessor.class;
    Logger logger = UIMAFramework.getLogger(UimaServiceProcessor.class);
    private static Object brokerInstance = null;
    private UimaAsClientWrapper uimaASClient = null;
    private String saxonURL = null;
    private String xslTransform = null;
    protected Object initializeMonitor = new Object();
    private static volatile boolean brokerRunning = false;
    private static final char FS = System.getProperty("file.separator").charAt(0);
    private static final CountDownLatch brokerLatch = new CountDownLatch(1);
    public static final String brokerPropertyName = "ducc.broker.name";
    public static final String queuePropertyName = "ducc.queue.name";
    public static final String duccNodeName = "DUCC_NODENAME";
    private IServiceResultSerializer resultSerializer;
    private static Class<?> classToLaunch = null;
    private String aeName = "";
    private int scaleout = 1;
    private static Object platformMBeanServer;
    private ServiceConfiguration serviceConfiguration;
    private IServiceMonitor monitor;
    private IServiceErrorHandler errorHandler;
    public volatile boolean initialized = false;
    private String[] deploymentDescriptors = null;
    private String[] ids = null;
    private String duccHome = null;
    boolean enablePerformanceBreakdownReporting = false;
    private AtomicInteger numberOfInitializedThreads = new AtomicInteger();
    private String[] args;

    public UimaAsServiceProcessor(String[] args, ServiceConfiguration serviceConfiguration) {
        this.args = args;
        this.serviceConfiguration = serviceConfiguration;
        this.launchStateInitializationCollector();
    }

    @Override
    public void setScaleout(int howManyThreads) {
        this.scaleout = howManyThreads;
    }

    @Override
    public int getScaleout() {
        return this.scaleout;
    }

    @Override
    public void setErrorHandlerWindow(int maxErrors, int windowSize) {
        this.maxErrors = maxErrors;
        this.windowSize = windowSize;
    }

    private int generateDescriptorsAndGetScaleout(String[] args) throws Exception {
        this.deploymentDescriptors = this.getDescriptors(args);
        this.ids = new String[this.deploymentDescriptors.length];
        return this.scaleout;
    }

    private void enableMetricsIfNewUimaAs() throws Exception {
        UimaAsVersionWrapper uimaVersion = new UimaAsVersionWrapper();
        int majorVersion = uimaVersion.getMajor();
        int minorVersion = uimaVersion.getMinor();
        int buildRevision = uimaVersion.getRevision();
        if (majorVersion > 2 || majorVersion == 2 && (minorVersion > 6 || minorVersion == 6 && buildRevision > 1)) {
            this.enablePerformanceBreakdownReporting = true;
        }
    }

    private void launchStateInitializationCollector() {
        this.monitor = new RemoteStateObserver(this.serviceConfiguration, this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() throws ServiceInitializationException {
        try {
            this.duccHome = System.getProperty("DUCC_HOME");
            String pid = Utils.getPID("Queue");
            String endpointName = System.getenv(duccNodeName) != null ? System.getenv(duccNodeName) + pid : InetAddress.getLocalHost().getCanonicalHostName() + pid;
            System.setProperty(queuePropertyName, endpointName);
            this.errorHandler = this.getErrorHandler(this.logger);
            Class<UimaAsServiceProcessor> clazz = UimaAsServiceProcessor.class;
            synchronized (UimaAsServiceProcessor.class) {
                this.serializerMap.put(Thread.currentThread().getId(), new UimaSerializer());
                if (!this.initialized) {
                    this.monitor.onStateChange(IServiceState.State.Initializing.toString(), new Properties());
                    Properties duccProperties = this.loadDuccProperties();
                    String saxonPath = this.resolvePlaceholders(duccProperties.getProperty("ducc.uima-as.saxon.jar.path"), System.getProperties());
                    String xsltPath = this.resolvePlaceholders(duccProperties.getProperty("ducc.uima-as.dd2spring.xsl.path"), System.getProperties());
                    ArrayList<String> argList = new ArrayList<String>();
                    argList.add("-d");
                    argList.add(this.args[0]);
                    argList.add("-saxonURL");
                    argList.add(saxonPath);
                    argList.add("-xslt");
                    argList.add(xsltPath);
                    if (System.getProperty("ducc.deploy.JpThreadCount") != null) {
                        argList.add("-t");
                        argList.add(System.getProperty("ducc.deploy.JpThreadCount"));
                    }
                    this.enableMetricsIfNewUimaAs();
                    this.resultSerializer = new UimaResultDefaultSerializer();
                    this.uimaASClient = new UimaAsClientWrapper();
                    this.scaleout = this.generateDescriptorsAndGetScaleout(argList.toArray(new String[argList.size()]));
                    if (this.scaleout == 0) {
                        this.scaleout = 1;
                    }
                    this.initialized = true;
                }
                this.doDeploy();
                // ** MonitorExit[var3_4] (shouldn't be in output)
                if (this.numberOfInitializedThreads.incrementAndGet() == this.scaleout) {
                    super.delay(this.logger, this.DEFAULT_INIT_DELAY);
                    this.monitor.onStateChange(IServiceState.State.Running.toString(), new Properties());
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, null, (Throwable)e);
            this.monitor.onStateChange(IServiceState.State.FailedInitialization.toString(), new Properties());
            throw new ServiceInitializationException("", e);
        }
    }

    public String resolvePlaceholders(String contents, Properties props) {
        Pattern placeHolderPattern = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher matcher = placeHolderPattern.matcher(contents);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(1);
            String placeholderValue = props.getProperty(key);
            if (placeholderValue == null && (placeholderValue = System.getProperty(key)) == null) {
                throw new IllegalArgumentException("Missing value for placeholder: " + key);
            }
            matcher.appendReplacement(sb, placeholderValue);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private CAS getCAS(String serializedTask) throws Exception {
        CAS cas = this.uimaASClient.getCAS();
        if (this.serviceConfiguration.getJpType() != null) {
            this.getUimaSerializer().deserializeCasFromXmi(serializedTask, cas);
        } else {
            cas.setDocumentText(serializedTask);
            cas.setDocumentLanguage("en");
        }
        return cas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProcessResult process(String serializedTask) {
        UimaProcessResult uimaProcessResult;
        CAS cas = null;
        try {
            cas = this.getCAS(serializedTask);
            ArrayList<PerformanceMetrics> casMetrics = new ArrayList<PerformanceMetrics>();
            if (this.enablePerformanceBreakdownReporting) {
                ArrayList perfMetrics = new ArrayList();
                try {
                    this.uimaASClient.sendAndReceive(cas, perfMetrics);
                    this.successCount.incrementAndGet();
                    this.errorCountSinceLastSuccess.set(0L);
                }
                catch (Exception t) {
                    UimaProcessResult result;
                    this.logger.log(Level.WARNING, "", (Throwable)t);
                    ProcessWindowStats stats = new ProcessWindowStats(this.errorCount.incrementAndGet(), this.successCount.get(), this.errorCountSinceLastSuccess.incrementAndGet());
                    IServiceErrorHandler.Action action = this.errorHandler.handleProcessError(t, this, stats);
                    UimaProcessResult uimaProcessResult2 = result = new UimaProcessResult(t, action);
                    if (cas != null) {
                        cas.release();
                    }
                    return uimaProcessResult2;
                }
                for (Object metrics : perfMetrics) {
                    Method nameMethod = metrics.getClass().getDeclaredMethod("getName", new Class[0]);
                    String name = (String)nameMethod.invoke(metrics, new Object[0]);
                    Method uniqueNameMethod = metrics.getClass().getDeclaredMethod("getUniqueName", new Class[0]);
                    String uniqueName = (String)uniqueNameMethod.invoke(metrics, new Object[0]);
                    Method analysisTimeMethod = metrics.getClass().getDeclaredMethod("getAnalysisTime", new Class[0]);
                    long analysisTime = (Long)analysisTimeMethod.invoke(metrics, new Object[0]);
                    Method currentTaskCountMethod = metrics.getClass().getDeclaredMethod("getNumProcessed", new Class[0]);
                    long currentTaskCount = (Long)currentTaskCountMethod.invoke(metrics, new Object[0]);
                    boolean aggregate = uniqueName.startsWith("/" + name);
                    int pos = uniqueName.indexOf("/", 1);
                    if (pos > -1 && this.scaleout > 1 && name != null && aggregate) {
                        String st = uniqueName.substring(pos);
                        uniqueName = "/" + name + st;
                    }
                    PerformanceMetrics pm = new PerformanceMetrics(name, uniqueName, analysisTime, currentTaskCount);
                    casMetrics.add(pm);
                }
            } else {
                try {
                    this.uimaASClient.sendAndReceive(cas);
                    this.successCount.incrementAndGet();
                    this.errorCountSinceLastSuccess.set(0L);
                }
                catch (Exception t) {
                    UimaProcessResult result;
                    this.logger.log(Level.WARNING, "", (Throwable)t);
                    ProcessWindowStats stats = new ProcessWindowStats(this.errorCount.incrementAndGet(), this.successCount.get(), this.errorCountSinceLastSuccess.incrementAndGet());
                    IServiceErrorHandler.Action action = this.errorHandler.handleProcessError(t, this, stats);
                    UimaProcessResult uimaProcessResult3 = result = new UimaProcessResult(t, action);
                    if (cas != null) {
                        cas.release();
                    }
                    return uimaProcessResult3;
                }
                PerformanceMetrics pm = new PerformanceMetrics("Performance Metrics Not Supported For DD Jobs and UIMA-AS <= v2.6.0", "Performance Metrics Not Supported For DD Jobs and UIMA-AS <= v2.6.0 ", 0L, 0L);
                casMetrics.add(pm);
            }
            uimaProcessResult = new UimaProcessResult(this.resultSerializer.serialize(casMetrics));
            return uimaProcessResult;
        }
        catch (Exception t) {
            UimaProcessResult result;
            this.logger.log(Level.WARNING, "", (Throwable)t);
            uimaProcessResult = result = new UimaProcessResult(t, IServiceErrorHandler.Action.TERMINATE);
            return uimaProcessResult;
        }
        finally {
            if (cas != null) {
                cas.release();
            }
        }
    }

    private void doDeploy() throws Exception {
        try {
            if (brokerInstance == null) {
                this.deployBroker(this.duccHome);
                brokerRunning = true;
                int i = 0;
                for (String dd : this.deploymentDescriptors) {
                    this.ids[i] = this.uimaASClient.deployService(dd);
                }
                this.uimaASClient.initialize();
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.WARNING, "UimaAsServiceProcesser", e);
            throw new RuntimeException(e);
        }
    }

    private Properties loadDuccProperties() throws Exception {
        Properties duccProperties = new Properties();
        duccProperties.load(new FileInputStream(System.getProperty("ducc.deploy.configuration")));
        return duccProperties;
    }

    private String[] getDescriptors(String[] args) throws Exception {
        int nbrOfArgs = args.length;
        String[] deploymentDescriptors = Utils.getMultipleArg("-d", args);
        if (deploymentDescriptors.length == 0) {
            deploymentDescriptors = Utils.getMultipleArg2("-dd", args);
        }
        for (String arg : args) {
            this.logger.log(Level.INFO, "+++++++++++++++ arg:" + arg);
        }
        this.saxonURL = Utils.getArg("-saxonURL", args);
        this.xslTransform = Utils.getArg("-xslt", args);
        String threadCount = Utils.getArg("-t", args);
        if (threadCount.isEmpty()) {
            threadCount = "1";
        }
        if (nbrOfArgs < 1 || deploymentDescriptors.length == 0 || this.saxonURL.equals("") || this.xslTransform.equals("")) {
            UimaAsServiceProcessor.printUsageMessage();
            return null;
        }
        deploymentDescriptors[0] = this.parseDD(deploymentDescriptors[0], threadCount);
        return deploymentDescriptors;
    }

    public String parseDD(String ddPath, String threadCount) throws Exception {
        DuccUimaReferenceByName configuration;
        String logfile = System.getenv("DUCC_PROCESS_LOG_PREFIX");
        String logDir = new File(logfile).getParent();
        DeployableGenerator deployableGenerator = new DeployableGenerator(logDir);
        String ddNew = deployableGenerator.generateDd(configuration = new DuccUimaReferenceByName(0, ddPath), System.getenv("DUCC_JOBID"), true);
        if (ddNew != ddPath) {
            this.logger.log(Level.INFO, "Generated " + ddNew + " from " + ddPath);
        }
        int ddScaleout = deployableGenerator.getScaleout();
        if (threadCount == null) {
            this.scaleout = ddScaleout;
            this.logger.log(Level.INFO, "DD specifies a scaleout of " + this.scaleout);
        } else {
            this.scaleout = Integer.parseInt(threadCount);
            if (ddScaleout != this.scaleout) {
                this.logger.log(Level.WARNING, "Scaleout specified as " + this.scaleout + " but the DD is configured for " + ddScaleout);
            }
        }
        return ddNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Class<UimaAsServiceProcessor> clazz = UimaAsServiceProcessor.class;
        synchronized (UimaAsServiceProcessor.class) {
            if (brokerRunning) {
                this.logger.log(Level.INFO, "Stopping UIMA-AS Client");
                System.out.println("Stopping UIMA-AS Client");
                try {
                    System.setProperty("dontKill", "true");
                    this.uimaASClient.stop();
                    System.out.println("UIMA-AS Client Stopped");
                    Method brokerStopMethod = classToLaunch.getMethod("stop", new Class[0]);
                    brokerStopMethod.invoke(brokerInstance, new Object[0]);
                    Method waitMethod = classToLaunch.getMethod("waitUntilStopped", new Class[0]);
                    waitMethod.invoke(brokerInstance, new Object[0]);
                    brokerRunning = false;
                    System.out.println("Internal Broker Stopped");
                    super.stop();
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, "stop", (Throwable)e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void deployBroker(String duccHome) throws Exception {
        ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
        HashMap<String, String> savedPropsMap = null;
        try {
            String[] brokerClasspath = new String[]{duccHome + File.separator + "apache-uima" + File.separator + "apache-activemq" + File.separator + "lib" + File.separator + "*", duccHome + File.separator + "apache-uima" + File.separator + "apache-activemq" + File.separator + "lib" + File.separator + "optional" + File.separator + "*"};
            URLClassLoader ucl = Utils.create(brokerClasspath);
            Thread.currentThread().setContextClassLoader(ucl);
            savedPropsMap = Utils.hideLoggingProperties();
            classToLaunch = ucl.loadClass("org.apache.activemq.broker.BrokerService");
            if (System.getProperty("ducc.debug") != null) {
                Utils.dump(ucl, 4);
            }
            brokerInstance = classToLaunch.newInstance();
            Method setDedicatedTaskRunnerMethod = classToLaunch.getMethod("setDedicatedTaskRunner", Boolean.TYPE);
            setDedicatedTaskRunnerMethod.invoke(brokerInstance, false);
            Method setPersistentMethod = classToLaunch.getMethod("setPersistent", Boolean.TYPE);
            setPersistentMethod.invoke(brokerInstance, false);
            int port = 61626;
            String brokerURL = "tcp://localhost:";
            while (true) {
                try {
                    Method addConnectorMethod = classToLaunch.getMethod("addConnector", String.class);
                    addConnectorMethod.invoke(brokerInstance, brokerURL + port);
                    Method startMethod = classToLaunch.getMethod("start", new Class[0]);
                    startMethod.invoke(brokerInstance, new Object[0]);
                    Method waitUntilStartedMethod = classToLaunch.getMethod("waitUntilStarted", new Class[0]);
                    waitUntilStartedMethod.invoke(brokerInstance, new Object[0]);
                    System.setProperty("DefaultBrokerURL", brokerURL + port);
                    System.setProperty("BrokerURI", brokerURL + port);
                    System.setProperty(brokerPropertyName, brokerURL + port);
                }
                catch (Exception e) {
                    if (this.isBindException(e)) {
                        ++port;
                        continue;
                    }
                    throw new RuntimeException(e);
                }
                break;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentCL);
            brokerLatch.countDown();
            Utils.restoreLoggingProperties(savedPropsMap);
        }
    }

    private boolean isBindException(Throwable e) {
        if (e == null) {
            return false;
        }
        if (e instanceof BindException) {
            return true;
        }
        if (e instanceof SocketException && "Address already in use".equals(e.getMessage())) {
            return true;
        }
        if (e.getCause() != null) {
            return this.isBindException(e.getCause());
        }
        return false;
    }

    private static void printUsageMessage() {
        System.out.println(" Arguments to the program are as follows : \n-d path-to-UIMA-Deployment-Descriptor [-d path-to-UIMA-Deployment-Descriptor ...] \n-saxon path-to-saxon.jar \n-q top level service queue name \n-xslt path-to-dd2spring-xslt\n   or\npath to Spring XML Configuration File which is the output of running dd2spring\n");
    }

    public static void main(String[] args) {
        try {
            UimaAsServiceProcessor processor = new UimaAsServiceProcessor(args, null);
            processor.initialize();
            CAS cas = CasCreationUtils.createCas((TypeSystemDescription)new TypeSystemDescription_impl(), null, null);
            cas.setDocumentLanguage("en");
            cas.setDocumentText("Test");
            UimaSerializer serializer = new UimaSerializer();
            String serializedCas = serializer.serializeCasToXmi(cas);
            IProcessResult result = processor.process(serializedCas);
            System.out.println("Client Received Result - Success:" + (result.getResult() != null));
            processor.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            Class<?> managementFactory = Class.forName("java.lang.management.ManagementFactory");
            Method getPlatformMBeanServer = managementFactory.getMethod("getPlatformMBeanServer", new Class[0]);
            platformMBeanServer = getPlatformMBeanServer.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            platformMBeanServer = null;
        }
    }

    private class UimaAsVersionWrapper {
        Class<?> clz = Class.forName("org.apache.uima.aae.UimaAsVersion");
        Method m = null;

        public String getFullVersion() throws Exception {
            this.m = this.clz.getDeclaredMethod("getFullVersionString", new Class[0]);
            return (String)this.m.invoke(null, new Object[0]);
        }

        public int getMajor() throws Exception {
            Method majorVersionMethod = this.clz.getDeclaredMethod("getMajorVersion", new Class[0]);
            return ((Short)majorVersionMethod.invoke(null, new Object[0])).shortValue();
        }

        public int getMinor() throws Exception {
            Method minorVersionMethod = this.clz.getDeclaredMethod("getMinorVersion", new Class[0]);
            return ((Short)minorVersionMethod.invoke(null, new Object[0])).shortValue();
        }

        public int getRevision() throws Exception {
            Method buildRevisionMethod = this.clz.getDeclaredMethod("getBuildRevision", new Class[0]);
            return ((Short)buildRevisionMethod.invoke(null, new Object[0])).shortValue();
        }
    }

    private class UimaAsClientWrapper {
        private Object uimaASClient;
        private Class<?> clientClz = Class.forName("org.apache.uima.adapter.jms.client.BaseUIMAAsynchronousEngine_impl");

        public UimaAsClientWrapper() throws Exception {
            this.uimaASClient = this.clientClz.newInstance();
        }

        public String deployService(String aDeploymentDescriptorPath) throws Exception {
            HashMap<String, Object> appCtx = new HashMap<String, Object>();
            Class<?> clz = Class.forName("org.apache.uima.aae.client.UimaAsynchronousEngine");
            appCtx.put((String)clz.getField("DD2SpringXsltFilePath").get(this.uimaASClient), UimaAsServiceProcessor.this.xslTransform.replace('/', FS));
            appCtx.put((String)clz.getField("SaxonClasspath").get(this.uimaASClient), UimaAsServiceProcessor.this.saxonURL.replace('/', FS));
            appCtx.put((String)clz.getField("CasPoolSize").get(this.uimaASClient), UimaAsServiceProcessor.this.scaleout);
            String containerId = null;
            ClassLoader duccCl = Thread.currentThread().getContextClassLoader();
            ClassLoader cl = this.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            Method deployMethod = this.uimaASClient.getClass().getDeclaredMethod("deploy", String.class, Map.class);
            containerId = (String)deployMethod.invoke(this.uimaASClient, aDeploymentDescriptorPath, appCtx);
            Thread.currentThread().setContextClassLoader(duccCl);
            return containerId;
        }

        private void initialize() throws Exception {
            String endpoint = System.getProperty(UimaAsServiceProcessor.queuePropertyName);
            String brokerURL = System.getProperty(UimaAsServiceProcessor.brokerPropertyName);
            HashMap<String, Object> appCtx = new HashMap<String, Object>();
            Class<?> clz = Class.forName("org.apache.uima.aae.client.UimaAsynchronousEngine");
            appCtx.put((String)clz.getField("ServerUri").get(this.uimaASClient), brokerURL);
            appCtx.put((String)clz.getField("ENDPOINT").get(this.uimaASClient), endpoint);
            appCtx.put((String)clz.getField("CasPoolSize").get(this.uimaASClient), UimaAsServiceProcessor.this.scaleout);
            appCtx.put((String)clz.getField("Timeout").get(this.uimaASClient), 0);
            appCtx.put((String)clz.getField("GetMetaTimeout").get(this.uimaASClient), 0);
            appCtx.put((String)clz.getField("CpcTimeout").get(this.uimaASClient), 1100);
            Method initMethod = this.uimaASClient.getClass().getMethod("initialize", Map.class);
            initMethod.invoke(this.uimaASClient, appCtx);
            Method getMetaMethod = this.uimaASClient.getClass().getMethod("getMetaData", new Class[0]);
            Object meta = getMetaMethod.invoke(this.uimaASClient, new Object[0]);
            Method nameMethod = meta.getClass().getMethod("getName", new Class[0]);
            UimaAsServiceProcessor.this.aeName = (String)nameMethod.invoke(meta, new Object[0]);
        }

        public CAS getCAS() throws Exception {
            Method getCasMethod = this.uimaASClient.getClass().getMethod("getCAS", new Class[0]);
            return (CAS)getCasMethod.invoke(this.uimaASClient, new Object[0]);
        }

        public void sendAndReceive(CAS cas, List<?> perfMetrics) throws Exception {
            Method sendMethod = this.uimaASClient.getClass().getMethod("sendAndReceiveCAS", CAS.class, List.class);
            sendMethod.invoke(this.uimaASClient, cas, perfMetrics);
        }

        public void sendAndReceive(CAS cas) throws Exception {
            Method sendMethod = this.uimaASClient.getClass().getDeclaredMethod("sendAndReceiveCAS", CAS.class);
            sendMethod.invoke(this.uimaASClient, cas);
        }

        public void stop() throws Exception {
            Method clientStopMethod = this.uimaASClient.getClass().getDeclaredMethod("stop", new Class[0]);
            clientStopMethod.invoke(this.uimaASClient, new Object[0]);
        }
    }
}

