/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ps.service.jmx;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.uima.analysis_engine.AnalysisEngineManagement;
import org.apache.uima.ducc.ps.service.monitor.IServiceMonitor;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class JmxAEProcessInitMonitor
implements Runnable {
    private volatile boolean running = false;
    private MBeanServer server = null;
    private IServiceMonitor monitor;
    private static int howManySeenSoFar = 1;
    private Logger logger;
    public List<IUimaPipelineAEComponent> aeStateList = new ArrayList<IUimaPipelineAEComponent>();

    public JmxAEProcessInitMonitor(IServiceMonitor monitor, Logger logger) {
        this.server = ManagementFactory.getPlatformMBeanServer();
        this.monitor = monitor;
        this.logger = logger;
    }

    private IUimaPipelineAEComponent getUimaAeByName(String name) {
        for (IUimaPipelineAEComponent aeState : this.aeStateList) {
            if (!aeState.getAeName().equals(name)) continue;
            return aeState;
        }
        return null;
    }

    public void updateAgentWhenRunning() {
        this.running = true;
        try {
            this.run();
        }
        catch (Exception ex) {
            this.logger.log(Level.WARNING, "", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.running) {
            return;
        }
        try {
            ObjectName uimaServicePattern = new ObjectName("org.apache.uima:*");
            HashSet<ObjectInstance> mbeans = new HashSet<ObjectInstance>(this.server.queryMBeans(uimaServicePattern, null));
            ArrayList<IUimaPipelineAEComponent> componentsToDelete = new ArrayList<IUimaPipelineAEComponent>();
            boolean updateMonitor = false;
            for (ObjectInstance objectInstance : mbeans) {
                String[] aeObjectNameParts;
                String targetName = objectInstance.getObjectName().getKeyProperty("name");
                if (targetName.endsWith("FlowController") || targetName.trim().endsWith("DUCC.Job") || !objectInstance.getClassName().equals("org.apache.uima.analysis_engine.impl.AnalysisEngineManagementImpl") || (aeObjectNameParts = objectInstance.getObjectName().toString().split(",")).length == 3) continue;
                StringBuilder sb = new StringBuilder();
                for (String part : aeObjectNameParts) {
                    if (part.startsWith("org.apache.uima:type") || part.startsWith("s=")) continue;
                    sb.append("/");
                    if (part.endsWith("Components")) {
                        part = part.substring(0, part.indexOf("Components")).trim();
                    }
                    sb.append(part.substring(part.indexOf("=") + 1));
                }
                AnalysisEngineManagement proxy = JMX.newMBeanProxy(this.server, objectInstance.getObjectName(), AnalysisEngineManagement.class);
                IUimaPipelineAEComponent aeState = null;
                aeState = this.getUimaAeByName(sb.toString());
                if (aeState == null) {
                    if (AnalysisEngineManagement.State.valueOf((String)proxy.getState()).equals((Object)AnalysisEngineManagement.State.Ready)) continue;
                    aeState = new UimaPipelineAEComponent(sb.toString(), proxy.getThreadId(), AnalysisEngineManagement.State.valueOf((String)proxy.getState()));
                    this.aeStateList.add(aeState);
                    ((UimaPipelineAEComponent)aeState).startInitialization = System.currentTimeMillis();
                    aeState.setAeState(AnalysisEngineManagement.State.Initializing);
                    updateMonitor = true;
                } else if (AnalysisEngineManagement.State.valueOf((String)proxy.getState()).equals((Object)AnalysisEngineManagement.State.Initializing)) {
                    updateMonitor = true;
                    aeState.setInitializationTime(System.currentTimeMillis() - ((UimaPipelineAEComponent)aeState).startInitialization);
                } else if (aeState.getAeState().equals((Object)AnalysisEngineManagement.State.Initializing) && AnalysisEngineManagement.State.valueOf((String)proxy.getState()).equals((Object)AnalysisEngineManagement.State.Ready)) {
                    aeState.setAeState(AnalysisEngineManagement.State.Ready);
                    updateMonitor = true;
                    JmxAEProcessInitMonitor jmxAEProcessInitMonitor = this;
                    synchronized (jmxAEProcessInitMonitor) {
                        try {
                            this.wait(5L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    aeState.setInitializationTime(proxy.getInitializationTime());
                    componentsToDelete.add(aeState);
                }
                if (!this.logger.isLoggable(Level.FINE)) continue;
                this.logger.log(Level.FINE, "UimaAEJmxMonitor.run()---- AE Name:" + proxy.getName() + " AE State:" + proxy.getState() + " AE init time=" + aeState.getInitializationTime() + " Proxy Init time=" + proxy.getInitializationTime() + " Proxy Thread ID:" + proxy.getThreadId());
            }
            howManySeenSoFar = 1;
            if (updateMonitor && !this.running) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "UimaAEJmxMonitor.run() ---- Publishing UimaPipelineAEComponent List - size=" + this.aeStateList.size());
                }
                try {
                    if (this.monitor != null) {
                        StringBuilder sb = new StringBuilder();
                        for (IUimaPipelineAEComponent ae : this.aeStateList) {
                            sb.append("[").append(ae.getAeName()).append(",").append(ae.getAeState()).append(",").append(ae.getInitializationTime()).append(",").append(ae.getAeThreadId()).append("]");
                        }
                        Properties properties = new Properties();
                        properties.setProperty("SERVICE_UIMA_INIT_STATE", sb.toString());
                        this.monitor.onStateChange(properties);
                    }
                }
                catch (Exception ex) {
                    throw ex;
                }
                finally {
                    for (IUimaPipelineAEComponent aeState : componentsToDelete) {
                        this.aeStateList.remove(aeState);
                    }
                }
            }
        }
        catch (UndeclaredThrowableException e) {
            if (!(e.getCause() instanceof InstanceNotFoundException)) {
                if (howManySeenSoFar > 3) {
                    if (this.logger.isLoggable(Level.INFO)) {
                        this.logger.log(Level.INFO, "", (Throwable)e);
                    }
                    howManySeenSoFar = 1;
                    throw e;
                }
                ++howManySeenSoFar;
            }
        }
        catch (Throwable e) {
            howManySeenSoFar = 1;
            this.logger.log(Level.WARNING, "", e);
        }
    }

    public static interface IUimaPipelineAEComponent
    extends Serializable {
        public String getAeName();

        public AnalysisEngineManagement.State getAeState();

        public void setAeState(AnalysisEngineManagement.State var1);

        public long getAeThreadId();

        public long getInitializationTime();

        public void setInitializationTime(long var1);
    }

    public class UimaPipelineAEComponent
    implements IUimaPipelineAEComponent {
        private static final long serialVersionUID = 1L;
        String name;
        AnalysisEngineManagement.State state;
        long threadId;
        long initializationTime;
        public transient long startInitialization;

        public UimaPipelineAEComponent(String name, long threadId, AnalysisEngineManagement.State state) {
            this.name = name;
            this.threadId = threadId;
            this.state = state;
        }

        @Override
        public long getInitializationTime() {
            return this.initializationTime;
        }

        @Override
        public void setInitializationTime(long initializationTime) {
            this.initializationTime = initializationTime;
        }

        @Override
        public String getAeName() {
            return this.name;
        }

        @Override
        public AnalysisEngineManagement.State getAeState() {
            return this.state;
        }

        @Override
        public void setAeState(AnalysisEngineManagement.State state) {
            this.state = state;
        }

        @Override
        public long getAeThreadId() {
            return this.threadId;
        }
    }
}

