/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ps.service.errors.builtin;

import java.util.Arrays;
import org.apache.uima.ducc.ps.service.IServiceComponent;
import org.apache.uima.ducc.ps.service.errors.IServiceErrorHandler;
import org.apache.uima.ducc.ps.service.metrics.IWindowStats;

public class WindowBasedErrorHandler
implements IServiceErrorHandler {
    private int errorThreshold = 1;
    private int windowSize = 1;
    private long errorCount = 0L;
    private long[] errorSequences;

    public WindowBasedErrorHandler withMaxFrameworkErrors(int maxFrameworkError) {
        this.errorThreshold = maxFrameworkError;
        return this;
    }

    public WindowBasedErrorHandler withProcessErrorWindow(int errorWindow) {
        this.windowSize = errorWindow;
        return this;
    }

    public WindowBasedErrorHandler build() {
        if (this.windowSize >= this.errorThreshold && this.errorThreshold > 1) {
            this.errorSequences = new long[this.errorThreshold - 1];
            Arrays.fill(this.errorSequences, (long)(-this.windowSize));
        }
        return this;
    }

    public boolean exceededErrorWindow(long taskCount) {
        if (this.errorThreshold == 0) {
            return false;
        }
        ++this.errorCount;
        if (this.errorSequences == null) {
            return this.errorCount >= (long)this.errorThreshold;
        }
        int i = this.errorThreshold - 1;
        while (--i >= 0) {
            if (this.errorSequences[i] > taskCount - (long)this.windowSize) continue;
            this.errorSequences[i] = taskCount;
            return false;
        }
        return true;
    }

    @Override
    public IServiceErrorHandler.Action handleProcessError(Exception e, IServiceComponent source, IWindowStats stats) {
        IServiceErrorHandler.Action action = IServiceErrorHandler.Action.CONTINUE;
        if (this.exceededErrorWindow(stats.getSuccessCount())) {
            action = IServiceErrorHandler.Action.TERMINATE;
        }
        return action;
    }

    @Override
    public IServiceErrorHandler.Action handle(Exception e, IServiceComponent source) {
        return IServiceErrorHandler.Action.TERMINATE;
    }
}

