/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tutorial.ex1;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.tutorial.RoomNumber;

public class RoomNumberAnnotator
extends JCasAnnotator_ImplBase {
    private Pattern mYorktownPattern = Pattern.compile("\\b[0-4]\\d-[0-2]\\d\\d\\b");
    private Pattern mHawthornePattern = Pattern.compile("\\b[G1-4][NS]-[A-Z]\\d\\d\\b");

    public void process(JCas aJCas) {
        RoomNumber annotation;
        String docText = aJCas.getDocumentText();
        Matcher matcher = this.mYorktownPattern.matcher(docText);
        while (matcher.find()) {
            annotation = new RoomNumber(aJCas);
            annotation.setBegin(matcher.start());
            annotation.setEnd(matcher.end());
            annotation.setBuilding("Yorktown");
            annotation.addToIndexes();
        }
        matcher = this.mHawthornePattern.matcher(docText);
        while (matcher.find()) {
            annotation = new RoomNumber(aJCas);
            annotation.setBegin(matcher.start());
            annotation.setEnd(matcher.end());
            annotation.setBuilding("Hawthorne");
            annotation.addToIndexes();
        }
    }
}

