/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.event.ProxyReceiver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class AugmentedSource
implements Source {
    private Source source;
    private int schemaValidation = 0;
    private int dtdValidation = 0;
    private XMLReader parser = null;
    private Boolean wrapDocument = null;
    private int treeModel = -1;
    private int stripSpace;
    private Boolean lineNumbering = null;
    private Boolean xIncludeAware = null;
    private boolean pleaseClose = false;
    private EntityResolver entityResolver = null;
    private ErrorListener errorListener = null;
    private List filters = null;

    private AugmentedSource(Source source) {
        if (source instanceof AugmentedSource) {
            throw new IllegalArgumentException("Contained source must not be an AugmentedSource");
        }
        this.source = source;
    }

    public static AugmentedSource makeAugmentedSource(Source source) {
        if (source instanceof AugmentedSource) {
            return (AugmentedSource)source;
        }
        return new AugmentedSource(source);
    }

    public void addFilter(ProxyReceiver proxyReceiver) {
        if (this.filters == null) {
            this.filters = new ArrayList(5);
        }
        this.filters.add(proxyReceiver);
    }

    public List getFilters() {
        return this.filters;
    }

    public Source getContainedSource() {
        return this.source;
    }

    public void setStripSpace(int n) {
        this.stripSpace = n;
    }

    public int getStripSpace() {
        return this.stripSpace;
    }

    public void setTreeModel(int n) {
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("model must be Builder.TINY_TREE or Builder.LINKED_TREE");
        }
        this.treeModel = n;
    }

    public int getTreeModel() {
        return this.treeModel;
    }

    public void setSchemaValidationMode(int n) {
        this.schemaValidation = n;
    }

    public int getSchemaValidation() {
        return this.schemaValidation;
    }

    public void setDTDValidationMode(int n) {
        this.dtdValidation = n;
    }

    public int getDTDValidation() {
        return this.dtdValidation;
    }

    public void setLineNumbering(boolean bl) {
        this.lineNumbering = bl;
    }

    public boolean isLineNumbering() {
        if (this.lineNumbering == null) {
            return false;
        }
        return this.lineNumbering;
    }

    public boolean isLineNumberingSet() {
        return this.lineNumbering != null;
    }

    public void setXMLReader(XMLReader xMLReader) {
        this.parser = xMLReader;
        if (this.source instanceof SAXSource) {
            ((SAXSource)this.source).setXMLReader(xMLReader);
        }
    }

    public XMLReader getXMLReader() {
        if (this.parser != null) {
            return this.parser;
        }
        if (this.source instanceof SAXSource) {
            return ((SAXSource)this.source).getXMLReader();
        }
        return null;
    }

    public void setWrapDocument(Boolean bl) {
        this.wrapDocument = bl;
    }

    public Boolean getWrapDocument() {
        return this.wrapDocument;
    }

    public void setSystemId(String string) {
        this.source.setSystemId(string);
    }

    public String getSystemId() {
        return this.source.getSystemId();
    }

    public void setXIncludeAware(boolean bl) {
        this.xIncludeAware = bl;
    }

    public boolean isXIncludeAwareSet() {
        return this.xIncludeAware != null;
    }

    public boolean isXIncludeAware() {
        if (this.xIncludeAware == null) {
            return false;
        }
        return this.xIncludeAware;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setPleaseCloseAfterUse(boolean bl) {
        this.pleaseClose = bl;
    }

    public boolean isPleaseCloseAfterUse() {
        return this.pleaseClose;
    }

    public void close() {
        try {
            InputSource inputSource;
            if (this.source instanceof StreamSource) {
                StreamSource streamSource = (StreamSource)this.source;
                if (streamSource.getInputStream() != null) {
                    streamSource.getInputStream().close();
                }
                if (streamSource.getReader() != null) {
                    streamSource.getReader().close();
                }
            } else if (this.source instanceof SAXSource && (inputSource = ((SAXSource)this.source).getInputSource()) != null) {
                if (inputSource.getByteStream() != null) {
                    inputSource.getByteStream().close();
                }
                if (inputSource.getCharacterStream() != null) {
                    inputSource.getCharacterStream().close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

