/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.conceptMapper.support.dictionaryResource;

import java.io.Serializable;
import org.apache.uima.conceptMapper.support.dictionaryResource.EntryPropertiesRoot;

public class EntryProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String[] properties;
    private EntryPropertiesRoot entryPropertiesRoot;

    public EntryProperties(EntryPropertiesRoot root, int maxNumberOfProperties) throws NullPointerException {
        if (root == null) {
            throw new NullPointerException("EntryPropertiesRoot cannot be null");
        }
        this.entryPropertiesRoot = root;
        this.properties = new String[maxNumberOfProperties];
    }

    public EntryProperties(EntryProperties toCopyFrom) {
        this.entryPropertiesRoot = toCopyFrom.entryPropertiesRoot;
        this.properties = (String[])toCopyFrom.properties.clone();
    }

    public String getProperty(String propertyName) {
        return this.getProperty(propertyName, null);
    }

    public String getProperty(String propertyName, String defaultValue) {
        int propertyID = this.entryPropertiesRoot.getPropertyID(propertyName);
        if (propertyID < 0) {
            return defaultValue;
        }
        return this.properties[propertyID];
    }

    public void setProperty(String propertyName, String propertyValue) {
        int propertyID = this.entryPropertiesRoot.getPropertyID(propertyName);
        if (propertyID >= 0) {
            this.properties[propertyID] = propertyValue;
        }
    }
}

