/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.logger.LogTargetFactory;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManageable;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManager;
import org.apache.avalon.excalibur.logger.LogTargetManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.log.LogTarget;

public class DefaultLogTargetManager
extends AbstractLogEnabled
implements LogTargetManager,
LogTargetFactoryManageable,
Configurable {
    private final Map m_targets = new HashMap();
    private LogTargetFactoryManager m_factoryManager;

    public final LogTarget getLogTarget(String id) {
        return (LogTarget)this.m_targets.get(id);
    }

    public final void setLogTargetFactoryManager(LogTargetFactoryManager logTargetFactoryManager) {
        this.m_factoryManager = logTargetFactoryManager;
    }

    public final void configure(Configuration configuration) throws ConfigurationException {
        if (null == this.m_factoryManager) {
            String message = "LogTargetFactory not received.";
            throw new ConfigurationException("LogTargetFactory not received.");
        }
        Configuration[] confs = configuration.getChildren();
        for (int i = 0; i < confs.length; ++i) {
            String targetName = confs[i].getName();
            LogTargetFactory logTargetFactory = this.m_factoryManager.getLogTargetFactory(targetName);
            if (logTargetFactory == null) {
                String message = "Factory definition for '" + targetName + "' missing from logger configuration.";
                throw new ConfigurationException(message);
            }
            LogTarget logTarget = logTargetFactory.createTarget(confs[i]);
            String targetId = confs[i].getAttribute("id");
            if (this.getLogger().isDebugEnabled()) {
                String message = "Added new LogTarget of id " + targetId;
                this.getLogger().debug(message);
            }
            this.m_targets.put(targetId, logTarget);
        }
    }
}

