/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.annotation;

import java.lang.reflect.Field;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.annotation.TurbineConfiguration;
import org.apache.turbine.annotation.TurbineLoader;
import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.modules.Assembler;
import org.apache.turbine.modules.Loader;
import org.apache.turbine.services.ServiceManager;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.assemblerbroker.TurbineAssemblerBroker;
import org.apache.turbine.util.TurbineException;

public class AnnotationProcessor {
    private static Log log = LogFactory.getLog(AnnotationProcessor.class);

    public static void process(Object object) throws TurbineException {
        ServiceManager manager = TurbineServices.getInstance();
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (field.isAnnotationPresent(TurbineService.class)) {
                    TurbineService sa = field.getAnnotation(TurbineService.class);
                    String serviceName = null;
                    if (StringUtils.isNotEmpty((String)sa.value())) {
                        serviceName = sa.value();
                    } else {
                        Field[] typeFields;
                        for (Field f : typeFields = field.getType().getFields()) {
                            if ("SERVICE_NAME".equals(f.getName())) {
                                try {
                                    serviceName = (String)f.get(null);
                                    break;
                                }
                                catch (Exception e) {
                                    continue;
                                }
                            }
                            if (!"ROLE".equals(f.getName())) continue;
                            try {
                                serviceName = (String)f.get(null);
                                break;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                    if (StringUtils.isEmpty((String)serviceName)) {
                        serviceName = field.getType().getName();
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Looking up service for injection: " + serviceName + " for object " + object));
                    }
                    Object service = manager.getService(serviceName);
                    field.setAccessible(true);
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Injection of " + serviceName + " into object " + object));
                        }
                        field.set(object, service);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new TurbineException("Could not inject service " + serviceName + " into object " + object, e);
                    }
                    catch (IllegalAccessException e) {
                        throw new TurbineException("Could not inject service " + serviceName + " into object " + object, e);
                    }
                }
                if (field.isAnnotationPresent(TurbineConfiguration.class)) {
                    TurbineConfiguration ca = field.getAnnotation(TurbineConfiguration.class);
                    Configuration conf = null;
                    conf = StringUtils.isNotEmpty((String)ca.value()) ? Turbine.getConfiguration().subset(ca.value()) : Turbine.getConfiguration();
                    field.setAccessible(true);
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Injection of " + conf + " into object " + object));
                        }
                        field.set(object, conf);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new TurbineException("Could not inject configuration " + conf + " into object " + object, e);
                    }
                    catch (IllegalAccessException e) {
                        throw new TurbineException("Could not inject configuration " + conf + " into object " + object, e);
                    }
                }
                if (!field.isAnnotationPresent(TurbineLoader.class)) continue;
                TurbineLoader la = field.getAnnotation(TurbineLoader.class);
                Loader<? extends Assembler> loader = TurbineAssemblerBroker.getLoader(la.value());
                field.setAccessible(true);
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Injection of " + loader + " into object " + object));
                    }
                    field.set(object, loader);
                }
                catch (IllegalArgumentException e) {
                    throw new TurbineException("Could not inject loader " + loader + " into object " + object, e);
                }
                catch (IllegalAccessException e) {
                    throw new TurbineException("Could not inject loader " + loader + " into object " + object, e);
                }
            }
        }
    }
}

