/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.configuration;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ExternalResourceOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.LinkElement;
import org.apache.flink.configuration.description.TextElement;
import org.apache.flink.kubernetes.kubeclient.services.ClusterIPService;
import org.apache.flink.kubernetes.kubeclient.services.HeadlessClusterIPService;
import org.apache.flink.kubernetes.kubeclient.services.LoadBalancerService;
import org.apache.flink.kubernetes.kubeclient.services.NodePortService;
import org.apache.flink.kubernetes.kubeclient.services.ServiceType;
import org.apache.flink.runtime.util.EnvironmentInformation;

@PublicEvolving
public class KubernetesConfigOptions {
    private static final String KUBERNETES_SERVICE_ACCOUNT_KEY = "kubernetes.service-account";
    private static final String KUBERNETES_POD_TEMPLATE_FILE_KEY = "kubernetes.pod-template-file";
    public static final ConfigOption<String> CONTEXT = ConfigOptions.key((String)"kubernetes.context").stringType().noDefaultValue().withDescription("The desired context from your Kubernetes config file used to configure the Kubernetes client for interacting with the cluster. This could be helpful if one has multiple contexts configured and wants to administrate different Flink clusters on different Kubernetes clusters/contexts.");
    public static final ConfigOption<ServiceExposedType> REST_SERVICE_EXPOSED_TYPE = ConfigOptions.key((String)"kubernetes.rest-service.exposed.type").enumType(ServiceExposedType.class).defaultValue((Object)ServiceExposedType.LoadBalancer).withDescription("The exposed type of the rest service. The exposed rest service could be used to access the Flink\u2019s Web UI and REST endpoint.");
    public static final ConfigOption<NodePortAddressType> REST_SERVICE_EXPOSED_NODE_PORT_ADDRESS_TYPE = ConfigOptions.key((String)"kubernetes.rest-service.exposed.node-port-address-type").enumType(NodePortAddressType.class).defaultValue((Object)NodePortAddressType.InternalIP).withDescription(Description.builder().text("The user-specified %s that is used for filtering node IPs when constructing a %s connection string. This option is only considered when '%s' is set to '%s'.", new InlineElement[]{LinkElement.link((String)"https://kubernetes.io/docs/concepts/architecture/nodes/#addresses", (String)"address type"), LinkElement.link((String)"https://kubernetes.io/docs/concepts/services-networking/service/#nodeport", (String)"node port"), TextElement.text((String)REST_SERVICE_EXPOSED_TYPE.key()), TextElement.text((String)ServiceExposedType.NodePort.name())}).build());
    public static final ConfigOption<String> JOB_MANAGER_SERVICE_ACCOUNT = ConfigOptions.key((String)"kubernetes.jobmanager.service-account").stringType().defaultValue((Object)"default").withFallbackKeys(new String[]{"kubernetes.service-account"}).withDescription("Service account that is used by jobmanager within kubernetes cluster. The job manager uses this service account when requesting taskmanager pods from the API server. If not explicitly configured, config option 'kubernetes.service-account' will be used.");
    public static final ConfigOption<String> TASK_MANAGER_SERVICE_ACCOUNT = ConfigOptions.key((String)"kubernetes.taskmanager.service-account").stringType().defaultValue((Object)"default").withFallbackKeys(new String[]{"kubernetes.service-account"}).withDescription("Service account that is used by taskmanager within kubernetes cluster. The task manager uses this service account when watching config maps on the API server to retrieve leader address of jobmanager and resourcemanager. If not explicitly configured, config option 'kubernetes.service-account' will be used.");
    public static final ConfigOption<String> KUBERNETES_SERVICE_ACCOUNT = ConfigOptions.key((String)"kubernetes.service-account").stringType().defaultValue((Object)"default").withDescription("Service account that is used by jobmanager and taskmanager within kubernetes cluster. Notice that this can be overwritten by config options '" + JOB_MANAGER_SERVICE_ACCOUNT.key() + "' and '" + TASK_MANAGER_SERVICE_ACCOUNT.key() + "' for jobmanager and taskmanager respectively.");
    public static final ConfigOption<List<Map<String, String>>> JOB_MANAGER_OWNER_REFERENCE = ConfigOptions.key((String)"kubernetes.jobmanager.owner.reference").mapType().asList().noDefaultValue().withDescription(Description.builder().text("The user-specified %s to be set to the JobManager Deployment. When all the owner resources are deleted, the JobManager Deployment will be deleted automatically, which also deletes all the resources created by this Flink cluster. The value should be formatted as a semicolon-separated list of owner references, where each owner reference is a comma-separated list of `key:value` pairs. E.g., apiVersion:v1,blockOwnerDeletion:true,controller:true,kind:FlinkApplication,name:flink-app-name,uid:flink-app-uid;apiVersion:v1,kind:Deployment,name:deploy-name,uid:deploy-uid", new InlineElement[]{LinkElement.link((String)"https://nightlies.apache.org/flink/flink-docs-master/deployment/resource-providers/native_kubernetes.html#manual-resource-cleanup", (String)"Owner References")}).build());
    public static final ConfigOption<Double> JOB_MANAGER_CPU = ConfigOptions.key((String)"kubernetes.jobmanager.cpu").doubleType().defaultValue((Object)1.0).withDescription("The number of cpu used by job manager");
    public static final ConfigOption<Double> TASK_MANAGER_CPU = ConfigOptions.key((String)"kubernetes.taskmanager.cpu").doubleType().defaultValue((Object)-1.0).withDescription("The number of cpu used by task manager. By default, the cpu is set to the number of slots per TaskManager");
    public static final ConfigOption<ImagePullPolicy> CONTAINER_IMAGE_PULL_POLICY = ConfigOptions.key((String)"kubernetes.container.image.pull-policy").enumType(ImagePullPolicy.class).defaultValue((Object)ImagePullPolicy.IfNotPresent).withDescription("The Kubernetes container image pull policy. The default policy is IfNotPresent to avoid putting pressure to image repository.");
    public static final ConfigOption<List<String>> CONTAINER_IMAGE_PULL_SECRETS = ConfigOptions.key((String)"kubernetes.container.image.pull-secrets").stringType().asList().noDefaultValue().withDescription("A semicolon-separated list of the Kubernetes secrets used to access private image registries.");
    public static final ConfigOption<String> KUBE_CONFIG_FILE = ConfigOptions.key((String)"kubernetes.config.file").stringType().noDefaultValue().withDescription("The kubernetes config file will be used to create the client. The default is located at ~/.kube/config");
    public static final ConfigOption<String> NAMESPACE = ConfigOptions.key((String)"kubernetes.namespace").stringType().defaultValue((Object)"default").withDescription("The namespace that will be used for running the jobmanager and taskmanager pods.");
    public static final ConfigOption<Map<String, String>> JOB_MANAGER_LABELS = ConfigOptions.key((String)"kubernetes.jobmanager.labels").mapType().noDefaultValue().withDescription("The labels to be set for JobManager pod. Specified as key:value pairs separated by commas. For example, version:alphav1,deploy:test.");
    public static final ConfigOption<Map<String, String>> TASK_MANAGER_LABELS = ConfigOptions.key((String)"kubernetes.taskmanager.labels").mapType().noDefaultValue().withDescription("The labels to be set for TaskManager pods. Specified as key:value pairs separated by commas. For example, version:alphav1,deploy:test.");
    public static final ConfigOption<Map<String, String>> JOB_MANAGER_NODE_SELECTOR = ConfigOptions.key((String)"kubernetes.jobmanager.node-selector").mapType().noDefaultValue().withDescription("The node selector to be set for JobManager pod. Specified as key:value pairs separated by commas. For example, environment:production,disk:ssd.");
    public static final ConfigOption<Map<String, String>> TASK_MANAGER_NODE_SELECTOR = ConfigOptions.key((String)"kubernetes.taskmanager.node-selector").mapType().noDefaultValue().withDescription("The node selector to be set for TaskManager pods. Specified as key:value pairs separated by commas. For example, environment:production,disk:ssd.");
    public static final ConfigOption<String> CLUSTER_ID = ConfigOptions.key((String)"kubernetes.cluster-id").stringType().noDefaultValue().withDescription(Description.builder().text("The cluster-id, which should be no more than 45 characters, is used for identifying a unique Flink cluster. The id must only contain lowercase alphanumeric characters and \"-\". The required format is %s. If not set, the client will automatically generate it with a random ID.", new InlineElement[]{TextElement.code((String)"[a-z]([-a-z0-9]*[a-z0-9])")}).build());
    @Documentation.OverrideDefault(value="The default value depends on the actually running version. In general it looks like \"flink:<FLINK_VERSION>-scala_<SCALA_VERSION>\"")
    public static final ConfigOption<String> CONTAINER_IMAGE = ConfigOptions.key((String)"kubernetes.container.image").stringType().defaultValue((Object)KubernetesConfigOptions.getDefaultFlinkImage()).withDescription(Description.builder().text("Image to use for Flink containers. The specified image must be based upon the same Apache Flink and Scala versions as used by the application. Visit %s for the official docker images provided by the Flink project. The Flink project also publishes docker images to %s.", new InlineElement[]{LinkElement.link((String)"https://hub.docker.com/_/flink?tab=tags", (String)"here"), LinkElement.link((String)"https://hub.docker.com/r/apache/flink/tags", (String)"apache/flink DockerHub repository")}).build());
    public static final ConfigOption<String> KUBERNETES_ENTRY_PATH = ConfigOptions.key((String)"kubernetes.entry.path").stringType().defaultValue((Object)"/docker-entrypoint.sh").withDescription("The entrypoint script of kubernetes in the image. It will be used as command for jobmanager and taskmanager container.");
    public static final ConfigOption<String> FLINK_CONF_DIR = ConfigOptions.key((String)"kubernetes.flink.conf.dir").stringType().defaultValue((Object)"/opt/flink/conf").withDescription("The flink conf directory that will be mounted in pod. The flink-conf.yaml, log4j.properties, logback.xml in this path will be overwritten from config map.");
    public static final ConfigOption<String> FLINK_LOG_DIR = ConfigOptions.key((String)"kubernetes.flink.log.dir").stringType().noDefaultValue().withDescription("The directory that logs of jobmanager and taskmanager be saved in the pod. The default value is $FLINK_HOME/log.");
    public static final ConfigOption<String> HADOOP_CONF_CONFIG_MAP = ConfigOptions.key((String)"kubernetes.hadoop.conf.config-map.name").stringType().noDefaultValue().withDescription("Specify the name of an existing ConfigMap that contains custom Hadoop configuration to be mounted on the JobManager(s) and TaskManagers.");
    public static final ConfigOption<Map<String, String>> JOB_MANAGER_ANNOTATIONS = ConfigOptions.key((String)"kubernetes.jobmanager.annotations").mapType().noDefaultValue().withDescription("The user-specified annotations that are set to the JobManager pod. The value could be in the form of a1:v1,a2:v2");
    public static final ConfigOption<Map<String, String>> TASK_MANAGER_ANNOTATIONS = ConfigOptions.key((String)"kubernetes.taskmanager.annotations").mapType().noDefaultValue().withDescription("The user-specified annotations that are set to the TaskManager pod. The value could be in the form of a1:v1,a2:v2");
    public static final ConfigOption<List<Map<String, String>>> JOB_MANAGER_TOLERATIONS = ConfigOptions.key((String)"kubernetes.jobmanager.tolerations").mapType().asList().noDefaultValue().withDescription("The user-specified tolerations to be set to the JobManager pod. The value should be in the form of key:key1,operator:Equal,value:value1,effect:NoSchedule;key:key2,operator:Exists,effect:NoExecute,tolerationSeconds:6000");
    public static final ConfigOption<List<Map<String, String>>> TASK_MANAGER_TOLERATIONS = ConfigOptions.key((String)"kubernetes.taskmanager.tolerations").mapType().asList().noDefaultValue().withDescription("The user-specified tolerations to be set to the TaskManager pod. The value should be in the form of key:key1,operator:Equal,value:value1,effect:NoSchedule;key:key2,operator:Exists,effect:NoExecute,tolerationSeconds:6000");
    public static final ConfigOption<Map<String, String>> REST_SERVICE_ANNOTATIONS = ConfigOptions.key((String)"kubernetes.rest-service.annotations").mapType().noDefaultValue().withDescription("The user-specified annotations that are set to the rest Service. The value should be in the form of a1:v1,a2:v2");
    public static final String EXTERNAL_RESOURCE_KUBERNETES_CONFIG_KEY_SUFFIX = "kubernetes.config-key";
    public static final ConfigOption<Map<String, String>> KUBERNETES_SECRETS = ConfigOptions.key((String)"kubernetes.secrets").mapType().noDefaultValue().withDescription(Description.builder().text("The user-specified secrets that will be mounted into Flink container. The value should be in the form of %s.", new InlineElement[]{TextElement.code((String)"foo:/opt/secrets-foo,bar:/opt/secrets-bar")}).build());
    public static final ConfigOption<List<Map<String, String>>> KUBERNETES_ENV_SECRET_KEY_REF = ConfigOptions.key((String)"kubernetes.env.secretKeyRef").mapType().asList().noDefaultValue().withDescription(Description.builder().text("The user-specified secrets to set env variables in Flink container. The value should be in the form of %s.", new InlineElement[]{TextElement.code((String)"env:FOO_ENV,secret:foo_secret,key:foo_key;env:BAR_ENV,secret:bar_secret,key:bar_key")}).build());
    public static final ConfigOption<String> EXTERNAL_RESOURCE_KUBERNETES_CONFIG_KEY = ConfigOptions.key((String)ExternalResourceOptions.genericKeyWithSuffix((String)"kubernetes.config-key")).stringType().noDefaultValue().withDescription("If configured, Flink will add \"resources.limits.<config-key>\" and \"resources.requests.<config-key>\" to the main container of TaskExecutor and set the value to the value of " + ExternalResourceOptions.EXTERNAL_RESOURCE_AMOUNT.key() + ".");
    public static final ConfigOption<Integer> KUBERNETES_TRANSACTIONAL_OPERATION_MAX_RETRIES = ConfigOptions.key((String)"kubernetes.transactional-operation.max-retries").intType().defaultValue((Object)5).withDescription(Description.builder().text("Defines the number of Kubernetes transactional operation retries before the client gives up. For example, %s.", new InlineElement[]{TextElement.code((String)"FlinkKubeClient#checkAndUpdateConfigMap")}).build());
    public static final ConfigOption<String> JOB_MANAGER_POD_TEMPLATE = ConfigOptions.key((String)"kubernetes.pod-template-file.jobmanager").stringType().noDefaultValue().withFallbackKeys(new String[]{"kubernetes.pod-template-file"}).withDescription("Specify a local file that contains the jobmanager pod template definition. It will be used to initialize the jobmanager pod. The main container should be defined with name 'flink-main-container'. If not explicitly configured, config option 'kubernetes.pod-template-file' will be used.");
    public static final ConfigOption<String> TASK_MANAGER_POD_TEMPLATE = ConfigOptions.key((String)"kubernetes.pod-template-file.taskmanager").stringType().noDefaultValue().withFallbackKeys(new String[]{"kubernetes.pod-template-file"}).withDescription("Specify a local file that contains the taskmanager pod template definition. It will be used to initialize the taskmanager pod. The main container should be defined with name 'flink-main-container'. If not explicitly configured, config option 'kubernetes.pod-template-file' will be used.");
    public static final ConfigOption<String> KUBERNETES_POD_TEMPLATE = ConfigOptions.key((String)"kubernetes.pod-template-file").stringType().noDefaultValue().withDescription("Specify a local file that contains the pod template definition. It will be used to initialize the jobmanager and taskmanager pod. The main container should be defined with name 'flink-main-container'. Notice that this can be overwritten by config options '" + JOB_MANAGER_POD_TEMPLATE.key() + "' and '" + TASK_MANAGER_POD_TEMPLATE.key() + "' for jobmanager and taskmanager respectively.");
    public static final ConfigOption<Integer> KUBERNETES_CLIENT_IO_EXECUTOR_POOL_SIZE = ConfigOptions.key((String)"kubernetes.client.io-pool.size").intType().defaultValue((Object)4).withDescription("The size of the IO executor pool used by the Kubernetes client to execute blocking IO operations (e.g. start/stop TaskManager pods, update leader related ConfigMaps, etc.). Increasing the pool size allows to run more IO operations concurrently.");
    public static final ConfigOption<Integer> KUBERNETES_JOBMANAGER_REPLICAS = ConfigOptions.key((String)"kubernetes.jobmanager.replicas").intType().defaultValue((Object)1).withDescription("Specify how many JobManager pods will be started simultaneously. Configure the value to greater than 1 to start standby JobManagers. It will help to achieve faster recovery. Notice that high availability should be enabled when starting standby JobManagers.");

    private static String getDefaultFlinkImage() {
        boolean snapshot = EnvironmentInformation.getVersion().toLowerCase(Locale.ENGLISH).contains("snapshot");
        String tag = snapshot ? "latest" : EnvironmentInformation.getVersion() + "-scala_" + EnvironmentInformation.getScalaVersion();
        return "apache/flink:" + tag;
    }

    private KubernetesConfigOptions() {
    }

    public static enum ImagePullPolicy {
        IfNotPresent,
        Always,
        Never;

    }

    public static enum NodePortAddressType {
        InternalIP,
        ExternalIP;

    }

    public static enum ServiceExposedType {
        ClusterIP(ClusterIPService.INSTANCE),
        NodePort(NodePortService.INSTANCE),
        LoadBalancer(LoadBalancerService.INSTANCE),
        Headless_ClusterIP(HeadlessClusterIPService.INSTANCE);

        private final ServiceType serviceType;

        private ServiceExposedType(ServiceType serviceType) {
            this.serviceType = serviceType;
        }

        public ServiceType serviceType() {
            return this.serviceType;
        }

        public boolean isClusterIP() {
            return this == ClusterIP || this == Headless_ClusterIP;
        }
    }
}

