/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.dubbo.common.utils.CollectionUtils;

public class ExceptionUtils {
    private static final int NOT_FOUND = -1;

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static String getStackFrameString(List<String> stackFrameList) {
        if (CollectionUtils.isEmpty(stackFrameList)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String s : stackFrameList) {
            stringBuilder.append(s).append("\n");
        }
        return stringBuilder.toString();
    }

    public static String[] getStackFrames(Throwable throwable) {
        if (throwable == null) {
            return new String[0];
        }
        return ExceptionUtils.getStackFrames(ExceptionUtils.getStackTrace(throwable));
    }

    static String[] getStackFrames(String stackTrace) {
        String linebreak = System.lineSeparator();
        StringTokenizer frames = new StringTokenizer(stackTrace, linebreak);
        ArrayList<String> list = new ArrayList<String>();
        while (frames.hasMoreTokens()) {
            list.add(frames.nextToken());
        }
        return list.toArray(new String[0]);
    }

    public static List<String> getStackFrameList(Throwable t, int maxDepth) {
        String stackTrace = ExceptionUtils.getStackTrace(t);
        String linebreak = System.lineSeparator();
        StringTokenizer frames = new StringTokenizer(stackTrace, linebreak);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < maxDepth && frames.hasMoreTokens(); ++i) {
            list.add(frames.nextToken());
        }
        return list;
    }

    public static List<String> getStackFrameList(Throwable t) {
        return ExceptionUtils.getStackFrameList(t, Integer.MAX_VALUE);
    }
}

