/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.dubbo.common.lang.Nullable;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.protocol.rest.util.MultiValueCreator;
import org.apache.dubbo.rpc.protocol.rest.util.NumberUtils;

public class DataParseUtils {
    public static Object stringTypeConvert(Class<?> targetType, String value) {
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            return Boolean.valueOf(value);
        }
        if (targetType == String.class) {
            return value;
        }
        if (Number.class.isAssignableFrom(targetType)) {
            return NumberUtils.parseNumber(value, targetType);
        }
        if (targetType != null && targetType.isPrimitive()) {
            return NumberUtils.parseNumber(value, targetType);
        }
        return value;
    }

    public static boolean isTextType(Class targetType) {
        if (targetType == null) {
            return false;
        }
        return targetType == Boolean.class || targetType == Boolean.TYPE || targetType == String.class || Number.class.isAssignableFrom(targetType) || targetType.isPrimitive();
    }

    public static void writeTextContent(Object object, OutputStream outputStream) throws IOException {
        outputStream.write(DataParseUtils.objectTextConvertToByteArray(object));
    }

    public static void writeJsonContent(Object object, OutputStream outputStream) throws Exception {
        outputStream.write(JsonUtils.toJson(object).getBytes(StandardCharsets.UTF_8));
    }

    public static void writeFormContent(Map formData, OutputStream outputStream) throws Exception {
        outputStream.write(DataParseUtils.serializeForm(formData, Charset.defaultCharset()).getBytes());
    }

    public static String serializeForm(Map formData, Charset charset) {
        StringBuilder builder = new StringBuilder();
        formData.forEach((name, values) -> {
            if (name == null) {
                return;
            }
            ((List)values).forEach(value -> {
                try {
                    if (builder.length() != 0) {
                        builder.append('&');
                    }
                    builder.append(URLEncoder.encode((String)name, charset.name()));
                    if (value != null) {
                        builder.append('=');
                        builder.append(URLEncoder.encode(String.valueOf(value), charset.name()));
                    }
                }
                catch (UnsupportedEncodingException ex) {
                    throw new IllegalStateException(ex);
                }
            });
        });
        return builder.toString();
    }

    public static byte[] objectTextConvertToByteArray(Object object) {
        Class<Number> objectClass = object.getClass();
        if (objectClass == Boolean.class || objectClass == Boolean.TYPE) {
            return object.toString().getBytes();
        }
        if (objectClass == String.class) {
            return ((String)object).getBytes();
        }
        if (objectClass.isAssignableFrom(Number.class) || objectClass.isPrimitive()) {
            return (byte[])NumberUtils.numberToBytes((Number)object);
        }
        return object.toString().getBytes();
    }

    public static Object jsonConvert(Type targetType, byte[] body) throws Exception {
        return JsonUtils.toJavaObject(new String(body, StandardCharsets.UTF_8), targetType);
    }

    public static Object multipartFormConvert(byte[] body, Charset charset, Class<?> targetType) throws Exception {
        String[] pairs = DataParseUtils.tokenizeToStringArray(new String(body, StandardCharsets.UTF_8), "&");
        Object result = MultiValueCreator.providerCreateMultiValueMap(targetType);
        for (String pair : pairs) {
            int idx = pair.indexOf(61);
            if (idx == -1) {
                MultiValueCreator.add(result, URLDecoder.decode(pair, charset.name()), null);
                continue;
            }
            String name = URLDecoder.decode(pair.substring(0, idx), charset.name());
            String value = URLDecoder.decode(pair.substring(idx + 1), charset.name());
            MultiValueCreator.add(result, name, value);
        }
        return result;
    }

    public static Object multipartFormConvert(byte[] body, Class<?> targetType) throws Exception {
        return DataParseUtils.multipartFormConvert(body, Charset.defaultCharset(), targetType);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters) {
        return DataParseUtils.tokenizeToStringArray(str, delimiters, true, true);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return DataParseUtils.toStringArray(tokens);
    }

    public static String[] toStringArray(Collection<String> collection) {
        return collection == null ? null : collection.toArray(new String[collection.size()]);
    }

    @Nullable
    public static String[] parseAcceptCharset(List<String> acceptCharsets) {
        if (CollectionUtils.isEmpty(acceptCharsets)) {
            return new String[0];
        }
        TreeMap encodings = new TreeMap(Comparator.reverseOrder());
        float defaultWeight = 1.0f;
        for (String acceptCharset : acceptCharsets) {
            String[] charsets;
            for (String charset : charsets = acceptCharset.split(",")) {
                charset = charset.trim();
                float weight = defaultWeight;
                String enc = charset;
                if (charset.contains(";q=")) {
                    String[] split = charset.split(";q=");
                    enc = split[0];
                    weight = Float.parseFloat(split[1]);
                }
                encodings.computeIfAbsent(Float.valueOf(weight), k -> new HashSet()).add(enc);
            }
        }
        ArrayList result = new ArrayList();
        encodings.values().forEach(result::addAll);
        return result.toArray(new String[0]);
    }
}

