/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.filter;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import java.util.List;
import java.util.Objects;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metadata.rest.PathMatcher;
import org.apache.dubbo.metadata.rest.RestMethodMetadata;
import org.apache.dubbo.metadata.rest.media.MediaType;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.rest.RestHeaderEnum;
import org.apache.dubbo.rpc.protocol.rest.RestRPCInvocationUtil;
import org.apache.dubbo.rpc.protocol.rest.deploy.ServiceDeployer;
import org.apache.dubbo.rpc.protocol.rest.exception.PathNoFoundException;
import org.apache.dubbo.rpc.protocol.rest.exception.UnSupportContentTypeException;
import org.apache.dubbo.rpc.protocol.rest.exception.mapper.ExceptionHandlerResult;
import org.apache.dubbo.rpc.protocol.rest.filter.RestRequestFilter;
import org.apache.dubbo.rpc.protocol.rest.filter.RestResponseInterceptor;
import org.apache.dubbo.rpc.protocol.rest.filter.context.RestFilterContext;
import org.apache.dubbo.rpc.protocol.rest.filter.context.RestInterceptContext;
import org.apache.dubbo.rpc.protocol.rest.message.HttpMessageCodecManager;
import org.apache.dubbo.rpc.protocol.rest.netty.NettyHttpResponse;
import org.apache.dubbo.rpc.protocol.rest.pair.InvokerAndRestMethodMetadataPair;
import org.apache.dubbo.rpc.protocol.rest.pair.MessageCodecResultPair;
import org.apache.dubbo.rpc.protocol.rest.request.NettyRequestFacade;
import org.apache.dubbo.rpc.protocol.rest.request.RequestFacade;
import org.apache.dubbo.rpc.protocol.rest.util.MediaTypeUtil;

@Activate(value={"invoke"}, order=0x7FFFFFFF)
public class ServiceInvokeRestFilter
implements RestRequestFilter {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
    private final List<RestResponseInterceptor> restResponseInterceptors;

    public ServiceInvokeRestFilter(FrameworkModel frameworkModel) {
        this.restResponseInterceptors = frameworkModel.getExtensionLoader(RestResponseInterceptor.class).getActivateExtensions();
    }

    @Override
    public void filter(RestFilterContext restFilterContext) throws Exception {
        NettyRequestFacade nettyRequestFacade = (NettyRequestFacade)restFilterContext.getRequestFacade();
        FullHttpRequest nettyHttpRequest = (FullHttpRequest)nettyRequestFacade.getRequest();
        this.doHandler((HttpRequest)nettyHttpRequest, restFilterContext.getResponse(), restFilterContext.getRequestFacade(), restFilterContext.getUrl(), restFilterContext.getOriginRequest(), restFilterContext.getServiceDeployer());
    }

    private void doHandler(HttpRequest nettyHttpRequest, NettyHttpResponse nettyHttpResponse, RequestFacade request, URL url, Object originRequest, ServiceDeployer serviceDeployer) throws Exception {
        PathMatcher pathMatcher = RestRPCInvocationUtil.createPathMatcher(request);
        if (!serviceDeployer.hashRestMethod(pathMatcher)) {
            throw new PathNoFoundException("rest service Path no found, current path info:" + pathMatcher);
        }
        if (!serviceDeployer.isMethodAllowed(pathMatcher)) {
            nettyHttpResponse.sendError(405, "service require request method is : " + serviceDeployer.pathHttpMethods(pathMatcher) + ", but current request method is: " + request.getMethod());
            return;
        }
        InvokerAndRestMethodMetadataPair restMethodMetadataPair = RestRPCInvocationUtil.getRestMethodMetadataAndInvokerPair(pathMatcher.compareHttpMethod(true), serviceDeployer);
        Invoker invoker = restMethodMetadataPair.getInvoker();
        RestMethodMetadata restMethodMetadata = restMethodMetadataPair.getRestMethodMetadata();
        this.acceptSupportJudge(request, restMethodMetadata.getReflectMethod().getReturnType());
        RpcInvocation rpcInvocation = RestRPCInvocationUtil.createBaseRpcInvocation(request, restMethodMetadata);
        RestRPCInvocationUtil.parseMethodArgs(rpcInvocation, request, nettyHttpRequest, nettyHttpResponse, restMethodMetadata);
        Result result = invoker.invoke(rpcInvocation);
        nettyHttpResponse.setResponseBody(result.getValue());
        if (result.hasException()) {
            Throwable exception = result.getException();
            this.logger.error("", exception.getMessage(), "", "dubbo rest protocol provider Invoker invoke error", exception);
            if (serviceDeployer.getExceptionMapper().hasExceptionMapper(exception)) {
                ExceptionHandlerResult exceptionToResult = serviceDeployer.getExceptionMapper().exceptionToResult(result.getException());
                ServiceInvokeRestFilter.writeResult(nettyHttpResponse, request, url, exceptionToResult.getEntity(), rpcInvocation.getReturnType());
                nettyHttpResponse.setStatus(exceptionToResult.getStatus());
            } else {
                nettyHttpResponse.sendError(500, "\n dubbo rest business exception, error cause is: " + result.getException().getCause() + "\n message is: " + result.getException().getMessage() + "\n stacktrace is: " + ServiceInvokeRestFilter.stackTraceToString(exception));
            }
        }
        try {
            RestInterceptContext restFilterContext = new RestInterceptContext(url, request, nettyHttpResponse, serviceDeployer, result.getValue(), rpcInvocation);
            restFilterContext.setOriginRequest(originRequest);
            this.executeResponseIntercepts(restFilterContext);
        }
        catch (Exception exception) {
            this.logger.error("", exception.getMessage(), "", "dubbo rest protocol execute ResponseIntercepts error", exception);
            throw exception;
        }
    }

    public static void writeResult(NettyHttpResponse nettyHttpResponse, RequestFacade<?> request, URL url, Object value, Class<?> returnType) throws Exception {
        MediaType mediaType = ServiceInvokeRestFilter.getAcceptMediaType(request, returnType);
        ServiceInvokeRestFilter.writeResult(nettyHttpResponse, url, value, returnType, mediaType);
    }

    public static void writeResult(NettyHttpResponse nettyHttpResponse, URL url, Object value, Class<?> returnType, MediaType mediaType) throws Exception {
        MessageCodecResultPair booleanMediaTypePair = HttpMessageCodecManager.httpMessageEncode(nettyHttpResponse.getOutputStream(), value, url, mediaType, returnType);
        nettyHttpResponse.setResponseBody(value);
        nettyHttpResponse.addOutputHeaders(RestHeaderEnum.CONTENT_TYPE.getHeader(), booleanMediaTypePair.getMediaType().value);
    }

    public static MediaType getAcceptMediaType(RequestFacade request, Class<?> returnType) {
        String accept = request.getHeader(RestHeaderEnum.ACCEPT.getHeader());
        accept = Objects.isNull(accept) ? MediaType.ALL_VALUE.value : accept;
        MediaType mediaType = MediaTypeUtil.convertMediaType(returnType, accept);
        return mediaType;
    }

    private void acceptSupportJudge(RequestFacade requestFacade, Class<?> returnType) {
        block3: {
            try {
                ServiceInvokeRestFilter.getAcceptMediaType(requestFacade, returnType);
            }
            catch (UnSupportContentTypeException e) {
                MediaType mediaType = HttpMessageCodecManager.typeSupport(returnType);
                String accept = requestFacade.getHeader(RestHeaderEnum.ACCEPT.getHeader());
                if (mediaType == null || accept == null) {
                    throw e;
                }
                if (accept.contains(mediaType.value)) break block3;
                throw e;
            }
        }
    }

    public static String stackTraceToString(Throwable throwable) {
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        StringBuilder stringBuilder = new StringBuilder("\n");
        for (StackTraceElement traceElement : stackTrace) {
            stringBuilder.append("\tat " + traceElement).append("\n");
        }
        return stringBuilder.toString();
    }

    public void executeResponseIntercepts(RestInterceptContext restFilterContext) throws Exception {
        for (RestResponseInterceptor restResponseInterceptor : this.restResponseInterceptors) {
            restResponseInterceptor.intercept(restFilterContext);
            if (!restFilterContext.complete()) continue;
            break;
        }
    }
}

