/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.common.config.Environment;
import org.apache.dubbo.common.extension.ExtensionAccessor;
import org.apache.dubbo.common.extension.ExtensionDirector;
import org.apache.dubbo.common.extension.ExtensionScope;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeClassLoaderListener;
import org.apache.dubbo.rpc.model.ScopeModelAwareExtensionProcessor;
import org.apache.dubbo.rpc.model.ScopeModelDestroyListener;

public abstract class ScopeModel
implements ExtensionAccessor {
    protected static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(ScopeModel.class);
    private String internalId;
    private String modelName;
    private String desc;
    private final Set<ClassLoader> classLoaders = new ConcurrentHashSet<ClassLoader>();
    private final ScopeModel parent;
    private final ExtensionScope scope;
    private volatile ExtensionDirector extensionDirector;
    private volatile ScopeBeanFactory beanFactory;
    private final List<ScopeModelDestroyListener> destroyListeners = new CopyOnWriteArrayList<ScopeModelDestroyListener>();
    private final List<ScopeClassLoaderListener> classLoaderListeners = new CopyOnWriteArrayList<ScopeClassLoaderListener>();
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private final boolean internalScope;
    protected final Object instLock = new Object();

    protected ScopeModel(ScopeModel parent, ExtensionScope scope, boolean isInternal) {
        this.parent = parent;
        this.scope = scope;
        this.internalScope = isInternal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        Object object = this.instLock;
        synchronized (object) {
            this.extensionDirector = new ExtensionDirector(this.parent != null ? this.parent.getExtensionDirector() : null, this.scope, this);
            this.extensionDirector.addExtensionPostProcessor(new ScopeModelAwareExtensionProcessor(this));
            this.beanFactory = new ScopeBeanFactory(this.parent != null ? this.parent.getBeanFactory() : null, this.extensionDirector);
            ClassLoader dubboClassLoader = ScopeModel.class.getClassLoader();
            if (dubboClassLoader != null) {
                this.addClassLoader(dubboClassLoader);
            }
        }
    }

    protected abstract Lock acquireDestroyLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        block8: {
            Lock lock = this.acquireDestroyLock();
            try {
                lock.lock();
                if (!this.destroyed.compareAndSet(false, true)) break block8;
                try {
                    this.onDestroy();
                    HashSet<ClassLoader> copyOfClassLoaders = new HashSet<ClassLoader>(this.classLoaders);
                    for (ClassLoader classLoader : copyOfClassLoaders) {
                        this.removeClassLoader(classLoader);
                    }
                    if (this.beanFactory != null) {
                        this.beanFactory.destroy();
                    }
                    if (this.extensionDirector != null) {
                        this.extensionDirector.destroy();
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("5-13", "", "", "Error happened when destroying ScopeModel.", t);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    public boolean isDestroyed() {
        return this.destroyed.get();
    }

    protected void notifyDestroy() {
        for (ScopeModelDestroyListener destroyListener : this.destroyListeners) {
            destroyListener.onDestroy(this);
        }
    }

    protected void notifyProtocolDestroy() {
        for (ScopeModelDestroyListener destroyListener : this.destroyListeners) {
            if (!destroyListener.isProtocol()) continue;
            destroyListener.onDestroy(this);
        }
    }

    protected void notifyClassLoaderAdd(ClassLoader classLoader) {
        for (ScopeClassLoaderListener classLoaderListener : this.classLoaderListeners) {
            classLoaderListener.onAddClassLoader(this, classLoader);
        }
    }

    protected void notifyClassLoaderDestroy(ClassLoader classLoader) {
        for (ScopeClassLoaderListener classLoaderListener : this.classLoaderListeners) {
            classLoaderListener.onRemoveClassLoader(this, classLoader);
        }
    }

    protected abstract void onDestroy();

    public final void addDestroyListener(ScopeModelDestroyListener listener) {
        this.destroyListeners.add(listener);
    }

    public final void addClassLoaderListener(ScopeClassLoaderListener listener) {
        this.classLoaderListeners.add(listener);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public <T> T getAttribute(String key, Class<T> type) {
        return (T)this.attributes.get(key);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public ExtensionDirector getExtensionDirector() {
        return this.extensionDirector;
    }

    public ScopeBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public ScopeModel getParent() {
        return this.parent;
    }

    public ExtensionScope getScope() {
        return this.scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassLoader(ClassLoader classLoader) {
        Object object = this.instLock;
        synchronized (object) {
            this.classLoaders.add(classLoader);
            if (this.parent != null) {
                this.parent.addClassLoader(classLoader);
            }
            this.extensionDirector.removeAllCachedLoader();
            this.notifyClassLoaderAdd(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClassLoader(ClassLoader classLoader) {
        Object object = this.instLock;
        synchronized (object) {
            if (this.checkIfClassLoaderCanRemoved(classLoader)) {
                this.classLoaders.remove(classLoader);
                if (this.parent != null) {
                    this.parent.removeClassLoader(classLoader);
                }
                this.extensionDirector.removeAllCachedLoader();
                this.notifyClassLoaderDestroy(classLoader);
            }
        }
    }

    protected boolean checkIfClassLoaderCanRemoved(ClassLoader classLoader) {
        return classLoader != null && !classLoader.equals(ScopeModel.class.getClassLoader());
    }

    public Set<ClassLoader> getClassLoaders() {
        return Collections.unmodifiableSet(this.classLoaders);
    }

    public abstract Environment modelEnvironment();

    @Deprecated
    public final Environment getModelEnvironment() {
        try {
            return this.modelEnvironment();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getInternalId() {
        return this.internalId;
    }

    void setInternalId(String internalId) {
        this.internalId = internalId;
    }

    protected String buildInternalId(String parentInternalId, long childIndex) {
        if (StringUtils.hasText(parentInternalId)) {
            return parentInternalId + "." + childIndex;
        }
        return "" + childIndex;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
        this.desc = this.buildDesc();
    }

    public boolean isInternal() {
        return this.internalScope;
    }

    public String getDesc() {
        if (this.desc == null) {
            this.desc = this.buildDesc();
        }
        return this.desc;
    }

    private String buildDesc() {
        String type = this.getClass().getSimpleName().replace("Model", "");
        String desc = "Dubbo " + type + "[" + this.getInternalId() + "]";
        String modelNamePath = this.getModelNamePath();
        if (StringUtils.hasText(modelNamePath)) {
            desc = desc + "(" + modelNamePath + ")";
        }
        return desc;
    }

    private String getModelNamePath() {
        String modelName;
        if (this instanceof ApplicationModel) {
            return ScopeModel.safeGetAppName((ApplicationModel)this);
        }
        if (this instanceof ModuleModel && StringUtils.hasText(modelName = this.getModelName())) {
            return ScopeModel.safeGetAppName(((ModuleModel)this).getApplicationModel()) + "/" + modelName;
        }
        return null;
    }

    private static String safeGetAppName(ApplicationModel applicationModel) {
        String modelName = applicationModel.getModelName();
        if (StringUtils.isBlank(modelName)) {
            modelName = "unknown";
        }
        return modelName;
    }

    public String toString() {
        return this.getDesc();
    }
}

