/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.report;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.metrics.report.AbstractMetricsReporter;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class DefaultMetricsReporter
extends AbstractMetricsReporter {
    SimpleMeterRegistry meterRegistry = new SimpleMeterRegistry();

    protected DefaultMetricsReporter(URL url, ApplicationModel applicationModel) {
        super(url, applicationModel);
    }

    @Override
    public String getResponse() {
        return null;
    }

    @Override
    public String getResponseWithName(String metricsName) {
        HashMap metricsTags = new HashMap();
        HashMap<String, Object> metricsValue = new HashMap<String, Object>();
        StringBuilder sb = new StringBuilder();
        this.meterRegistry.getMeters().stream().filter(meter -> {
            if (meter == null || meter.getId() == null || meter.getId().getName() == null) {
                return false;
            }
            if (metricsName != null) {
                return meter.getId().getName().contains(metricsName);
            }
            return true;
        }).forEach(meter -> {
            Double value = null;
            if (meter instanceof Counter) {
                Counter counter = (Counter)meter;
                value = counter.count();
            }
            if (meter instanceof Gauge) {
                Gauge gauge = (Gauge)meter;
                value = gauge.value();
            }
            if (meter instanceof Timer) {
                Timer timer = (Timer)meter;
                value = timer.totalTime(TimeUnit.MILLISECONDS);
            }
            metricsTags.put(meter.getId().getName(), meter.getId().getTags());
            metricsValue.put(meter.getId().getName(), value);
        });
        metricsValue.forEach((key, value) -> {
            sb.append((String)key).append("{");
            List tags = (List)metricsTags.get(key);
            if (tags != null && tags.size() > 0) {
                tags.forEach(tag -> sb.append(tag.getKey()).append("=").append(tag.getValue()).append(","));
            }
            sb.append("} ").append(value).append(System.lineSeparator());
        });
        return sb.toString();
    }

    @Override
    protected void doInit() {
        this.addMeterRegistry((MeterRegistry)this.meterRegistry);
    }

    @Override
    protected void doDestroy() {
    }
}

