/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.rest;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.dubbo.common.utils.PathUtils;
import org.apache.dubbo.metadata.ParameterTypesComparator;
import org.apache.dubbo.metadata.rest.PathMatcher;
import org.apache.dubbo.metadata.rest.RestMethodMetadata;

public class ServiceRestMetadata
implements Serializable {
    private static final long serialVersionUID = -4549723140727443569L;
    private String serviceInterface;
    private String version;
    private String group;
    private Set<RestMethodMetadata> meta;
    private Integer port;
    private boolean consumer;
    private String contextPathFromUrl;
    private Class codeStyle;
    private Map<PathMatcher, RestMethodMetadata> pathToServiceMapContainPathVariable = new HashMap<PathMatcher, RestMethodMetadata>();
    private Map<PathMatcher, RestMethodMetadata> pathToServiceMapUnContainPathVariable = new HashMap<PathMatcher, RestMethodMetadata>();
    private Map<String, Map<ParameterTypesComparator, RestMethodMetadata>> methodToServiceMap = new HashMap<String, Map<ParameterTypesComparator, RestMethodMetadata>>();

    public ServiceRestMetadata(String serviceInterface, String version, String group, boolean consumer) {
        this.serviceInterface = serviceInterface;
        this.version = version;
        this.group = group;
        this.consumer = consumer;
    }

    public ServiceRestMetadata() {
    }

    public ServiceRestMetadata(String serviceInterface, String version, String group) {
        this(serviceInterface, version, group, false);
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(String serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Set<RestMethodMetadata> getMeta() {
        if (this.meta == null) {
            this.meta = new LinkedHashSet<RestMethodMetadata>();
        }
        return this.meta;
    }

    public void setMeta(Set<RestMethodMetadata> meta) {
        this.meta = meta;
    }

    public void addRestMethodMetadata(RestMethodMetadata restMethodMetadata) {
        PathMatcher pathMather = new PathMatcher(restMethodMetadata.getRequest().getPath(), this.getVersion(), this.getGroup(), this.getPort(), restMethodMetadata.getRequest().getMethod());
        pathMather.setMethod(restMethodMetadata.getReflectMethod());
        this.addPathToServiceMap(pathMather, restMethodMetadata);
        this.addMethodToServiceMap(restMethodMetadata);
        this.getMeta().add(restMethodMetadata);
    }

    public Map<PathMatcher, RestMethodMetadata> getPathContainPathVariableToServiceMap() {
        return this.pathToServiceMapContainPathVariable;
    }

    public Map<PathMatcher, RestMethodMetadata> getPathUnContainPathVariableToServiceMap() {
        return this.pathToServiceMapUnContainPathVariable;
    }

    public void addPathToServiceMap(PathMatcher pathMather, RestMethodMetadata restMethodMetadata) {
        if (pathMather.hasPathVariable()) {
            this.doublePathCheck(this.pathToServiceMapContainPathVariable, pathMather, restMethodMetadata, true);
        } else {
            this.doublePathCheck(this.pathToServiceMapUnContainPathVariable, pathMather, restMethodMetadata, false);
        }
    }

    private void doublePathCheck(Map<PathMatcher, RestMethodMetadata> pathMatcherRestMethodMetadataMap, PathMatcher pathMather, RestMethodMetadata restMethodMetadata, boolean containPathVariable) {
        if (pathMatcherRestMethodMetadataMap.containsKey(pathMather)) {
            if (containPathVariable) {
                throw new IllegalArgumentException("dubbo rest metadata resolve double path error,and contain path variable  is:  " + pathMather + ", rest method metadata is: " + restMethodMetadata);
            }
            throw new IllegalArgumentException("dubbo rest metadata resolve double path error,and do not  contain path variable  is: " + pathMather + ", rest method metadata is: " + restMethodMetadata);
        }
        pathMatcherRestMethodMetadataMap.put(pathMather, restMethodMetadata);
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
        this.setPort(port, this.getPathContainPathVariableToServiceMap());
        this.setPort(port, this.getPathUnContainPathVariableToServiceMap());
    }

    private void setPort(Integer port, Map<PathMatcher, RestMethodMetadata> pathToServiceMapContainPathVariable) {
        for (PathMatcher pathMather : pathToServiceMapContainPathVariable.keySet()) {
            pathMather.setPort(port);
        }
    }

    public boolean isConsumer() {
        return this.consumer;
    }

    public void setConsumer(boolean consumer) {
        this.consumer = consumer;
    }

    public Map<String, Map<ParameterTypesComparator, RestMethodMetadata>> getMethodToServiceMap() {
        return this.methodToServiceMap;
    }

    public void addMethodToServiceMap(RestMethodMetadata restMethodMetadata) {
        if (this.methodToServiceMap == null) {
            this.methodToServiceMap = new HashMap<String, Map<ParameterTypesComparator, RestMethodMetadata>>();
        }
        this.methodToServiceMap.computeIfAbsent(restMethodMetadata.getReflectMethod().getName(), k -> new HashMap()).put(ParameterTypesComparator.getInstance(restMethodMetadata.getReflectMethod().getParameterTypes()), restMethodMetadata);
    }

    public Class getCodeStyle() {
        return this.codeStyle;
    }

    public void setCodeStyle(Class codeStyle) {
        this.codeStyle = codeStyle;
    }

    public String getContextPathFromUrl() {
        return this.contextPathFromUrl == null ? "" : this.contextPathFromUrl;
    }

    public void setContextPathFromUrl(String contextPathFromUrl) {
        this.contextPathFromUrl = PathUtils.normalize(contextPathFromUrl);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceRestMetadata)) {
            return false;
        }
        ServiceRestMetadata that = (ServiceRestMetadata)o;
        return Objects.equals(this.getServiceInterface(), that.getServiceInterface()) && Objects.equals(this.getVersion(), that.getVersion()) && Objects.equals(this.getGroup(), that.getGroup()) && Objects.equals(this.getMeta(), that.getMeta()) && Objects.equals(this.getPort(), that.getPort());
    }

    public int hashCode() {
        return Objects.hash(this.getServiceInterface(), this.getVersion(), this.getGroup(), this.getMeta(), this.getPort());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ServiceRestMetadata{");
        sb.append("serviceInterface='").append(this.serviceInterface).append('\'');
        sb.append(", version='").append(this.version).append('\'');
        sb.append(", group='").append(this.group).append('\'');
        sb.append(", meta=").append(this.meta);
        sb.append(", port=").append(this.port);
        sb.append('}');
        return sb.toString();
    }
}

