/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.url.component;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.url.component.PathURLAddress;
import org.apache.dubbo.common.url.component.URLAddress;
import org.apache.dubbo.common.url.component.URLParam;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.common.utils.StringUtils;

public class ServiceConfigURL
extends URL {
    private volatile transient ConcurrentMap<String, URL> urls;
    private volatile transient ConcurrentMap<String, Number> numbers;
    private volatile transient ConcurrentMap<String, Map<String, Number>> methodNumbers;
    private volatile transient String full;
    private volatile transient String string;
    private volatile transient String identity;
    private volatile transient String parameter;

    public ServiceConfigURL() {
    }

    public ServiceConfigURL(URLAddress urlAddress, URLParam urlParam, Map<String, Object> attributes) {
        super(urlAddress, urlParam, attributes);
    }

    public ServiceConfigURL(String protocol, String host, int port) {
        this(protocol, null, null, host, port, null, (Map<String, String>)null);
    }

    public ServiceConfigURL(String protocol, String host, int port, String[] pairs) {
        this(protocol, null, null, host, port, null, CollectionUtils.toStringMap(pairs));
    }

    public ServiceConfigURL(String protocol, String host, int port, Map<String, String> parameters) {
        this(protocol, null, null, host, port, null, parameters);
    }

    public ServiceConfigURL(String protocol, String host, int port, String path) {
        this(protocol, null, null, host, port, path, (Map<String, String>)null);
    }

    public ServiceConfigURL(String protocol, String host, int port, String path, String ... pairs) {
        this(protocol, null, null, host, port, path, CollectionUtils.toStringMap(pairs));
    }

    public ServiceConfigURL(String protocol, String host, int port, String path, Map<String, String> parameters) {
        this(protocol, null, null, host, port, path, parameters);
    }

    public ServiceConfigURL(String protocol, String username, String password, String host, int port, String path) {
        this(protocol, username, password, host, port, path, (Map<String, String>)null);
    }

    public ServiceConfigURL(String protocol, String username, String password, String host, int port, String path, String ... pairs) {
        this(protocol, username, password, host, port, path, CollectionUtils.toStringMap(pairs));
    }

    public ServiceConfigURL(String protocol, String username, String password, String host, int port, String path, Map<String, String> parameters) {
        this(new PathURLAddress(protocol, username, password, path, host, port), URLParam.parse(parameters), null);
    }

    public ServiceConfigURL(String protocol, String username, String password, String host, int port, String path, Map<String, String> parameters, Map<String, Object> attributes) {
        this(new PathURLAddress(protocol, username, password, path, host, port), URLParam.parse(parameters), attributes);
    }

    @Override
    protected <T extends URL> T newURL(URLAddress urlAddress, URLParam urlParam) {
        return (T)new ServiceConfigURL(urlAddress, urlParam, this.attributes);
    }

    @Override
    public URL addAttributes(Map<String, Object> attributeMap) {
        HashMap<String, Object> newAttributes = new HashMap<String, Object>();
        if (this.attributes != null) {
            newAttributes.putAll(this.attributes);
        }
        newAttributes.putAll(attributeMap);
        return new ServiceConfigURL(this.getUrlAddress(), this.getUrlParam(), newAttributes);
    }

    @Override
    public ServiceConfigURL putAttribute(String key, Object obj) {
        HashMap<String, Object> newAttributes = new HashMap<String, Object>();
        if (this.attributes != null) {
            newAttributes.putAll(this.attributes);
        }
        newAttributes.put(key, obj);
        return new ServiceConfigURL(this.getUrlAddress(), this.getUrlParam(), newAttributes);
    }

    @Override
    public URL removeAttribute(String key) {
        HashMap<String, Object> newAttributes = new HashMap<String, Object>();
        if (this.attributes != null) {
            newAttributes.putAll(this.attributes);
        }
        newAttributes.remove(key);
        return new ServiceConfigURL(this.getUrlAddress(), this.getUrlParam(), newAttributes);
    }

    @Override
    public String toString() {
        if (this.string != null) {
            return this.string;
        }
        this.string = super.toString();
        return this.string;
    }

    @Override
    public String toFullString() {
        if (this.full != null) {
            return this.full;
        }
        this.full = super.toFullString();
        return this.full;
    }

    @Override
    public String toIdentityString() {
        if (this.identity != null) {
            return this.identity;
        }
        this.identity = super.toIdentityString();
        return this.identity;
    }

    @Override
    public String toParameterString() {
        if (this.parameter != null) {
            return this.parameter;
        }
        this.parameter = super.toParameterString();
        return this.parameter;
    }

    @Override
    public URL getUrlParameter(String key) {
        URL u = this.getUrls().get(key);
        if (u != null) {
            return u;
        }
        String value = this.getParameterAndDecoded(key);
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        u = URL.valueOf(value);
        this.getUrls().put(key, u);
        return u;
    }

    @Override
    public double getParameter(String key, double defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.doubleValue();
        }
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        double d = Double.parseDouble(value);
        this.getNumbers().put(key, d);
        return d;
    }

    @Override
    public float getParameter(String key, float defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.floatValue();
        }
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        float f = Float.parseFloat(value);
        this.getNumbers().put(key, Float.valueOf(f));
        return f;
    }

    @Override
    public long getParameter(String key, long defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.longValue();
        }
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        long l = Long.parseLong(value);
        this.getNumbers().put(key, l);
        return l;
    }

    @Override
    public int getParameter(String key, int defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.intValue();
        }
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        int i = Integer.parseInt(value);
        this.getNumbers().put(key, i);
        return i;
    }

    @Override
    public short getParameter(String key, short defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.shortValue();
        }
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        short s = Short.parseShort(value);
        this.getNumbers().put(key, s);
        return s;
    }

    @Override
    public byte getParameter(String key, byte defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.byteValue();
        }
        String value = this.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        byte b = Byte.parseByte(value);
        this.getNumbers().put(key, b);
        return b;
    }

    @Override
    public double getMethodParameter(String method, String key, double defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.doubleValue();
        }
        String value = this.getMethodParameter(method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        double d = Double.parseDouble(value);
        this.updateCachedNumber(method, key, d);
        return d;
    }

    @Override
    public float getMethodParameter(String method, String key, float defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.floatValue();
        }
        String value = this.getMethodParameter(method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        float f = Float.parseFloat(value);
        this.updateCachedNumber(method, key, Float.valueOf(f));
        return f;
    }

    @Override
    public long getMethodParameter(String method, String key, long defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.longValue();
        }
        String value = this.getMethodParameter(method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        long l = Long.parseLong(value);
        this.updateCachedNumber(method, key, l);
        return l;
    }

    @Override
    public int getMethodParameter(String method, String key, int defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.intValue();
        }
        String value = this.getMethodParameter(method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        int i = Integer.parseInt(value);
        this.updateCachedNumber(method, key, i);
        return i;
    }

    @Override
    public short getMethodParameter(String method, String key, short defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.shortValue();
        }
        String value = this.getMethodParameter(method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        short s = Short.parseShort(value);
        this.updateCachedNumber(method, key, s);
        return s;
    }

    @Override
    public byte getMethodParameter(String method, String key, byte defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.byteValue();
        }
        String value = this.getMethodParameter(method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        byte b = Byte.parseByte(value);
        this.updateCachedNumber(method, key, b);
        return b;
    }

    @Override
    public double getServiceParameter(String service, String key, double defaultValue) {
        Number n = this.getServiceNumbers(service).get(key);
        if (n != null) {
            return n.doubleValue();
        }
        String value = this.getServiceParameter(service, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        double d = Double.parseDouble(value);
        this.getNumbers().put(key, d);
        return d;
    }

    @Override
    public float getServiceParameter(String service, String key, float defaultValue) {
        Number n = this.getServiceNumbers(service).get(key);
        if (n != null) {
            return n.floatValue();
        }
        String value = this.getServiceParameter(service, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        float f = Float.parseFloat(value);
        this.getNumbers().put(key, Float.valueOf(f));
        return f;
    }

    @Override
    public long getServiceParameter(String service, String key, long defaultValue) {
        Number n = this.getServiceNumbers(service).get(key);
        if (n != null) {
            return n.longValue();
        }
        String value = this.getServiceParameter(service, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        long l = Long.parseLong(value);
        this.getNumbers().put(key, l);
        return l;
    }

    @Override
    public short getServiceParameter(String service, String key, short defaultValue) {
        Number n = this.getServiceNumbers(service).get(key);
        if (n != null) {
            return n.shortValue();
        }
        String value = this.getServiceParameter(service, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        short s = Short.parseShort(value);
        this.getNumbers().put(key, s);
        return s;
    }

    @Override
    public byte getServiceParameter(String service, String key, byte defaultValue) {
        Number n = this.getServiceNumbers(service).get(key);
        if (n != null) {
            return n.byteValue();
        }
        String value = this.getServiceParameter(service, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        byte b = Byte.parseByte(value);
        this.getNumbers().put(key, b);
        return b;
    }

    @Override
    public double getServiceMethodParameter(String service, String method, String key, double defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.doubleValue();
        }
        String value = this.getServiceMethodParameter(service, method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        double d = Double.parseDouble(value);
        this.updateCachedNumber(method, key, d);
        return d;
    }

    @Override
    public float getServiceMethodParameter(String service, String method, String key, float defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.floatValue();
        }
        String value = this.getServiceMethodParameter(service, method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        float f = Float.parseFloat(value);
        this.updateCachedNumber(method, key, Float.valueOf(f));
        return f;
    }

    @Override
    public long getServiceMethodParameter(String service, String method, String key, long defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.longValue();
        }
        String value = this.getServiceMethodParameter(service, method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        long l = Long.parseLong(value);
        this.updateCachedNumber(method, key, l);
        return l;
    }

    @Override
    public int getServiceMethodParameter(String service, String method, String key, int defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.intValue();
        }
        String value = this.getServiceMethodParameter(service, method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        int i = Integer.parseInt(value);
        this.updateCachedNumber(method, key, i);
        return i;
    }

    @Override
    public short getServiceMethodParameter(String service, String method, String key, short defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.shortValue();
        }
        String value = this.getServiceMethodParameter(service, method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        short s = Short.parseShort(value);
        this.updateCachedNumber(method, key, s);
        return s;
    }

    @Override
    public byte getServiceMethodParameter(String service, String method, String key, byte defaultValue) {
        Number n = this.getCachedNumber(method, key);
        if (n != null) {
            return n.byteValue();
        }
        String value = this.getServiceMethodParameter(service, method, key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        byte b = Byte.parseByte(value);
        this.updateCachedNumber(method, key, b);
        return b;
    }

    private Map<String, URL> getUrls() {
        if (this.urls == null) {
            this.urls = new ConcurrentHashMap<String, URL>();
        }
        return this.urls;
    }

    protected Map<String, Number> getNumbers() {
        if (this.numbers == null) {
            this.numbers = new ConcurrentHashMap<String, Number>();
        }
        return this.numbers;
    }

    private Number getCachedNumber(String method, String key) {
        Map keyNumber = (Map)this.getMethodNumbers().get(method);
        if (keyNumber != null) {
            return (Number)keyNumber.get(key);
        }
        return null;
    }

    private void updateCachedNumber(String method, String key, Number n) {
        Map keyNumber = ConcurrentHashMapUtils.computeIfAbsent(this.getMethodNumbers(), method, m -> new HashMap());
        keyNumber.put(key, n);
    }

    protected ConcurrentMap<String, Map<String, Number>> getMethodNumbers() {
        if (this.methodNumbers == null) {
            this.methodNumbers = new ConcurrentHashMap<String, Map<String, Number>>();
        }
        return this.methodNumbers;
    }

    protected Map<String, Number> getServiceNumbers(String service) {
        return this.getNumbers();
    }

    protected Map<String, Map<String, Number>> getServiceMethodNumbers(String service) {
        return this.getMethodNumbers();
    }
}

