/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.protocol.util;

import com.qq.tars.common.util.HexUtil;
import com.qq.tars.protocol.tars.TarsStructBase;
import com.qq.tars.protocol.tars.exc.TarsEncodeException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class TarsDisplayer {
    private StringBuilder sb;
    private int _level = 0;

    private void ps(String fieldName) {
        for (int i = 0; i < this._level; ++i) {
            this.sb.append('\t');
        }
        if (fieldName != null) {
            this.sb.append(fieldName).append(": ");
        }
    }

    public TarsDisplayer(StringBuilder sb, int level) {
        this.sb = sb;
        this._level = level;
    }

    public TarsDisplayer(StringBuilder sb) {
        this.sb = sb;
    }

    public TarsDisplayer display(boolean b, String fieldName) {
        this.ps(fieldName);
        this.sb.append(b ? (char)'T' : 'F').append('\n');
        return this;
    }

    public TarsDisplayer displaySimple(boolean b, boolean bSep) {
        this.sb.append(b ? (char)'T' : 'F');
        if (bSep) {
            this.sb.append("|");
        }
        return this;
    }

    public TarsDisplayer display(byte n, String fieldName) {
        this.ps(fieldName);
        this.sb.append(n).append('\n');
        return this;
    }

    public TarsDisplayer displaySimple(byte n, boolean bSep) {
        this.sb.append(n);
        if (bSep) {
            this.sb.append("|");
        }
        return this;
    }

    public TarsDisplayer display(char n, String fieldName) {
        this.ps(fieldName);
        this.sb.append(n).append('\n');
        return this;
    }

    public TarsDisplayer displaySimple(char n, boolean bSep) {
        this.sb.append(n);
        if (bSep) {
            this.sb.append("|");
        }
        return this;
    }

    public TarsDisplayer display(short n, String fieldName) {
        this.ps(fieldName);
        this.sb.append(n).append('\n');
        return this;
    }

    public TarsDisplayer displaySimple(short n, boolean bSep) {
        this.sb.append(n);
        if (bSep) {
            this.sb.append("|");
        }
        return this;
    }

    public TarsDisplayer display(int n, String fieldName) {
        this.ps(fieldName);
        this.sb.append(n).append('\n');
        return this;
    }

    public TarsDisplayer displaySimple(int n, boolean bSep) {
        this.sb.append(n);
        if (bSep) {
            this.sb.append("|");
        }
        return this;
    }

    public TarsDisplayer display(long n, String fieldName) {
        this.ps(fieldName);
        this.sb.append(n).append('\n');
        return this;
    }

    public TarsDisplayer displaySimple(long n, boolean bSep) {
        this.sb.append(n);
        if (bSep) {
            this.sb.append("|");
        }
        return this;
    }

    public TarsDisplayer display(float n, String fieldName) {
        this.ps(fieldName);
        this.sb.append(n).append('\n');
        return this;
    }

    public TarsDisplayer displaySimple(float n, boolean bSep) {
        this.sb.append(n);
        if (bSep) {
            this.sb.append("|");
        }
        return this;
    }

    public TarsDisplayer display(double n, String fieldName) {
        this.ps(fieldName);
        this.sb.append(n).append('\n');
        return this;
    }

    public TarsDisplayer displaySimple(double n, boolean bSep) {
        this.sb.append(n);
        if (bSep) {
            this.sb.append("|");
        }
        return this;
    }

    public TarsDisplayer display(String s, String fieldName) {
        this.ps(fieldName);
        if (null == s) {
            this.sb.append("null").append('\n');
        } else {
            this.sb.append(s).append('\n');
        }
        return this;
    }

    public TarsDisplayer displaySimple(String s, boolean bSep) {
        if (null == s) {
            this.sb.append("null");
        } else {
            this.sb.append(s);
        }
        if (bSep) {
            this.sb.append("|");
        }
        return this;
    }

    public TarsDisplayer display(byte[] v, String fieldName) {
        this.ps(fieldName);
        if (null == v) {
            this.sb.append("null").append('\n');
            return this;
        }
        if (v.length == 0) {
            this.sb.append(v.length).append(", []").append('\n');
            return this;
        }
        this.sb.append(v.length).append(", [").append('\n');
        TarsDisplayer jd = new TarsDisplayer(this.sb, this._level + 1);
        for (byte o : v) {
            jd.display(o, (String)null);
        }
        this.display(']', (String)null);
        return this;
    }

    public TarsDisplayer displaySimple(byte[] v, boolean bSep) {
        if (null == v || v.length == 0) {
            if (bSep) {
                this.sb.append("|");
            }
            return this;
        }
        this.sb.append(HexUtil.bytes2HexStr(v));
        if (bSep) {
            this.sb.append("|");
        }
        return this;
    }

    public TarsDisplayer display(char[] v, String fieldName) {
        this.ps(fieldName);
        if (null == v) {
            this.sb.append("null").append('\n');
            return this;
        }
        if (v.length == 0) {
            this.sb.append(v.length).append(", []").append('\n');
            return this;
        }
        this.sb.append(v.length).append(", [").append('\n');
        TarsDisplayer jd = new TarsDisplayer(this.sb, this._level + 1);
        for (char o : v) {
            jd.display(o, (String)null);
        }
        this.display(']', (String)null);
        return this;
    }

    public TarsDisplayer displaySimple(char[] v, boolean bSep) {
        if (null == v || v.length == 0) {
            if (bSep) {
                this.sb.append("|");
            }
            return this;
        }
        this.sb.append(new String(v));
        if (bSep) {
            this.sb.append("|");
        }
        return this;
    }

    public TarsDisplayer display(short[] v, String fieldName) {
        this.ps(fieldName);
        if (null == v) {
            this.sb.append("null").append('\n');
            return this;
        }
        if (v.length == 0) {
            this.sb.append(v.length).append(", []").append('\n');
            return this;
        }
        this.sb.append(v.length).append(", [").append('\n');
        TarsDisplayer jd = new TarsDisplayer(this.sb, this._level + 1);
        for (short o : v) {
            jd.display(o, (String)null);
        }
        this.display(']', (String)null);
        return this;
    }

    public TarsDisplayer displaySimple(short[] v, boolean bSep) {
        if (null == v || v.length == 0) {
            this.sb.append("[]");
            if (bSep) {
                this.sb.append("|");
            }
            return this;
        }
        this.sb.append("[");
        TarsDisplayer jd = new TarsDisplayer(this.sb, this._level + 1);
        for (int i = 0; i < v.length; ++i) {
            short o = v[i];
            if (i != 0) {
                this.sb.append("|");
            }
            jd.displaySimple(o, false);
        }
        this.sb.append("]");
        if (bSep) {
            this.sb.append("|");
        }
        return this;
    }

    public TarsDisplayer display(int[] v, String fieldName) {
        this.ps(fieldName);
        if (null == v) {
            this.sb.append("null").append('\n');
            return this;
        }
        if (v.length == 0) {
            this.sb.append(v.length).append(", []").append('\n');
            return this;
        }
        this.sb.append(v.length).append(", [").append('\n');
        TarsDisplayer jd = new TarsDisplayer(this.sb, this._level + 1);
        for (int o : v) {
            jd.display(o, (String)null);
        }
        this.display(']', (String)null);
        return this;
    }

    public TarsDisplayer displaySimple(int[] v, boolean bSep) {
        if (null == v || v.length == 0) {
            this.sb.append("[]");
            if (bSep) {
                this.sb.append("|");
            }
            return this;
        }
        this.sb.append("[");
        TarsDisplayer jd = new TarsDisplayer(this.sb, this._level + 1);
        for (int i = 0; i < v.length; ++i) {
            int o = v[i];
            if (i != 0) {
                this.sb.append("|");
            }
            jd.displaySimple(o, false);
        }
        this.sb.append("]");
        if (bSep) {
            this.sb.append("|");
        }
        return this;
    }

    public TarsDisplayer display(long[] v, String fieldName) {
        this.ps(fieldName);
        if (null == v) {
            this.sb.append("null").append('\n');
            return this;
        }
        if (v.length == 0) {
            this.sb.append(v.length).append(", []").append('\n');
            return this;
        }
        this.sb.append(v.length).append(", [").append('\n');
        TarsDisplayer jd = new TarsDisplayer(this.sb, this._level + 1);
        for (long o : v) {
            jd.display(o, (String)null);
        }
        this.display(']', (String)null);
        return this;
    }

    public TarsDisplayer displaySimple(long[] v, boolean bSep) {
        if (null == v || v.length == 0) {
            this.sb.append("[]");
            if (bSep) {
                this.sb.append("|");
            }
            return this;
        }
        this.sb.append("[");
        TarsDisplayer jd = new TarsDisplayer(this.sb, this._level + 1);
        for (int i = 0; i < v.length; ++i) {
            long o = v[i];
            if (i != 0) {
                this.sb.append("|");
            }
            jd.displaySimple(o, false);
        }
        this.sb.append("]");
        if (bSep) {
            this.sb.append("|");
        }
        return this;
    }

    public TarsDisplayer display(float[] v, String fieldName) {
        this.ps(fieldName);
        if (null == v) {
            this.sb.append("null").append('\n');
            return this;
        }
        if (v.length == 0) {
            this.sb.append(v.length).append(", []").append('\n');
            return this;
        }
        this.sb.append(v.length).append(", [").append('\n');
        TarsDisplayer jd = new TarsDisplayer(this.sb, this._level + 1);
        for (float o : v) {
            jd.display(o, (String)null);
        }
        this.display(']', (String)null);
        return this;
    }

    public TarsDisplayer displaySimple(float[] v, boolean bSep) {
        if (null == v || v.length == 0) {
            this.sb.append("[]");
            if (bSep) {
                this.sb.append("|");
            }
            return this;
        }
        this.sb.append("[");
        TarsDisplayer jd = new TarsDisplayer(this.sb, this._level + 1);
        for (int i = 0; i < v.length; ++i) {
            float o = v[i];
            if (i != 0) {
                this.sb.append("|");
            }
            jd.displaySimple(o, false);
        }
        this.sb.append("]");
        if (bSep) {
            this.sb.append("|");
        }
        return this;
    }

    public TarsDisplayer display(double[] v, String fieldName) {
        this.ps(fieldName);
        if (null == v) {
            this.sb.append("null").append('\n');
            return this;
        }
        if (v.length == 0) {
            this.sb.append(v.length).append(", []").append('\n');
            return this;
        }
        this.sb.append(v.length).append(", [").append('\n');
        TarsDisplayer jd = new TarsDisplayer(this.sb, this._level + 1);
        for (double o : v) {
            jd.display(o, (String)null);
        }
        this.display(']', (String)null);
        return this;
    }

    public TarsDisplayer displaySimple(double[] v, boolean bSep) {
        if (null == v || v.length == 0) {
            this.sb.append("[]");
            if (bSep) {
                this.sb.append("|");
            }
            return this;
        }
        this.sb.append("[");
        TarsDisplayer jd = new TarsDisplayer(this.sb, this._level + 1);
        for (int i = 0; i < v.length; ++i) {
            double o = v[i];
            if (i != 0) {
                this.sb.append("|");
            }
            jd.displaySimple(o, false);
        }
        this.sb.append("[");
        if (bSep) {
            this.sb.append("|");
        }
        return this;
    }

    public <K, V> TarsDisplayer display(Map<K, V> m, String fieldName) {
        this.ps(fieldName);
        if (null == m) {
            this.sb.append("null").append('\n');
            return this;
        }
        if (m.isEmpty()) {
            this.sb.append(m.size()).append(", {}").append('\n');
            return this;
        }
        this.sb.append(m.size()).append(", {").append('\n');
        TarsDisplayer jd1 = new TarsDisplayer(this.sb, this._level + 1);
        TarsDisplayer jd = new TarsDisplayer(this.sb, this._level + 2);
        for (Map.Entry<K, V> en : m.entrySet()) {
            jd1.display('(', (String)null);
            jd.display(en.getKey(), null);
            jd.display(en.getValue(), null);
            jd1.display(')', (String)null);
        }
        this.display('}', (String)null);
        return this;
    }

    public <K, V> TarsDisplayer displaySimple(Map<K, V> m, boolean bSep) {
        if (null == m || m.isEmpty()) {
            this.sb.append("{}");
            if (bSep) {
                this.sb.append("|");
            }
            return this;
        }
        this.sb.append("{");
        TarsDisplayer jd = new TarsDisplayer(this.sb, this._level + 2);
        boolean first = true;
        for (Map.Entry<K, V> en : m.entrySet()) {
            if (!first) {
                this.sb.append(",");
            }
            jd.displaySimple(en.getKey(), true);
            jd.displaySimple(en.getValue(), false);
            first = false;
        }
        this.sb.append("}");
        if (bSep) {
            this.sb.append("|");
        }
        return this;
    }

    public <T> TarsDisplayer display(T[] v, String fieldName) {
        this.ps(fieldName);
        if (null == v) {
            this.sb.append("null").append('\n');
            return this;
        }
        if (v.length == 0) {
            this.sb.append(v.length).append(", []").append('\n');
            return this;
        }
        this.sb.append(v.length).append(", [").append('\n');
        TarsDisplayer jd = new TarsDisplayer(this.sb, this._level + 1);
        for (T o : v) {
            jd.display(o, null);
        }
        this.display(']', (String)null);
        return this;
    }

    public <T> TarsDisplayer displaySimple(T[] v, boolean bSep) {
        if (null == v || v.length == 0) {
            this.sb.append("[]");
            if (bSep) {
                this.sb.append("|");
            }
            return this;
        }
        this.sb.append("[");
        TarsDisplayer jd = new TarsDisplayer(this.sb, this._level + 1);
        for (int i = 0; i < v.length; ++i) {
            T o = v[i];
            if (i != 0) {
                this.sb.append("|");
            }
            jd.displaySimple(o, false);
        }
        this.sb.append("]");
        if (bSep) {
            this.sb.append("|");
        }
        return this;
    }

    public <T> TarsDisplayer display(Collection<T> v, String fieldName) {
        if (null == v) {
            this.ps(fieldName);
            this.sb.append("null").append('\t');
            return this;
        }
        return this.display((T)v.toArray(), fieldName);
    }

    public <T> TarsDisplayer displaySimple(Collection<T> v, boolean bSep) {
        if (null == v) {
            this.sb.append("[]");
            if (bSep) {
                this.sb.append("|");
            }
            return this;
        }
        return this.displaySimple((T)v.toArray(), bSep);
    }

    public <T> TarsDisplayer display(T o, String fieldName) {
        if (null == o) {
            this.sb.append("null").append('\n');
        } else if (o instanceof Byte) {
            this.display((Byte)o, fieldName);
        } else if (o instanceof Boolean) {
            this.display((Boolean)o, fieldName);
        } else if (o instanceof Short) {
            this.display((Short)o, fieldName);
        } else if (o instanceof Integer) {
            this.display((Integer)o, fieldName);
        } else if (o instanceof Long) {
            this.display((Long)o, fieldName);
        } else if (o instanceof Float) {
            this.display(((Float)o).floatValue(), fieldName);
        } else if (o instanceof Double) {
            this.display((Double)o, fieldName);
        } else if (o instanceof String) {
            this.display((String)o, fieldName);
        } else if (o instanceof Map) {
            this.display((T)((Map)o), fieldName);
        } else if (o instanceof List) {
            this.display((T)((List)o), fieldName);
        } else if (o instanceof TarsStructBase) {
            this.display((TarsStructBase)o, fieldName);
        } else if (o instanceof byte[]) {
            this.display((byte[])o, fieldName);
        } else if (o instanceof boolean[]) {
            this.display((T)((boolean[])o), fieldName);
        } else if (o instanceof short[]) {
            this.display((short[])o, fieldName);
        } else if (o instanceof int[]) {
            this.display((int[])o, fieldName);
        } else if (o instanceof long[]) {
            this.display((long[])o, fieldName);
        } else if (o instanceof float[]) {
            this.display((float[])o, fieldName);
        } else if (o instanceof double[]) {
            this.display((double[])o, fieldName);
        } else if (o.getClass().isArray()) {
            this.display((T)((Object[])o), fieldName);
        } else {
            throw new TarsEncodeException("write object error: unsupported type.");
        }
        return this;
    }

    public <T> TarsDisplayer displaySimple(T o, boolean bSep) {
        if (null == o) {
            this.sb.append("null").append('\n');
        } else if (o instanceof Byte) {
            this.displaySimple((Byte)o, bSep);
        } else if (o instanceof Boolean) {
            this.displaySimple((Boolean)o, bSep);
        } else if (o instanceof Short) {
            this.displaySimple((Short)o, bSep);
        } else if (o instanceof Integer) {
            this.displaySimple((Integer)o, bSep);
        } else if (o instanceof Long) {
            this.displaySimple((Long)o, bSep);
        } else if (o instanceof Float) {
            this.displaySimple(((Float)o).floatValue(), bSep);
        } else if (o instanceof Double) {
            this.displaySimple((Double)o, bSep);
        } else if (o instanceof String) {
            this.displaySimple((String)o, bSep);
        } else if (o instanceof Map) {
            this.displaySimple((T)((Map)o), bSep);
        } else if (o instanceof List) {
            this.displaySimple((T)((List)o), bSep);
        } else if (o instanceof TarsStructBase) {
            this.displaySimple((TarsStructBase)o, bSep);
        } else if (o instanceof byte[]) {
            this.displaySimple((byte[])o, bSep);
        } else if (o instanceof boolean[]) {
            this.displaySimple((T)((boolean[])o), bSep);
        } else if (o instanceof short[]) {
            this.displaySimple((short[])o, bSep);
        } else if (o instanceof int[]) {
            this.displaySimple((int[])o, bSep);
        } else if (o instanceof long[]) {
            this.displaySimple((long[])o, bSep);
        } else if (o instanceof float[]) {
            this.displaySimple((float[])o, bSep);
        } else if (o instanceof double[]) {
            this.displaySimple((double[])o, bSep);
        } else if (o.getClass().isArray()) {
            this.displaySimple((T)((Object[])o), bSep);
        } else {
            throw new TarsEncodeException("write object error: unsupported type.");
        }
        return this;
    }

    public TarsDisplayer display(TarsStructBase v, String fieldName) {
        this.display('{', fieldName);
        if (null == v) {
            this.sb.append('\t').append("null");
        } else {
            v.display(this.sb, this._level + 1);
        }
        this.display('}', (String)null);
        return this;
    }

    public TarsDisplayer displaySimple(TarsStructBase v, boolean bSep) {
        this.sb.append("{");
        if (null == v) {
            this.sb.append('\t').append("null");
        } else {
            v.displaySimple(this.sb, this._level + 1);
        }
        this.sb.append("}");
        if (bSep) {
            this.sb.append("|");
        }
        return this;
    }
}

