/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.common;

import com.qq.tars.common.Filter;
import com.qq.tars.common.FilterChain;
import com.qq.tars.common.FilterKind;
import com.qq.tars.net.core.Request;
import com.qq.tars.net.core.Response;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractFilterChain<T>
implements FilterChain {
    protected String servant;
    protected FilterKind kind;
    protected T target;
    private Iterator<Filter> iterator;

    public AbstractFilterChain(List<Filter> filters, String servant, FilterKind kind, T target) {
        this.servant = servant;
        this.kind = kind;
        this.target = target;
        if (filters != null) {
            this.iterator = filters.iterator();
        }
    }

    @Override
    public void doFilter(Request request, Response response) throws Throwable {
        Filter filter = this.getFilter();
        if (filter != null) {
            filter.doFilter(request, response, this);
        } else {
            this.doRealInvoke(request, response);
        }
    }

    private Filter getFilter() {
        return this.iterator != null && this.iterator.hasNext() ? this.iterator.next() : null;
    }

    protected abstract void doRealInvoke(Request var1, Response var2) throws Throwable;
}

