/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.client;

import com.qq.tars.client.Communicator;
import com.qq.tars.client.ServantProxy;
import com.qq.tars.client.ServantProxyConfig;
import com.qq.tars.client.support.ServantCacheManager;
import com.qq.tars.client.util.ParseTools;
import com.qq.tars.common.support.ScheduledExecutorManager;
import com.qq.tars.common.util.StringUtils;
import com.qq.tars.register.RegisterManager;
import com.qq.tars.rpc.common.InvokeContext;
import com.qq.tars.rpc.common.Invoker;
import com.qq.tars.rpc.common.LoadBalance;
import com.qq.tars.rpc.common.ProtocolInvoker;
import com.qq.tars.rpc.common.Url;
import com.qq.tars.rpc.common.exc.NoInvokerException;
import com.qq.tars.rpc.exc.ClientException;
import com.qq.tars.rpc.exc.NoConnectionException;
import com.qq.tars.support.log.LoggerFactory;
import com.qq.tars.support.stat.InvokeStatHelper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Random;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public final class ObjectProxy<T>
implements ServantProxy,
InvocationHandler {
    private static final Logger logger = LoggerFactory.getClientLogger();
    private final Class<T> api;
    private final Communicator communicator;
    private final ServantCacheManager servantCacheManager = ServantCacheManager.getInstance();
    private volatile ServantProxyConfig servantProxyConfig;
    private LoadBalance loadBalancer;
    private ProtocolInvoker<T> protocolInvoker;
    private ScheduledFuture<?> statReportFuture;
    private ScheduledFuture<?> queryRefreshFuture;
    private final Object refreshLock = new Object();
    private final Random random = new Random(System.currentTimeMillis() / 1000L);

    public ObjectProxy(Class<T> api, ServantProxyConfig servantProxyConfig, LoadBalance loadBalance, ProtocolInvoker<T> protocolInvoker, Communicator communicator) {
        this.api = api;
        this.communicator = communicator;
        this.servantProxyConfig = servantProxyConfig;
        this.loadBalancer = loadBalance;
        this.protocolInvoker = protocolInvoker;
        this.initialize();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        InvokeContext context = this.protocolInvoker.createContext(proxy, method, args);
        try {
            if ("toString".equals(methodName) && parameterTypes.length == 0) {
                return this.toString();
            }
            if ("hashCode".equals(methodName) && parameterTypes.length == 0) {
                return this.hashCode();
            }
            if ("equals".equals(methodName) && parameterTypes.length == 1) {
                return this.equals(args[0]);
            }
            if ("getObjectName".equals(methodName) && parameterTypes.length == 0) {
                return this.getObjectName();
            }
            if ("getApi".equals(methodName) && parameterTypes.length == 0) {
                return this.getApi();
            }
            if ("getConfig".equals(methodName) && parameterTypes.length == 0) {
                return this.getConfig();
            }
            if ("destroy".equals(methodName) && parameterTypes.length == 0) {
                this.destroy();
                return null;
            }
            if ("refresh".equals(methodName) && parameterTypes.length == 0) {
                this.refresh();
                return null;
            }
            Invoker invoker = this.loadBalancer.select(context);
            return invoker.invoke(context);
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (logger.isDebugEnabled()) {
                logger.debug(this.servantProxyConfig.getSimpleObjectName() + " error occurred on invoke|" + e.getLocalizedMessage(), e);
            }
            if (e instanceof NoInvokerException) {
                throw new NoConnectionException(this.servantProxyConfig.getSimpleObjectName(), e.getLocalizedMessage(), e);
            }
            throw new ClientException(this.servantProxyConfig.getSimpleObjectName(), e.getLocalizedMessage(), e);
        }
    }

    public Url selectUrl() {
        return this.loadBalancer.select(null).getUrl();
    }

    public Class<T> getApi() {
        return this.api;
    }

    @Override
    public String getObjectName() {
        return this.servantProxyConfig.getSimpleObjectName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        Object object = this.refreshLock;
        synchronized (object) {
            this.registryStatReporter();
            this.registryServantNodeRefresher();
            this.protocolInvoker.refresh();
            this.loadBalancer.refresh(this.protocolInvoker.getInvokers());
        }
    }

    @Override
    public void destroy() {
        if (this.statReportFuture != null) {
            this.statReportFuture.cancel(false);
        }
        if (this.queryRefreshFuture != null) {
            this.queryRefreshFuture.cancel(false);
        }
        this.protocolInvoker.destroy();
    }

    @Override
    public ServantProxyConfig getConfig() {
        return this.servantProxyConfig;
    }

    private void initialize() {
        this.loadBalancer.refresh(this.protocolInvoker.getInvokers());
        if (StringUtils.isNotEmpty(this.servantProxyConfig.getLocator()) && !StringUtils.isEmpty(this.servantProxyConfig.getStat())) {
            this.registryStatReporter();
        }
        if (!this.servantProxyConfig.isDirectConnection()) {
            this.registryServantNodeRefresher();
        }
    }

    private void registryStatReporter() {
        if (this.statReportFuture != null && !this.statReportFuture.isCancelled()) {
            this.statReportFuture.cancel(false);
        }
        if (!StringUtils.isEmpty(this.communicator.getCommunicatorConfig().getStat())) {
            int interval = this.servantProxyConfig.getReportInterval();
            int initialDelay = interval + this.random.nextInt(30) * 1000;
            this.statReportFuture = ScheduledExecutorManager.getInstance().scheduleAtFixedRate(new ServantStatReporter(), initialDelay, interval, TimeUnit.MILLISECONDS);
        }
    }

    private void registryServantNodeRefresher() {
        if (this.queryRefreshFuture != null && !this.queryRefreshFuture.isCancelled()) {
            this.queryRefreshFuture.cancel(false);
        }
        if (!this.servantProxyConfig.isDirectConnection()) {
            int interval = this.servantProxyConfig.getRefreshInterval();
            int initialDelay = interval + this.random.nextInt(30) * 1000;
            this.queryRefreshFuture = ScheduledExecutorManager.getInstance().scheduleAtFixedRate(new ServantNodeRefresher(), initialDelay, interval, TimeUnit.MILLISECONDS);
        }
    }

    private class ServantStatReporter
    implements Runnable {
        private ServantStatReporter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long begin = System.currentTimeMillis();
            try {
                ObjectProxy.this.communicator.getStatHelper().report(InvokeStatHelper.getInstance().getProxyStat(ObjectProxy.this.servantProxyConfig.getSimpleObjectName()), true);
            }
            catch (Exception e) {
                logger.error("report stat worker error|" + ObjectProxy.this.servantProxyConfig.getSimpleObjectName(), (Throwable)e);
            }
            finally {
                logger.info("ServantStatReproter run(), use: " + (System.currentTimeMillis() - begin));
            }
        }
    }

    private class ServantNodeRefresher
    implements Runnable {
        private ServantNodeRefresher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long begin = System.currentTimeMillis();
            try {
                String nodes = RegisterManager.getInstance().getHandler() != null ? ParseTools.parse(RegisterManager.getInstance().getHandler().query(ObjectProxy.this.servantProxyConfig.getSimpleObjectName()), ObjectProxy.this.servantProxyConfig.getSimpleObjectName()) : ObjectProxy.this.communicator.getQueryHelper().getServerNodes(ObjectProxy.this.servantProxyConfig);
                if (nodes != null && !nodes.equals(ObjectProxy.this.servantProxyConfig.getObjectName())) {
                    ObjectProxy.this.servantCacheManager.save(ObjectProxy.this.communicator.getId(), ObjectProxy.this.servantProxyConfig.getSimpleObjectName(), nodes, ObjectProxy.this.communicator.getCommunicatorConfig().getDataPath());
                    ObjectProxy.this.servantProxyConfig.setObjectName(nodes);
                    ObjectProxy.this.refresh();
                }
                logger.debug("{} sync server|{}", (Object)ObjectProxy.this.servantProxyConfig.getSimpleObjectName(), (Object)nodes);
            }
            catch (Throwable e) {
                logger.error(ObjectProxy.this.servantProxyConfig.getSimpleObjectName() + " error sync server", e);
            }
            finally {
                logger.info("ServantNodeRefresher run({}), use: {}", (Object)ObjectProxy.this.servantProxyConfig.getSimpleObjectName(), (Object)(System.currentTimeMillis() - begin));
            }
        }
    }
}

