/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.internal;

import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.RegistryStore;
import io.github.resilience4j.core.registry.AbstractRegistry;
import io.github.resilience4j.core.registry.InMemoryRegistryStore;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.ratelimiter.internal.AtomicRateLimiter;
import io.vavr.collection.Array;
import io.vavr.collection.HashMap;
import io.vavr.collection.Seq;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class InMemoryRateLimiterRegistry
extends AbstractRegistry<RateLimiter, RateLimiterConfig>
implements RateLimiterRegistry {
    public InMemoryRateLimiterRegistry() {
        this(RateLimiterConfig.ofDefaults());
    }

    public InMemoryRateLimiterRegistry(io.vavr.collection.Map<String, String> tags) {
        this(RateLimiterConfig.ofDefaults(), tags);
    }

    public InMemoryRateLimiterRegistry(Map<String, RateLimiterConfig> configs) {
        this(configs, (io.vavr.collection.Map<String, String>)HashMap.empty());
    }

    public InMemoryRateLimiterRegistry(Map<String, RateLimiterConfig> configs, io.vavr.collection.Map<String, String> tags) {
        this(configs.getOrDefault("default", RateLimiterConfig.ofDefaults()), tags);
        this.configurations.putAll(configs);
    }

    public InMemoryRateLimiterRegistry(Map<String, RateLimiterConfig> configs, RegistryEventConsumer<RateLimiter> registryEventConsumer) {
        this(configs, registryEventConsumer, (io.vavr.collection.Map<String, String>)HashMap.empty());
    }

    public InMemoryRateLimiterRegistry(Map<String, RateLimiterConfig> configs, RegistryEventConsumer<RateLimiter> registryEventConsumer, io.vavr.collection.Map<String, String> tags) {
        this(configs.getOrDefault("default", RateLimiterConfig.ofDefaults()), registryEventConsumer, tags);
        this.configurations.putAll(configs);
    }

    public InMemoryRateLimiterRegistry(Map<String, RateLimiterConfig> configs, List<RegistryEventConsumer<RateLimiter>> registryEventConsumers) {
        this(configs, registryEventConsumers, (io.vavr.collection.Map<String, String>)HashMap.empty());
    }

    public InMemoryRateLimiterRegistry(Map<String, RateLimiterConfig> configs, List<RegistryEventConsumer<RateLimiter>> registryEventConsumers, io.vavr.collection.Map<String, String> tags) {
        this(configs.getOrDefault("default", RateLimiterConfig.ofDefaults()), registryEventConsumers, tags);
        this.configurations.putAll(configs);
    }

    public InMemoryRateLimiterRegistry(RateLimiterConfig defaultConfig) {
        super((Object)defaultConfig);
    }

    public InMemoryRateLimiterRegistry(RateLimiterConfig defaultConfig, io.vavr.collection.Map<String, String> tags) {
        super((Object)defaultConfig, tags);
    }

    public InMemoryRateLimiterRegistry(RateLimiterConfig defaultConfig, RegistryEventConsumer<RateLimiter> registryEventConsumer) {
        super((Object)defaultConfig, registryEventConsumer);
    }

    public InMemoryRateLimiterRegistry(RateLimiterConfig defaultConfig, RegistryEventConsumer<RateLimiter> registryEventConsumer, io.vavr.collection.Map<String, String> tags) {
        super((Object)defaultConfig, registryEventConsumer, tags);
    }

    public InMemoryRateLimiterRegistry(RateLimiterConfig defaultConfig, List<RegistryEventConsumer<RateLimiter>> registryEventConsumers) {
        super((Object)defaultConfig, registryEventConsumers);
    }

    public InMemoryRateLimiterRegistry(RateLimiterConfig defaultConfig, List<RegistryEventConsumer<RateLimiter>> registryEventConsumers, io.vavr.collection.Map<String, String> tags) {
        super((Object)defaultConfig, registryEventConsumers, tags);
    }

    public InMemoryRateLimiterRegistry(Map<String, RateLimiterConfig> configs, List<RegistryEventConsumer<RateLimiter>> registryEventConsumers, io.vavr.collection.Map<String, String> tags, RegistryStore<RateLimiter> registryStore) {
        super((Object)configs.getOrDefault("default", RateLimiterConfig.ofDefaults()), registryEventConsumers, Optional.ofNullable(tags).orElse((io.vavr.collection.Map<String, String>)HashMap.empty()), Optional.ofNullable(registryStore).orElse((RegistryStore<RateLimiter>)new InMemoryRegistryStore()));
        this.configurations.putAll(configs);
    }

    @Override
    public Seq<RateLimiter> getAllRateLimiters() {
        return Array.ofAll((Iterable)this.entryMap.values());
    }

    @Override
    public RateLimiter rateLimiter(String name) {
        return this.rateLimiter(name, (RateLimiterConfig)this.getDefaultConfig());
    }

    @Override
    public RateLimiter rateLimiter(String name, io.vavr.collection.Map<String, String> tags) {
        return this.rateLimiter(name, (RateLimiterConfig)this.getDefaultConfig(), tags);
    }

    @Override
    public RateLimiter rateLimiter(String name, RateLimiterConfig config) {
        return this.rateLimiter(name, config, (io.vavr.collection.Map<String, String>)HashMap.empty());
    }

    @Override
    public RateLimiter rateLimiter(String name, RateLimiterConfig config, io.vavr.collection.Map<String, String> tags) {
        return (RateLimiter)this.computeIfAbsent(name, () -> new AtomicRateLimiter(name, Objects.requireNonNull(config, "Config must not be null"), (io.vavr.collection.Map<String, String>)this.getAllTags(tags)));
    }

    @Override
    public RateLimiter rateLimiter(String name, Supplier<RateLimiterConfig> rateLimiterConfigSupplier) {
        return this.rateLimiter(name, rateLimiterConfigSupplier, (io.vavr.collection.Map<String, String>)HashMap.empty());
    }

    @Override
    public RateLimiter rateLimiter(String name, Supplier<RateLimiterConfig> rateLimiterConfigSupplier, io.vavr.collection.Map<String, String> tags) {
        return (RateLimiter)this.computeIfAbsent(name, () -> new AtomicRateLimiter(name, Objects.requireNonNull((RateLimiterConfig)Objects.requireNonNull(rateLimiterConfigSupplier, "Supplier must not be null").get(), "Config must not be null"), (io.vavr.collection.Map<String, String>)this.getAllTags(tags)));
    }

    @Override
    public RateLimiter rateLimiter(String name, String configName) {
        return this.rateLimiter(name, configName, (io.vavr.collection.Map<String, String>)HashMap.empty());
    }

    @Override
    public RateLimiter rateLimiter(String name, String configName, io.vavr.collection.Map<String, String> tags) {
        return (RateLimiter)this.computeIfAbsent(name, () -> RateLimiter.of(name, (RateLimiterConfig)this.getConfiguration(configName).orElseThrow(() -> new ConfigurationNotFoundException(configName)), (io.vavr.collection.Map<String, String>)this.getAllTags(tags)));
    }
}

