/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze.type;

import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.type.BreezeType;
import com.weibo.breeze.type.TypeFloat32;
import com.weibo.breeze.type.TypeFloat64;
import com.weibo.breeze.type.TypeInt16;
import com.weibo.breeze.type.TypeInt32;
import com.weibo.breeze.type.TypeInt64;

public class TypeString
implements BreezeType<String> {
    TypeString() {
    }

    public static String readString(BreezeBuffer buffer) throws BreezeException {
        return buffer.getUTF8(-1);
    }

    public static String readString(BreezeBuffer buffer, byte type) throws BreezeException {
        return buffer.getUTF8(type);
    }

    @Override
    public byte getType() {
        return 63;
    }

    @Override
    public String read(BreezeBuffer buffer, boolean withType) throws BreezeException {
        if (!withType) {
            return TypeString.readString(buffer);
        }
        byte type = buffer.get();
        if (type >= 0 && type <= 62) {
            return buffer.getUTF8(type);
        }
        switch (type) {
            case 63: {
                return TypeString.readString(buffer);
            }
            case 127: {
                return String.valueOf(TypeInt32.readInt32(buffer));
            }
            case -104: {
                return String.valueOf(TypeInt64.readInt64(buffer));
            }
            case -98: {
                return String.valueOf(TypeInt16.readInt16(buffer));
            }
            case -97: {
                return String.valueOf(TypeFloat32.readFloat32(buffer));
            }
            case -96: {
                return String.valueOf(TypeFloat64.readFloat64(buffer));
            }
        }
        throw new BreezeException("Breeze cannot convert to String. type: " + type);
    }

    @Override
    public void write(BreezeBuffer buffer, String value, boolean withType) throws BreezeException {
        int length = buffer.getUTF8Length(value);
        if (withType) {
            if (length <= 62) {
                buffer.put((byte)length);
                buffer.putUTF8(value, length, false);
                return;
            }
            buffer.put((byte)63);
        }
        buffer.putUTF8(value, length, true);
    }
}

