/*
 * Decompiled with CFR 0.152.
 */
package io.fury.resolver;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import io.fury.Fury;
import io.fury.annotation.Internal;
import io.fury.builder.CodecUtils;
import io.fury.builder.Generated;
import io.fury.builder.JITContext;
import io.fury.codegen.Expression;
import io.fury.codegen.ExpressionUtils;
import io.fury.collection.IdentityMap;
import io.fury.collection.IdentityObjectIntMap;
import io.fury.collection.LongMap;
import io.fury.collection.ObjectMap;
import io.fury.collection.Tuple2;
import io.fury.config.CompatibleMode;
import io.fury.config.Language;
import io.fury.exception.InsecureException;
import io.fury.memory.MemoryBuffer;
import io.fury.resolver.BlackList;
import io.fury.resolver.ClassChecker;
import io.fury.resolver.ClassInfo;
import io.fury.resolver.ClassInfoHolder;
import io.fury.resolver.EnumStringBytes;
import io.fury.resolver.EnumStringResolver;
import io.fury.resolver.FieldResolver;
import io.fury.resolver.MetaContext;
import io.fury.serializer.ArraySerializers;
import io.fury.serializer.BufferSerializers;
import io.fury.serializer.CodegenSerializer;
import io.fury.serializer.CompatibleSerializer;
import io.fury.serializer.ExternalizableSerializer;
import io.fury.serializer.JavaSerializer;
import io.fury.serializer.JdkProxySerializer;
import io.fury.serializer.LambdaSerializer;
import io.fury.serializer.LocaleSerializer;
import io.fury.serializer.MetaSharedSerializer;
import io.fury.serializer.ObjectSerializer;
import io.fury.serializer.OptionalSerializers;
import io.fury.serializer.PrimitiveSerializers;
import io.fury.serializer.ReplaceResolveSerializer;
import io.fury.serializer.Serializer;
import io.fury.serializer.SerializerFactory;
import io.fury.serializer.Serializers;
import io.fury.serializer.StringSerializer;
import io.fury.serializer.StructSerializer;
import io.fury.serializer.TimeSerializers;
import io.fury.serializer.UnexistedClassSerializers;
import io.fury.serializer.collection.ChildContainerSerializers;
import io.fury.serializer.collection.CollectionSerializer;
import io.fury.serializer.collection.CollectionSerializers;
import io.fury.serializer.collection.GuavaCollectionSerializers;
import io.fury.serializer.collection.ImmutableCollectionSerializers;
import io.fury.serializer.collection.MapSerializer;
import io.fury.serializer.collection.MapSerializers;
import io.fury.serializer.collection.SynchronizedSerializers;
import io.fury.serializer.collection.UnmodifiableSerializers;
import io.fury.serializer.scala.SingletonCollectionSerializer;
import io.fury.serializer.scala.SingletonMapSerializer;
import io.fury.serializer.scala.SingletonObjectSerializer;
import io.fury.serializer.shim.ShimDispatcher;
import io.fury.type.ClassDef;
import io.fury.type.Descriptor;
import io.fury.type.GenericType;
import io.fury.type.ScalaTypes;
import io.fury.type.TypeUtils;
import io.fury.util.GraalvmSupport;
import io.fury.util.LoggerFactory;
import io.fury.util.Platform;
import io.fury.util.Preconditions;
import io.fury.util.ReflectionUtils;
import io.fury.util.StringUtils;
import io.fury.util.function.Functions;
import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class ClassResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ClassResolver.class);
    public static final byte USE_CLASS_VALUE_FLAG = 1;
    public static final short NO_CLASS_ID = 0;
    public static final short LAMBDA_STUB_ID = 1;
    public static final short JDK_PROXY_STUB_ID = 2;
    public static final short REPLACE_STUB_ID = 3;
    public static final short PRIMITIVE_VOID_CLASS_ID = 4;
    public static final short PRIMITIVE_BOOLEAN_CLASS_ID = 5;
    public static final short PRIMITIVE_BYTE_CLASS_ID = 6;
    public static final short PRIMITIVE_CHAR_CLASS_ID = 7;
    public static final short PRIMITIVE_SHORT_CLASS_ID = 8;
    public static final short PRIMITIVE_INT_CLASS_ID = 9;
    public static final short PRIMITIVE_FLOAT_CLASS_ID = 10;
    public static final short PRIMITIVE_LONG_CLASS_ID = 11;
    public static final short PRIMITIVE_DOUBLE_CLASS_ID = 12;
    public static final short VOID_CLASS_ID = 13;
    public static final short BOOLEAN_CLASS_ID = 14;
    public static final short BYTE_CLASS_ID = 15;
    public static final short CHAR_CLASS_ID = 16;
    public static final short SHORT_CLASS_ID = 17;
    public static final short INTEGER_CLASS_ID = 18;
    public static final short FLOAT_CLASS_ID = 19;
    public static final short LONG_CLASS_ID = 20;
    public static final short DOUBLE_CLASS_ID = 21;
    public static final short STRING_CLASS_ID = 22;
    public static final short PRIMITIVE_BOOLEAN_ARRAY_CLASS_ID = 23;
    public static final short PRIMITIVE_BYTE_ARRAY_CLASS_ID = 24;
    public static final short PRIMITIVE_CHAR_ARRAY_CLASS_ID = 25;
    public static final short PRIMITIVE_SHORT_ARRAY_CLASS_ID = 26;
    public static final short PRIMITIVE_INT_ARRAY_CLASS_ID = 27;
    public static final short PRIMITIVE_FLOAT_ARRAY_CLASS_ID = 28;
    public static final short PRIMITIVE_LONG_ARRAY_CLASS_ID = 29;
    public static final short PRIMITIVE_DOUBLE_ARRAY_CLASS_ID = 30;
    public static final short STRING_ARRAY_CLASS_ID = 31;
    public static final short OBJECT_ARRAY_CLASS_ID = 32;
    public static final short ARRAYLIST_CLASS_ID = 33;
    public static final short HASHMAP_CLASS_ID = 34;
    public static final short HASHSET_CLASS_ID = 35;
    public static final short CLASS_CLASS_ID = 36;
    public static final short EMPTY_OBJECT_ID = 37;
    private static final int initialCapacity = 128;
    private static final float loadFactor = 0.25f;
    private static final float furyMapLoadFactor = 0.25f;
    private static final String META_SHARE_FIELDS_INFO_KEY = "shareFieldsInfo";
    private static final ClassInfo NIL_CLASS_INFO = new ClassInfo(null, null, null, null, false, null, null, 0);
    private final Fury fury;
    private ClassInfo[] registeredId2ClassInfo = new ClassInfo[0];
    private final IdentityMap<Class<?>, ClassInfo> classInfoMap = new IdentityMap(128, 0.25f);
    private ClassInfo classInfoCache;
    private final ObjectMap<EnumStringBytes, Class<?>> classNameBytes2Class = new ObjectMap(128, 0.25f);
    private final ObjectMap<ClassNameBytes, Class<?>> compositeClassNameBytes2Class = new ObjectMap(128, 0.25f);
    private final HashMap<Short, Class<?>> typeIdToClassXLangMap = new HashMap(128, 0.25f);
    private final HashMap<String, Class<?>> typeTagToClassXLangMap = new HashMap(128, 0.25f);
    private final EnumStringResolver enumStringResolver;
    private final boolean metaContextShareEnabled;
    private final Map<Class<?>, ClassDef> classDefMap = new HashMap();
    private Class<?> currentReadClass;
    private short innerEndClassId;
    private final ExtRegistry extRegistry;
    private final ShimDispatcher shimDispatcher;
    private static final ConcurrentMap<Integer, List<ClassResolver>> GRAALVM_REGISTRY = new ConcurrentHashMap<Integer, List<ClassResolver>>();

    public ClassResolver(Fury fury) {
        this.fury = fury;
        this.enumStringResolver = fury.getEnumStringResolver();
        this.classInfoCache = NIL_CLASS_INFO;
        this.metaContextShareEnabled = fury.getConfig().shareMetaContext();
        this.extRegistry = new ExtRegistry();
        this.extRegistry.objectGenericType = this.buildGenericType(TypeUtils.OBJECT_TYPE);
        this.shimDispatcher = new ShimDispatcher(fury);
    }

    public void initialize() {
        this.register(LambdaSerializer.ReplaceStub.class, 1);
        this.register(JdkProxySerializer.ReplaceStub.class, 2);
        this.register(ReplaceResolveSerializer.ReplaceStub.class, 3);
        this.registerWithCheck(Void.TYPE, (short)4);
        this.registerWithCheck(Boolean.TYPE, (short)5);
        this.registerWithCheck(Byte.TYPE, (short)6);
        this.registerWithCheck(Character.TYPE, (short)7);
        this.registerWithCheck(Short.TYPE, (short)8);
        this.registerWithCheck(Integer.TYPE, (short)9);
        this.registerWithCheck(Float.TYPE, (short)10);
        this.registerWithCheck(Long.TYPE, (short)11);
        this.registerWithCheck(Double.TYPE, (short)12);
        this.registerWithCheck(Void.class, (short)13);
        this.registerWithCheck(Boolean.class, (short)14);
        this.registerWithCheck(Byte.class, (short)15);
        this.registerWithCheck(Character.class, (short)16);
        this.registerWithCheck(Short.class, (short)17);
        this.registerWithCheck(Integer.class, (short)18);
        this.registerWithCheck(Float.class, (short)19);
        this.registerWithCheck(Long.class, (short)20);
        this.registerWithCheck(Double.class, (short)21);
        this.registerWithCheck(String.class, (short)22);
        this.registerWithCheck(boolean[].class, (short)23);
        this.registerWithCheck(byte[].class, (short)24);
        this.registerWithCheck(char[].class, (short)25);
        this.registerWithCheck(short[].class, (short)26);
        this.registerWithCheck(int[].class, (short)27);
        this.registerWithCheck(float[].class, (short)28);
        this.registerWithCheck(long[].class, (short)29);
        this.registerWithCheck(double[].class, (short)30);
        this.registerWithCheck(String[].class, (short)31);
        this.registerWithCheck(Object[].class, (short)32);
        this.registerWithCheck(ArrayList.class, (short)33);
        this.registerWithCheck(HashMap.class, (short)34);
        this.registerWithCheck(HashSet.class, (short)35);
        this.registerWithCheck(Class.class, (short)36);
        this.registerWithCheck(Object.class, (short)37);
        this.registerCommonUsedClasses();
        this.addDefaultSerializers();
        this.registerDefaultClasses();
        this.shimDispatcher.initialize();
        this.innerEndClassId = this.extRegistry.registeredClassIdCounter;
    }

    private void addDefaultSerializers() {
        this.addDefaultSerializer(String.class, new StringSerializer(this.fury));
        PrimitiveSerializers.registerDefaultSerializers(this.fury);
        ArraySerializers.registerDefaultSerializers(this.fury);
        Serializers.registerDefaultSerializers(this.fury);
        TimeSerializers.registerDefaultSerializers(this.fury);
        OptionalSerializers.registerDefaultSerializers(this.fury);
        CollectionSerializers.registerDefaultSerializers(this.fury);
        MapSerializers.registerDefaultSerializers(this.fury);
        this.addDefaultSerializer(Locale.class, new LocaleSerializer(this.fury));
        this.addDefaultSerializer(LambdaSerializer.ReplaceStub.class, new LambdaSerializer(this.fury, LambdaSerializer.ReplaceStub.class));
        this.addDefaultSerializer(JdkProxySerializer.ReplaceStub.class, new JdkProxySerializer(this.fury, JdkProxySerializer.ReplaceStub.class));
        this.addDefaultSerializer(ReplaceResolveSerializer.ReplaceStub.class, new ReplaceResolveSerializer(this.fury, ReplaceResolveSerializer.ReplaceStub.class));
        SynchronizedSerializers.registerSerializers(this.fury);
        UnmodifiableSerializers.registerSerializers(this.fury);
        ImmutableCollectionSerializers.registerSerializers(this.fury);
        if (this.fury.getConfig().registerGuavaTypes()) {
            GuavaCollectionSerializers.registerDefaultSerializers(this.fury);
        }
        if (this.metaContextShareEnabled) {
            this.addDefaultSerializer(UnexistedClassSerializers.UnexistedMetaSharedClass.class, new UnexistedClassSerializers.UnexistedClassSerializer(this.fury, null));
            short classId = Objects.requireNonNull(this.classInfoMap.get(UnexistedClassSerializers.UnexistedMetaSharedClass.class)).classId;
            Preconditions.checkArgument(classId > 63 && classId < 8192, classId);
        } else {
            this.register((Class<?>)UnexistedClassSerializers.UnexistedSkipClass.class);
        }
    }

    private void addDefaultSerializer(Class<?> type, Class<? extends Serializer> serializerClass) {
        this.addDefaultSerializer(type, Serializers.newSerializer(this.fury, type, serializerClass));
    }

    private void addDefaultSerializer(Class type, Serializer serializer) {
        this.registerSerializer(type, serializer);
        this.register((Class<?>)type);
    }

    private void registerCommonUsedClasses() {
        this.register((Class<?>)Class.class);
        this.register(ArrayList.class, LinkedList.class, HashSet.class, TreeSet.class);
        this.register(HashMap.class, LinkedHashMap.class, TreeMap.class);
        this.register(ByteBuffer.allocate(1).getClass());
        this.register(Integer[].class, Long[].class);
        this.register(Date.class, Timestamp.class, LocalDateTime.class, Instant.class);
        this.register(BigInteger.class, BigDecimal.class);
        this.register(Optional.class, OptionalInt.class);
    }

    private void registerDefaultClasses() {
        this.register(Object.class, Object[].class, Void.class);
        this.register(ByteBuffer.allocate(1).getClass());
        this.register(ByteBuffer.allocateDirect(1).getClass());
        this.register(Comparator.naturalOrder().getClass());
        this.register(Comparator.reverseOrder().getClass());
        this.register((Class<?>)ConcurrentHashMap.class);
        this.register((Class<?>)ArrayBlockingQueue.class);
        this.register((Class<?>)LinkedBlockingQueue.class);
        this.register(Boolean[].class, Byte[].class, Short[].class, Character[].class);
        this.register(Integer[].class, Float[].class, Long[].class, Double[].class);
        this.register((Class<?>)AtomicBoolean.class);
        this.register((Class<?>)AtomicInteger.class);
        this.register((Class<?>)AtomicLong.class);
        this.register((Class<?>)AtomicReference.class);
        this.register(EnumSet.allOf(Language.class).getClass());
        this.register(EnumSet.of(Language.JAVA).getClass());
        this.register(Throwable.class, StackTraceElement.class, Exception.class, RuntimeException.class);
        this.register((Class<?>)NullPointerException.class);
        this.register((Class<?>)IOException.class);
        this.register((Class<?>)IllegalArgumentException.class);
        this.register((Class<?>)IllegalStateException.class);
        this.register(IndexOutOfBoundsException.class, ArrayIndexOutOfBoundsException.class);
    }

    public void register(Class<?> cls) {
        if (!this.extRegistry.registeredClassIdMap.containsKey(cls)) {
            while (this.extRegistry.registeredId2Classes.containsKey(this.extRegistry.registeredClassIdCounter)) {
                ExtRegistry.access$208(this.extRegistry);
            }
            this.register(cls, this.extRegistry.registeredClassIdCounter);
        }
    }

    public void register(Class<?> ... classes) {
        for (Class<?> cls : classes) {
            this.register(cls);
        }
    }

    public void register(Class<?> cls, boolean createSerializer) {
        this.register(cls);
        if (createSerializer) {
            this.getSerializer(cls);
        }
    }

    public void register(Class<?> cls, String typeTag) {
        if (this.fury.getLanguage() == Language.JAVA) {
            throw new IllegalArgumentException("Java serialization should register class by Fury#register(Class) or Fury.register(Class<?>, Short)");
        }
        this.register(cls);
        Preconditions.checkArgument(!this.typeTagToClassXLangMap.containsKey(typeTag));
        this.addSerializer(cls, new StructSerializer(this.fury, cls, typeTag));
    }

    public void register(Class<?> cls, int classId) {
        Preconditions.checkArgument(classId >= 0 && classId < Short.MAX_VALUE);
        short id = (short)classId;
        if (!this.extRegistry.registeredClassIdMap.containsKey(cls)) {
            ClassInfo classInfo;
            if (this.extRegistry.registeredClasses.containsKey(cls.getName())) {
                throw new IllegalArgumentException(String.format("Class %s with name %s has been registered, registering class with same name are not allowed.", this.extRegistry.registeredClasses.get(cls.getName()), cls.getName()));
            }
            Class idToClass = (Class)this.extRegistry.registeredId2Classes.get(id);
            if (idToClass != null) {
                throw new IllegalArgumentException(String.format("Class %s with id %s has been registered, registering class %s with same id are not allowed.", idToClass, id, cls.getName()));
            }
            this.extRegistry.registeredClassIdMap.put(cls, id);
            if (this.registeredId2ClassInfo.length <= id) {
                ClassInfo[] tmp = new ClassInfo[(id + 1) * 2];
                System.arraycopy(this.registeredId2ClassInfo, 0, tmp, 0, this.registeredId2ClassInfo.length);
                this.registeredId2ClassInfo = tmp;
            }
            if ((classInfo = this.classInfoMap.get(cls)) != null) {
                classInfo.classId = id;
            } else {
                classInfo = new ClassInfo(this, cls, null, null, id);
                this.classInfoMap.put(cls, classInfo);
            }
            this.registeredId2ClassInfo[id] = classInfo;
            this.extRegistry.registeredClasses.put(cls.getName(), cls);
            ExtRegistry.access$208(this.extRegistry);
            this.extRegistry.registeredId2Classes.put(id, cls);
        }
    }

    public void register(Class<?> cls, Short id, boolean createSerializer) {
        this.register(cls, id.shortValue());
        if (createSerializer) {
            this.getSerializer(cls);
        }
    }

    public void registerWithCheck(Class<?> cls, short id) {
        if (this.extRegistry.registeredClassIdMap.containsKey(cls)) {
            throw new IllegalArgumentException(String.format("Class %s already registered with id %s.", cls, this.extRegistry.registeredClassIdMap.get(cls)));
        }
        this.register(cls, id);
    }

    public Short getRegisteredClassId(Class<?> cls) {
        return (Short)this.extRegistry.registeredClassIdMap.get(cls);
    }

    public Class<?> getRegisteredClass(short id) {
        ClassInfo classInfo;
        if (id < this.registeredId2ClassInfo.length && (classInfo = this.registeredId2ClassInfo[id]) != null) {
            return classInfo.cls;
        }
        return null;
    }

    public List<Class<?>> getRegisteredClasses() {
        return Arrays.stream(this.registeredId2ClassInfo).filter(Objects::nonNull).map(info -> info.cls).collect(Collectors.toList());
    }

    public boolean isFinal(Class<?> clz) {
        if (Modifier.isFinal(clz.getModifiers())) {
            if (this.fury.getConfig().shareMetaContext()) {
                boolean isInnerClass = this.isInnerClass(clz);
                if (!isInnerClass) {
                    return false;
                }
                return !Map.class.isAssignableFrom(clz) && !Collection.class.isAssignableFrom(clz);
            }
            return true;
        }
        return false;
    }

    boolean isInnerClass(Class<?> cls) {
        ClassInfo classInfo;
        Short classId = (Short)this.extRegistry.registeredClassIdMap.get(cls);
        if (classId == null && (classInfo = this.getClassInfo(cls, false)) != null) {
            classId = classInfo.getClassId();
        }
        return classId != null && classId != 0 && classId < this.innerEndClassId;
    }

    public static boolean useReplaceResolveSerializer(Class<?> clz) {
        return JavaSerializer.getWriteReplaceMethod(clz) != null || JavaSerializer.getReadResolveMethod(clz) != null;
    }

    public static boolean requireJavaSerialization(Class<?> clz) {
        if (clz.isEnum() || clz.isArray()) {
            return false;
        }
        if (ReflectionUtils.isDynamicGeneratedCLass(clz)) {
            return false;
        }
        if (!Serializable.class.isAssignableFrom(clz)) {
            return false;
        }
        if (ClassResolver.useReplaceResolveSerializer(clz)) {
            return false;
        }
        if (Externalizable.class.isAssignableFrom(clz)) {
            return false;
        }
        if ("sun.reflect.annotation.AnnotationInvocationHandler".equals(clz.getName())) {
            return false;
        }
        return JavaSerializer.getReadObjectMethod(clz) != null || JavaSerializer.getWriteObjectMethod(clz) != null;
    }

    public <T> void registerSerializer(Class<T> type, Class<? extends Serializer> serializerClass) {
        this.registerSerializer(type, Serializers.newSerializer(this.fury, type, serializerClass));
    }

    public void registerSerializer(Class<?> type, Serializer<?> serializer) {
        if (!this.extRegistry.registeredClassIdMap.containsKey(type) && this.fury.getLanguage() == Language.JAVA) {
            this.register(type);
        }
        this.addSerializer(type, serializer);
    }

    public void setSerializerFactory(SerializerFactory serializerFactory) {
        this.extRegistry.serializerFactory = serializerFactory;
    }

    public SerializerFactory getSerializerFactory() {
        return this.extRegistry.serializerFactory;
    }

    public <T> void setSerializer(Class<T> cls, Serializer<T> serializer) {
        this.addSerializer(cls, serializer);
    }

    public void setSerializer(String className, Class<? extends Serializer> serializer) {
        for (Map.Entry entry : this.classInfoMap.iterable()) {
            if (this.extRegistry.registeredClasses.containsKey(className)) {
                LOG.warn("Skip clear serializer for registered class {}", (Object)className);
                return;
            }
            Class cls = (Class)entry.getKey();
            if (!cls.getName().equals(className)) continue;
            LOG.info("Clear serializer for class {}.", (Object)className);
            ((ClassInfo)entry.getValue()).serializer = Serializers.newSerializer(this.fury, cls, serializer);
            this.classInfoCache = NIL_CLASS_INFO;
            return;
        }
    }

    public void setSerializers(String classNamePrefix, Class<? extends Serializer> serializer) {
        for (Map.Entry entry : this.classInfoMap.iterable()) {
            Class cls = (Class)entry.getKey();
            String className = cls.getName();
            if (this.extRegistry.registeredClasses.containsKey(className)) {
                LOG.debug("Skip clear serializer for registered class {}", (Object)className);
                continue;
            }
            if (!className.startsWith(classNamePrefix)) continue;
            LOG.info("Clear serializer for class {}.", (Object)className);
            ((ClassInfo)entry.getValue()).serializer = Serializers.newSerializer(this.fury, cls, serializer);
            this.classInfoCache = NIL_CLASS_INFO;
        }
    }

    public <T> void resetSerializer(Class<T> cls, Serializer<T> serializer) {
        if (serializer == null) {
            this.clearSerializer(cls);
        } else {
            this.setSerializer(cls, serializer);
        }
    }

    public <T> void setSerializerIfAbsent(Class<T> cls, Serializer<T> serializer) {
        Serializer<T> s = this.getSerializer(cls, false);
        if (s == null) {
            this.setSerializer(cls, serializer);
        }
    }

    public void clearSerializer(Class<?> cls) {
        ClassInfo classInfo = this.classInfoMap.get(cls);
        if (classInfo != null) {
            classInfo.serializer = null;
        }
    }

    private void addSerializer(Class<?> type, Serializer<?> serializer) {
        ClassInfo classInfo;
        Short classId;
        Preconditions.checkNotNull(serializer);
        String typeTag = null;
        short typeId = serializer.getXtypeId();
        if (typeId != 0) {
            if (typeId > 0) {
                this.typeIdToClassXLangMap.put(typeId, type);
            }
            if (typeId == Fury.FURY_TYPE_TAG_ID) {
                typeTag = serializer.getCrossLanguageTypeTag();
                this.typeTagToClassXLangMap.put(typeTag, type);
            }
        }
        if ((classId = (Short)this.extRegistry.registeredClassIdMap.get(type)) != null) {
            classInfo = this.registeredId2ClassInfo[classId];
            classInfo.serializer = serializer;
        } else {
            classId = serializer instanceof ReplaceResolveSerializer ? Short.valueOf((short)3) : Short.valueOf((short)0);
            classInfo = this.classInfoMap.get(type);
        }
        if (classInfo == null || typeTag != null || classId != classInfo.classId) {
            classInfo = new ClassInfo(this, type, typeTag, serializer, classId);
        } else {
            classInfo.serializer = serializer;
        }
        this.classInfoMap.put(type, classInfo);
    }

    public <T> Serializer<T> getSerializer(Class<T> cls, boolean createIfNotExist) {
        Preconditions.checkNotNull(cls);
        if (createIfNotExist) {
            return this.getSerializer(cls);
        }
        ClassInfo classInfo = this.classInfoMap.get(cls);
        return classInfo == null ? null : classInfo.serializer;
    }

    public <T> Serializer<T> getSerializer(Class<T> cls) {
        Preconditions.checkNotNull(cls);
        return this.getOrUpdateClassInfo(cls).serializer;
    }

    @Internal
    public Serializer<?> getRawSerializer(Class<?> cls) {
        Preconditions.checkNotNull(cls);
        return this.getOrUpdateClassInfo(cls).serializer;
    }

    public boolean isSerializable(Class<?> cls) {
        if (ReflectionUtils.isAbstract(cls) || cls.isInterface()) {
            return false;
        }
        try {
            this.getSerializerClass(cls, false);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public Class<? extends Serializer> getSerializerClass(Class<?> cls) {
        boolean codegen = CodegenSerializer.supportCodegenForJavaSerialization(cls) && this.fury.getConfig().isCodeGenEnabled();
        return this.getSerializerClass(cls, codegen);
    }

    public Class<? extends Serializer> getSerializerClass(Class<?> cls, boolean codegen) {
        if (ReflectionUtils.isAbstract(cls) || cls.isInterface()) {
            throw new UnsupportedOperationException(String.format("Class %s doesn't support serialization.", cls));
        }
        Class<? extends Serializer> serializerClass = this.getSerializerClassFromGraalvmRegistry(cls);
        if (serializerClass != null) {
            return serializerClass;
        }
        ClassInfo classInfo = this.classInfoMap.get(cls = TypeUtils.boxedType(cls));
        if (classInfo != null && classInfo.serializer != null) {
            return classInfo.serializer.getClass();
        }
        if (cls.isEnum()) {
            return Serializers.EnumSerializer.class;
        }
        if (Enum.class.isAssignableFrom(cls) && cls != Enum.class) {
            return Serializers.EnumSerializer.class;
        }
        if (EnumSet.class.isAssignableFrom(cls)) {
            return CollectionSerializers.EnumSetSerializer.class;
        }
        if (Charset.class.isAssignableFrom(cls)) {
            return Serializers.CharsetSerializer.class;
        }
        if (cls.isArray()) {
            Preconditions.checkArgument(!cls.getComponentType().isPrimitive());
            return ArraySerializers.ObjectArraySerializer.class;
        }
        if (Functions.isLambda(cls)) {
            return LambdaSerializer.class;
        }
        if (ReflectionUtils.isJdkProxy(cls)) {
            return JdkProxySerializer.class;
        }
        if (Calendar.class.isAssignableFrom(cls)) {
            return TimeSerializers.CalendarSerializer.class;
        }
        if (ZoneId.class.isAssignableFrom(cls)) {
            return TimeSerializers.ZoneIdSerializer.class;
        }
        if (TimeZone.class.isAssignableFrom(cls)) {
            return TimeSerializers.TimeZoneSerializer.class;
        }
        if (ByteBuffer.class.isAssignableFrom(cls)) {
            return BufferSerializers.ByteBufferSerializer.class;
        }
        if (this.fury.getConfig().checkJdkClassSerializable() && cls.getName().startsWith("java") && !Serializable.class.isAssignableFrom(cls)) {
            throw new UnsupportedOperationException(String.format("Class %s doesn't support serialization.", cls));
        }
        if (this.fury.getConfig().isScalaOptimizationEnabled() && ReflectionUtils.isScalaSingletonObject(cls)) {
            if (this.isCollection(cls)) {
                return SingletonCollectionSerializer.class;
            }
            if (this.isMap(cls)) {
                return SingletonMapSerializer.class;
            }
            return SingletonObjectSerializer.class;
        }
        if (this.isCollection(cls)) {
            serializerClass = ChildContainerSerializers.getCollectionSerializerClass(cls);
            if (serializerClass != null) {
                return serializerClass;
            }
            if (ClassResolver.requireJavaSerialization(cls) || ClassResolver.useReplaceResolveSerializer(cls)) {
                return CollectionSerializers.JDKCompatibleCollectionSerializer.class;
            }
            if (this.fury.getLanguage() == Language.JAVA) {
                return CollectionSerializers.DefaultJavaCollectionSerializer.class;
            }
            return CollectionSerializer.class;
        }
        if (this.isMap(cls)) {
            serializerClass = ChildContainerSerializers.getMapSerializerClass(cls);
            if (serializerClass != null) {
                return serializerClass;
            }
            if (ClassResolver.requireJavaSerialization(cls) || ClassResolver.useReplaceResolveSerializer(cls)) {
                return MapSerializers.JDKCompatibleMapSerializer.class;
            }
            if (this.fury.getLanguage() == Language.JAVA) {
                return MapSerializers.DefaultJavaMapSerializer.class;
            }
            return MapSerializer.class;
        }
        if (this.fury.getLanguage() != Language.JAVA) {
            LOG.warn("Class {} isn't supported for cross-language serialization.", cls);
        }
        if (ClassResolver.useReplaceResolveSerializer(cls)) {
            return ReplaceResolveSerializer.class;
        }
        if (Externalizable.class.isAssignableFrom(cls)) {
            return ExternalizableSerializer.class;
        }
        if (ClassResolver.requireJavaSerialization(cls)) {
            return this.getJavaSerializer(cls);
        }
        final Class<?> clz = cls;
        return this.getObjectSerializerClass(cls, this.metaContextShareEnabled, codegen, new JITContext.SerializerJITCallback<Class<? extends Serializer>>(){

            @Override
            public void onSuccess(Class<? extends Serializer> result) {
                ClassResolver.this.setSerializer(clz, Serializers.newSerializer(ClassResolver.this.fury, clz, result));
                if (((ClassResolver)ClassResolver.this).classInfoCache.cls == clz) {
                    ClassResolver.this.classInfoCache = NIL_CLASS_INFO;
                }
                Preconditions.checkState(ClassResolver.this.getSerializer(clz).getClass() == result);
            }

            @Override
            public Object id() {
                return clz;
            }
        });
    }

    public boolean isCollection(Class<?> cls) {
        if (Collection.class.isAssignableFrom(cls)) {
            return true;
        }
        if (this.fury.getConfig().isScalaOptimizationEnabled()) {
            if (ScalaTypes.getScalaMapType().isAssignableFrom(cls)) {
                return false;
            }
            return ScalaTypes.getScalaIterableType().isAssignableFrom(cls);
        }
        return false;
    }

    public boolean isMap(Class<?> cls) {
        return Map.class.isAssignableFrom(cls) || this.fury.getConfig().isScalaOptimizationEnabled() && ScalaTypes.getScalaMapType().isAssignableFrom(cls);
    }

    public Class<? extends Serializer> getObjectSerializerClass(Class<?> cls, JITContext.SerializerJITCallback<Class<? extends Serializer>> callback) {
        boolean codegen = CodegenSerializer.supportCodegenForJavaSerialization(cls) && this.fury.getConfig().isCodeGenEnabled();
        return this.getObjectSerializerClass(cls, false, codegen, callback);
    }

    private Class<? extends Serializer> getObjectSerializerClass(Class<?> cls, boolean shareMeta, boolean codegen, JITContext.SerializerJITCallback<Class<? extends Serializer>> callback) {
        if (codegen) {
            if (this.extRegistry.getClassCtx.contains(cls)) {
                return CodegenSerializer.LazyInitBeanSerializer.class;
            }
            try {
                this.extRegistry.getClassCtx.add(cls);
                switch (this.fury.getCompatibleMode()) {
                    case SCHEMA_CONSISTENT: {
                        Class<? extends Serializer> sc;
                        Class<? extends Serializer> clazz = sc = this.fury.getJITContext().registerSerializerJITCallback(() -> ObjectSerializer.class, () -> CodegenSerializer.loadCodegenSerializer(this.fury, cls), callback);
                        return clazz;
                    }
                    case COMPATIBLE: {
                        Class<? extends Serializer> sc;
                        Class<? extends Serializer> clazz = sc = this.fury.getJITContext().registerSerializerJITCallback(() -> shareMeta ? ObjectSerializer.class : CompatibleSerializer.class, () -> shareMeta ? CodegenSerializer.loadCodegenSerializer(this.fury, cls) : CodegenSerializer.loadCompatibleCodegenSerializer(this.fury, cls), callback);
                        return clazz;
                    }
                }
                throw new UnsupportedOperationException(String.format("Unsupported mode %s", new Object[]{this.fury.getCompatibleMode()}));
            }
            finally {
                this.extRegistry.getClassCtx.remove(cls);
            }
        }
        LOG.debug("Object of type {} can't be serialized by jit", cls);
        switch (this.fury.getCompatibleMode()) {
            case SCHEMA_CONSISTENT: {
                return ObjectSerializer.class;
            }
            case COMPATIBLE: {
                return shareMeta ? ObjectSerializer.class : CompatibleSerializer.class;
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported mode %s", new Object[]{this.fury.getCompatibleMode()}));
    }

    public Class<? extends Serializer> getJavaSerializer(Class<?> clz) {
        if (Collection.class.isAssignableFrom(clz)) {
            return CollectionSerializers.JDKCompatibleCollectionSerializer.class;
        }
        if (Map.class.isAssignableFrom(clz)) {
            return MapSerializers.JDKCompatibleMapSerializer.class;
        }
        if (ClassResolver.useReplaceResolveSerializer(clz)) {
            return ReplaceResolveSerializer.class;
        }
        return this.fury.getDefaultJDKStreamSerializerType();
    }

    public ClassChecker getClassChecker() {
        return this.extRegistry.classChecker;
    }

    public void setClassChecker(ClassChecker classChecker) {
        this.extRegistry.classChecker = classChecker;
    }

    public FieldResolver getFieldResolver(Class<?> cls) {
        FieldResolver fieldResolver = (FieldResolver)this.extRegistry.fieldResolverMap.get(cls);
        if (fieldResolver == null) {
            fieldResolver = FieldResolver.of(this.fury, cls);
            this.extRegistry.fieldResolverMap.put(cls, fieldResolver);
        }
        return fieldResolver;
    }

    public SortedMap<Field, Descriptor> getAllDescriptorsMap(Class<?> clz, boolean searchParent) {
        return this.extRegistry.descriptorsCache.computeIfAbsent(Tuple2.of(clz, searchParent), t -> Descriptor.getAllDescriptorsMap(clz, searchParent));
    }

    public boolean needToWriteRef(Class<?> cls) {
        if (this.fury.trackingRef()) {
            ClassInfo classInfo = this.getClassInfo(cls, false);
            if (classInfo == null || classInfo.serializer == null) {
                return !cls.isEnum();
            }
            return classInfo.serializer.needToWriteRef();
        }
        return false;
    }

    public ClassInfo getClassInfo(short classId) {
        ClassInfo classInfo = this.registeredId2ClassInfo[classId];
        if (classInfo.serializer == null) {
            this.addSerializer(classInfo.cls, this.createSerializer(classInfo.cls));
            classInfo = this.classInfoMap.get(classInfo.cls);
        }
        return classInfo;
    }

    public ClassInfo getClassInfo(Class<?> cls) {
        ClassInfo classInfo = this.classInfoMap.get(cls);
        if (classInfo == null || classInfo.serializer == null) {
            this.addSerializer(cls, this.createSerializer(cls));
            classInfo = this.classInfoMap.get(cls);
        }
        return classInfo;
    }

    public ClassInfo getClassInfo(Class<?> cls, ClassInfoHolder classInfoHolder) {
        ClassInfo classInfo = classInfoHolder.classInfo;
        if (classInfo.getCls() != cls) {
            classInfo = this.classInfoMap.get(cls);
            if (classInfo == null || classInfo.serializer == null) {
                this.addSerializer(cls, this.createSerializer(cls));
                classInfo = Objects.requireNonNull(this.classInfoMap.get(cls));
            }
            classInfoHolder.classInfo = classInfo;
        }
        assert (classInfo.serializer != null);
        return classInfo;
    }

    public ClassInfo getClassInfo(Class<?> cls, boolean createClassInfoIfNotFound) {
        if (createClassInfoIfNotFound) {
            return this.getOrUpdateClassInfo(cls);
        }
        if (this.extRegistry.getClassCtx.contains(cls)) {
            return null;
        }
        return this.classInfoMap.get(cls);
    }

    @Internal
    public ClassInfo getOrUpdateClassInfo(Class<?> cls) {
        ClassInfo classInfo = this.classInfoCache;
        if (classInfo.cls != cls) {
            classInfo = this.classInfoMap.get(cls);
            if (classInfo == null || classInfo.serializer == null) {
                this.addSerializer(cls, this.createSerializer(cls));
                classInfo = this.classInfoMap.get(cls);
            }
            this.classInfoCache = classInfo;
        }
        return classInfo;
    }

    private ClassInfo getOrUpdateClassInfo(short classId) {
        ClassInfo classInfo = this.classInfoCache;
        if (classInfo.classId != classId) {
            classInfo = this.registeredId2ClassInfo[classId];
            if (classInfo.serializer == null) {
                this.addSerializer(classInfo.cls, this.createSerializer(classInfo.cls));
                classInfo = this.classInfoMap.get(classInfo.cls);
            }
            this.classInfoCache = classInfo;
        }
        return classInfo;
    }

    public <T> Serializer<T> createSerializerSafe(Class<T> cls, Supplier<Serializer<T>> func) {
        Serializer<T> serializer = this.fury.getClassResolver().getSerializer(cls, false);
        try {
            return func.get();
        }
        catch (Throwable t) {
            this.resetSerializer(cls, serializer);
            Platform.throwException(t);
            throw new IllegalStateException("unreachable");
        }
    }

    private Serializer createSerializer(Class<?> cls) {
        Serializer serializer;
        if (!this.extRegistry.registeredClassIdMap.containsKey(cls) && !this.shimDispatcher.contains(cls)) {
            String msg = String.format("%s is not registered, please check whether it's the type you want to serialize or a **vulnerability**. If safe, you should invoke `Fury#register` to register class,  which will have better performance by skipping classname serialization. If your env is 100%% secure, you can also avoid this exception by disabling class registration check using `FuryBuilder#requireClassRegistration(false)`", cls);
            boolean forbidden = BlackList.getDefaultBlackList().contains(cls.getName());
            if (forbidden || !this.isSecure(this.extRegistry.registeredClassIdMap, cls)) {
                throw new InsecureException(msg);
            }
            if (!(this.fury.getConfig().suppressClassRegistrationWarnings() || Functions.isLambda(cls) || ReflectionUtils.isJdkProxy(cls))) {
                LOG.warn(msg);
            }
        }
        if (this.extRegistry.serializerFactory != null && (serializer = this.extRegistry.serializerFactory.createSerializer(this.fury, cls)) != null) {
            return serializer;
        }
        Serializer<?> shimSerializer = this.shimDispatcher.getSerializer(cls);
        if (shimSerializer != null) {
            return shimSerializer;
        }
        Class<? extends Serializer> serializerClass = this.getSerializerClass(cls);
        return Serializers.newSerializer(this.fury, cls, serializerClass);
    }

    private boolean isSecure(IdentityMap<Class<?>, Short> registeredClasses, Class<?> cls) {
        if (BlackList.getDefaultBlackList().contains(cls.getName())) {
            return false;
        }
        if (registeredClasses.containsKey(cls)) {
            return true;
        }
        if (cls.isArray()) {
            return this.isSecure(registeredClasses, TypeUtils.getArrayComponent(cls));
        }
        if (this.fury.getConfig().requireClassRegistration()) {
            return Functions.isLambda(cls) || ReflectionUtils.isJdkProxy(cls);
        }
        return this.extRegistry.classChecker.checkClass(this, cls.getName());
    }

    public void writeClassAndUpdateCache(MemoryBuffer buffer, Class<?> cls) {
        if (cls == Integer.class) {
            buffer.writePositiveVarInt(36);
        } else if (cls == Long.class) {
            buffer.writePositiveVarInt(40);
        } else {
            this.writeClass(buffer, this.getOrUpdateClassInfo(cls));
        }
    }

    public void writeClass(MemoryBuffer buffer, ClassInfo classInfo) {
        if (classInfo.classId == 0) {
            buffer.writeByte((byte)1);
            if (this.metaContextShareEnabled) {
                this.writeClassWithMetaShare(buffer, classInfo);
            } else {
                assert (classInfo.packageNameBytes != null);
                this.enumStringResolver.writeEnumStringBytes(buffer, classInfo.packageNameBytes);
                assert (classInfo.classNameBytes != null);
                this.enumStringResolver.writeEnumStringBytes(buffer, classInfo.classNameBytes);
            }
        } else {
            buffer.writePositiveVarInt(classInfo.classId << 1);
        }
    }

    public void writeClassWithMetaShare(MemoryBuffer buffer, ClassInfo classInfo) {
        MetaContext metaContext = this.fury.getSerializationContext().getMetaContext();
        Preconditions.checkNotNull(metaContext, "Meta context must be set before serialization, please set meta context by SerializationContext.setMetaContext");
        IdentityObjectIntMap<Class<?>> classMap = metaContext.classMap;
        int newId = classMap.size;
        int id = classMap.putOrGet(classInfo.cls, newId);
        if (id >= 0) {
            buffer.writePositiveVarInt(id);
        } else {
            buffer.writePositiveVarInt(newId);
            Serializer<?> serializer = classInfo.serializer;
            Preconditions.checkArgument(serializer.getClass() != UnexistedClassSerializers.UnexistedClassSerializer.class);
            ClassDef classDef = this.fury.getConfig().getCompatibleMode() == CompatibleMode.COMPATIBLE && (serializer instanceof Generated.GeneratedObjectSerializer || serializer instanceof Generated.GeneratedMetaSharedSerializer || serializer instanceof CodegenSerializer.LazyInitBeanSerializer || serializer instanceof ObjectSerializer || serializer instanceof MetaSharedSerializer) ? this.classDefMap.computeIfAbsent(classInfo.cls, cls -> ClassDef.buildClassDef(cls, this.fury)) : this.classDefMap.computeIfAbsent(classInfo.cls, cls -> ClassDef.buildClassDef(this, cls, new ArrayList<Field>(), (Map<String, String>)ImmutableMap.of((Object)META_SHARE_FIELDS_INFO_KEY, (Object)"false")));
            metaContext.writingClassDefs.add(classDef);
        }
    }

    private Class<?> readClassWithMetaShare(MemoryBuffer buffer) {
        MetaContext metaContext = this.fury.getSerializationContext().getMetaContext();
        Preconditions.checkNotNull(metaContext, "Meta context must be set before serialization, please set meta context by SerializationContext.setMetaContext");
        int id = buffer.readPositiveVarInt();
        List<ClassInfo> readClassInfos = metaContext.readClassInfos;
        ClassInfo classInfo = readClassInfos.get(id);
        if (classInfo == null) {
            List<ClassDef> readClassDefs = metaContext.readClassDefs;
            ClassDef classDef = readClassDefs.get(id);
            Class<?> cls = this.loadClass(classDef.getClassName());
            classInfo = this.getClassInfo(cls, false);
            if (classInfo == null) {
                Short classId = (Short)this.extRegistry.registeredClassIdMap.get(cls);
                classInfo = new ClassInfo(this, cls, null, null, classId == null ? (short)0 : classId);
                this.classInfoMap.put(cls, classInfo);
            }
            readClassInfos.set(id, classInfo);
        }
        return classInfo.cls;
    }

    private ClassInfo readClassInfoWithMetaShare(MemoryBuffer buffer, MetaContext metaContext) {
        Preconditions.checkNotNull(metaContext, "Meta context must be set before serialization, please set meta context by SerializationContext.setMetaContext");
        int id = buffer.readPositiveVarInt();
        List<ClassInfo> readClassInfos = metaContext.readClassInfos;
        ClassInfo classInfo = readClassInfos.get(id);
        if (classInfo == null) {
            List<ClassDef> readClassDefs = metaContext.readClassDefs;
            ClassDef classDef = readClassDefs.get(id);
            if ("false".equals(classDef.getExtMeta().getOrDefault(META_SHARE_FIELDS_INFO_KEY, ""))) {
                Class<?> cls = this.loadClass(classDef.getClassName());
                classInfo = this.getClassInfo(cls);
            } else {
                Tuple2 classDefTuple = (Tuple2)this.extRegistry.classIdToDef.get(classDef.getId());
                if (classDefTuple == null || classDefTuple.f1 == null) {
                    if (classDefTuple != null) {
                        classDef = (ClassDef)classDefTuple.f0;
                    }
                    Class<?> cls = this.loadClass(classDef.getClassName());
                    classInfo = this.getMetaSharedClassInfo(classDef, cls);
                    this.extRegistry.classIdToDef.put(classDef.getId(), Tuple2.of(classDef, classInfo));
                } else {
                    classInfo = (ClassInfo)classDefTuple.f1;
                }
            }
            readClassInfos.set(id, classInfo);
        }
        return classInfo;
    }

    private ClassInfo getMetaSharedClassInfo(ClassDef classDef, Class<?> clz) {
        if (clz == UnexistedClassSerializers.UnexistedSkipClass.class) {
            clz = UnexistedClassSerializers.UnexistedMetaSharedClass.class;
        }
        Class<?> cls = clz;
        Short classId = (Short)this.extRegistry.registeredClassIdMap.get(cls);
        ClassInfo classInfo = new ClassInfo(this, cls, null, null, classId == null ? (short)0 : classId);
        if (cls == UnexistedClassSerializers.UnexistedMetaSharedClass.class) {
            classInfo.serializer = new UnexistedClassSerializers.UnexistedClassSerializer(this.fury, classDef);
            Preconditions.checkNotNull(classId);
            return classInfo;
        }
        Class sc = this.fury.getJITContext().registerSerializerJITCallback(() -> MetaSharedSerializer.class, () -> CodecUtils.loadOrGenMetaSharedCodecClass(this.fury, cls, classDef), c -> {
            classInfo.serializer = Serializers.newSerializer(this.fury, cls, c);
        });
        classInfo.serializer = sc == MetaSharedSerializer.class ? new MetaSharedSerializer(this.fury, cls, classDef) : Serializers.newSerializer(this.fury, cls, sc);
        return classInfo;
    }

    public void writeClassDefs(MemoryBuffer buffer) {
        MetaContext metaContext = this.fury.getSerializationContext().getMetaContext();
        buffer.writePositiveVarInt(metaContext.writingClassDefs.size());
        for (ClassDef classDef : metaContext.writingClassDefs) {
            classDef.writeClassDef(buffer);
        }
        metaContext.writingClassDefs.clear();
    }

    public void readClassDefs(MemoryBuffer buffer) {
        MetaContext metaContext = this.fury.getSerializationContext().getMetaContext();
        int classDefOffset = buffer.readInt();
        int readerIndex = buffer.readerIndex();
        buffer.readerIndex(classDefOffset);
        int numClassDefs = buffer.readPositiveVarInt();
        for (int i = 0; i < numClassDefs; ++i) {
            ClassDef readClassDef = ClassDef.readClassDef(buffer);
            ClassDef classDef = (ClassDef)((ExtRegistry)this.extRegistry).classIdToDef.computeIfAbsent(Long.valueOf((long)readClassDef.getId()), (Function<Long, Tuple2>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$readClassDefs$11(io.fury.type.ClassDef java.lang.Long ), (Ljava/lang/Long;)Lio/fury/collection/Tuple2;)((ClassDef)readClassDef)).f0;
            metaContext.readClassDefs.add(classDef);
            metaContext.readClassInfos.add(null);
        }
        buffer.readerIndex(readerIndex);
    }

    public Expression writeClassExpr(Expression classResolverRef, Expression buffer, Expression classInfo) {
        Expression.Invoke classId = new Expression.Invoke(classInfo, "getClassId", TypeUtils.PRIMITIVE_SHORT_TYPE);
        Expression.ListExpression writeUnregistered = new Expression.ListExpression(new Expression.Invoke(buffer, "writeByte", Expression.Literal.ofByte((short)1)));
        if (this.metaContextShareEnabled) {
            writeUnregistered.add(new Expression.Invoke(classResolverRef, "writeClassWithMetaShare", buffer, classInfo));
        } else {
            writeUnregistered.add(new Expression.Invoke(classResolverRef, "writeEnumStringBytes", buffer, Expression.Invoke.inlineInvoke(classInfo, "getPackageNameBytes", TypeToken.of(EnumStringBytes.class), new Expression[0])), new Expression.Invoke(classResolverRef, "writeEnumStringBytes", buffer, Expression.Invoke.inlineInvoke(classInfo, "getClassNameBytes", TypeToken.of(EnumStringBytes.class), new Expression[0])));
        }
        return new Expression.If(ExpressionUtils.eq(classId, Expression.Literal.ofShort((short)0)), writeUnregistered, this.writeClassExpr(buffer, classId));
    }

    public Expression writeClassExpr(Expression buffer, short classId) {
        Preconditions.checkArgument(classId != 0);
        return this.writeClassExpr(buffer, Expression.Literal.ofShort(classId));
    }

    public Expression writeClassExpr(Expression buffer, Expression classId) {
        return new Expression.Invoke(buffer, "writePositiveVarInt", new Expression.BitShift("<<", classId, 1));
    }

    public void writeEnumStringBytes(MemoryBuffer buffer, EnumStringBytes byteString) {
        this.enumStringResolver.writeEnumStringBytes(buffer, byteString);
    }

    public Expression skipRegisteredClassExpr(Expression buffer) {
        return new Expression.Invoke(buffer, "readPositiveVarInt", new Expression[0]);
    }

    public void writeClassInternal(MemoryBuffer buffer, Class<?> cls) {
        short classId;
        ClassInfo classInfo = this.classInfoMap.get(cls);
        if (classInfo == null) {
            Short classId2 = (Short)this.extRegistry.registeredClassIdMap.get(cls);
            classInfo = new ClassInfo(this, cls, null, null, classId2 == null ? (short)0 : classId2);
            this.classInfoMap.put(cls, classInfo);
        }
        if ((classId = classInfo.classId) == 3) {
            classInfo.classId = 0;
        }
        this.writeClass(buffer, classInfo);
        classInfo.classId = classId;
    }

    public Class<?> readClassInternal(MemoryBuffer buffer) {
        byte flag = buffer.readByte();
        if (flag == 1) {
            if (this.metaContextShareEnabled) {
                return this.readClassWithMetaShare(buffer);
            }
            EnumStringBytes packageBytes = this.enumStringResolver.readEnumStringBytes(buffer);
            EnumStringBytes simpleClassNameBytes = this.enumStringResolver.readEnumStringBytes(buffer);
            Class<?> cls = this.loadBytesToClass(packageBytes, simpleClassNameBytes);
            this.currentReadClass = cls;
            return cls;
        }
        short classId = ClassResolver.readClassId(buffer, flag);
        ClassInfo classInfo = this.registeredId2ClassInfo[classId];
        Class<?> cls = classInfo.cls;
        this.currentReadClass = cls;
        return cls;
    }

    public ClassInfo readClassInfo(MemoryBuffer buffer) {
        byte flag = buffer.readByte();
        if (flag == 1) {
            ClassInfo classInfo = this.metaContextShareEnabled ? this.readClassInfoWithMetaShare(buffer, this.fury.getSerializationContext().getMetaContext()) : this.readClassInfoFromBytes(buffer, this.classInfoCache);
            this.classInfoCache = classInfo;
            this.currentReadClass = classInfo.cls;
            return classInfo;
        }
        short classId = ClassResolver.readClassId(buffer, flag);
        ClassInfo classInfo = this.getOrUpdateClassInfo(classId);
        this.currentReadClass = classInfo.cls;
        return classInfo;
    }

    public ClassInfo readClassInfo(MemoryBuffer buffer, ClassInfo classInfoCache) {
        byte flag = buffer.readByte();
        if (flag == 1) {
            if (this.metaContextShareEnabled) {
                return this.readClassInfoWithMetaShare(buffer, this.fury.getSerializationContext().getMetaContext());
            }
            return this.readClassInfoFromBytes(buffer, classInfoCache);
        }
        short classId = ClassResolver.readClassId(buffer, flag);
        return this.getClassInfo(classId);
    }

    public ClassInfo readClassInfo(MemoryBuffer buffer, ClassInfoHolder classInfoHolder) {
        byte flag = buffer.readByte();
        if (flag == 1) {
            if (this.metaContextShareEnabled) {
                return this.readClassInfoWithMetaShare(buffer, this.fury.getSerializationContext().getMetaContext());
            }
            return this.readClassInfoFromBytes(buffer, classInfoHolder);
        }
        short classId = ClassResolver.readClassId(buffer, flag);
        return this.getClassInfo(classId);
    }

    private static short readClassId(MemoryBuffer buffer, byte flag) {
        short classId;
        if ((flag & 0x80) != 0) {
            buffer.increaseReaderIndexUnsafe(-1);
            classId = (short)buffer.readPositiveVarInt();
        } else {
            classId = (short)(flag & 0x7F);
        }
        classId = (short)(classId >> 1);
        return classId;
    }

    private ClassInfo readClassInfoFromBytes(MemoryBuffer buffer, ClassInfoHolder classInfoHolder) {
        ClassInfo classInfo;
        classInfoHolder.classInfo = classInfo = this.readClassInfoFromBytes(buffer, classInfoHolder.classInfo);
        return classInfo;
    }

    private ClassInfo readClassInfoFromBytes(MemoryBuffer buffer, ClassInfo classInfoCache) {
        EnumStringBytes simpleClassNameBytesCache = classInfoCache.classNameBytes;
        if (simpleClassNameBytesCache != null) {
            EnumStringBytes packageNameBytesCache = classInfoCache.packageNameBytes;
            EnumStringBytes packageBytes = this.enumStringResolver.readEnumStringBytes(buffer, packageNameBytesCache);
            assert (packageNameBytesCache != null);
            EnumStringBytes simpleClassNameBytes = this.enumStringResolver.readEnumStringBytes(buffer, simpleClassNameBytesCache);
            if (simpleClassNameBytesCache.hashCode == simpleClassNameBytes.hashCode && packageNameBytesCache.hashCode == packageBytes.hashCode) {
                return classInfoCache;
            }
            Class<?> cls = this.loadBytesToClass(packageBytes, simpleClassNameBytes);
            return this.getClassInfo(cls);
        }
        EnumStringBytes packageBytes = this.enumStringResolver.readEnumStringBytes(buffer);
        EnumStringBytes simpleClassNameBytes = this.enumStringResolver.readEnumStringBytes(buffer);
        Class<?> cls = this.loadBytesToClass(packageBytes, simpleClassNameBytes);
        return this.getClassInfo(cls);
    }

    private Class<?> loadBytesToClass(EnumStringBytes packageBytes, EnumStringBytes simpleClassNameBytes) {
        ClassNameBytes classNameBytes = new ClassNameBytes(packageBytes.hashCode, simpleClassNameBytes.hashCode);
        Class<?> cls = (Class<?>)this.compositeClassNameBytes2Class.get(classNameBytes);
        if (cls == null) {
            String packageName = new String(packageBytes.bytes, StandardCharsets.UTF_8);
            String className = new String(simpleClassNameBytes.bytes, StandardCharsets.UTF_8);
            String entireClassName = StringUtils.isBlank(packageName) ? className : packageName + "." + className;
            cls = this.loadClass(entireClassName);
            this.compositeClassNameBytes2Class.put(classNameBytes, cls);
        }
        return cls;
    }

    public void xwriteClass(MemoryBuffer buffer, Class<?> cls) {
        this.enumStringResolver.writeEnumStringBytes(buffer, this.getOrUpdateClassInfo(cls).fullClassNameBytes);
    }

    public void xwriteTypeTag(MemoryBuffer buffer, Class<?> cls) {
        this.enumStringResolver.writeEnumStringBytes(buffer, this.getOrUpdateClassInfo(cls).typeTagBytes);
    }

    public Class<?> xreadClass(MemoryBuffer buffer) {
        EnumStringBytes byteString = this.enumStringResolver.readEnumStringBytes(buffer);
        Class<?> cls = (Class<?>)this.classNameBytes2Class.get(byteString);
        if (cls == null) {
            Preconditions.checkNotNull(byteString);
            String className = new String(byteString.bytes, StandardCharsets.UTF_8);
            cls = this.loadClass(className);
            this.classNameBytes2Class.put(byteString, cls);
        }
        this.currentReadClass = cls;
        return cls;
    }

    public String xreadClassName(MemoryBuffer buffer) {
        return this.enumStringResolver.readEnumString(buffer);
    }

    public Class<?> getCurrentReadClass() {
        return this.currentReadClass;
    }

    private Class<?> loadClass(String className) {
        this.extRegistry.classChecker.checkClass(this, className);
        try {
            return Class.forName(className, false, this.fury.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(className, false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException ex) {
                String msg = String.format("Class %s not found from classloaders [%s, %s]", className, this.fury.getClassLoader(), Thread.currentThread().getContextClassLoader());
                if (this.fury.getConfig().deserializeUnexistedClass()) {
                    LOG.error(msg, (Throwable)e);
                    return UnexistedClassSerializers.UnexistedSkipClass.class;
                }
                throw new IllegalStateException(msg, ex);
            }
        }
    }

    public void reset() {
        this.resetRead();
        this.resetWrite();
    }

    public void resetRead() {
    }

    public void resetWrite() {
    }

    public Class<?> getClassByTypeId(short typeId) {
        return this.typeIdToClassXLangMap.get(typeId);
    }

    public Class<?> readClassByTypeTag(MemoryBuffer buffer) {
        String tag = this.enumStringResolver.readEnumString(buffer);
        return this.typeTagToClassXLangMap.get(tag);
    }

    public GenericType buildGenericType(TypeToken<?> typeToken) {
        return GenericType.build(typeToken.getType(), t -> {
            if (t.getClass() == Class.class) {
                return this.isFinal((Class)t);
            }
            return this.isFinal(TypeUtils.getRawType(t));
        });
    }

    public GenericType buildGenericType(Type type) {
        return GenericType.build(type, t -> {
            if (t.getClass() == Class.class) {
                return this.isFinal((Class)t);
            }
            return this.isFinal(TypeUtils.getRawType(t));
        });
    }

    public GenericType getObjectGenericType() {
        return this.extRegistry.objectGenericType;
    }

    public ClassInfo newClassInfo(Class<?> cls, Serializer<?> serializer, short classId) {
        return new ClassInfo(this, cls, null, serializer, classId);
    }

    public ClassInfo nilClassInfo() {
        return new ClassInfo(this, null, null, null, 0);
    }

    public ClassInfoHolder nilClassInfoHolder() {
        return new ClassInfoHolder(this.nilClassInfo());
    }

    public boolean isPrimitive(short classId) {
        return classId >= 4 && classId <= 12;
    }

    public EnumStringResolver getEnumStringResolver() {
        return this.enumStringResolver;
    }

    public Fury getFury() {
        return this.fury;
    }

    public static void _addGraalvmClassRegistry(int furyConfigHash, ClassResolver classResolver) {
        if (GraalvmSupport.isGraalBuildtime()) {
            List resolvers = GRAALVM_REGISTRY.computeIfAbsent(furyConfigHash, k -> Collections.synchronizedList(new ArrayList()));
            resolvers.add(classResolver);
        }
    }

    private Class<? extends Serializer> getSerializerClassFromGraalvmRegistry(Class<?> cls) {
        List classResolvers = (List)GRAALVM_REGISTRY.get(this.fury.getConfig().getConfigHash());
        if (classResolvers == null || classResolvers.isEmpty()) {
            return null;
        }
        for (ClassResolver classResolver : classResolvers) {
            ClassInfo classInfo;
            if (classResolver == this || (classInfo = classResolver.classInfoMap.get(cls)) == null) continue;
            return classInfo.serializer.getClass();
        }
        if (GraalvmSupport.isGraalRuntime()) {
            throw new RuntimeException(String.format("Class %s is not registered", cls));
        }
        return null;
    }

    private static /* synthetic */ Tuple2 lambda$readClassDefs$11(ClassDef readClassDef, Long key) {
        return Tuple2.of(readClassDef, null);
    }

    private static class ExtRegistry {
        private short registeredClassIdCounter = 0;
        private final LongMap<Class<?>> registeredId2Classes = new LongMap(128);
        private SerializerFactory serializerFactory;
        private final IdentityMap<Class<?>, Short> registeredClassIdMap = new IdentityMap(128);
        private final Map<String, Class<?>> registeredClasses = new HashMap(128);
        private final Set<Class<?>> getClassCtx = new HashSet();
        private final Map<Class<?>, FieldResolver> fieldResolverMap = new HashMap();
        private final Map<Long, Tuple2<ClassDef, ClassInfo>> classIdToDef = new HashMap<Long, Tuple2<ClassDef, ClassInfo>>();
        private final ConcurrentHashMap<Tuple2<Class<?>, Boolean>, SortedMap<Field, Descriptor>> descriptorsCache = new ConcurrentHashMap();
        private ClassChecker classChecker = (classResolver, className) -> true;
        private GenericType objectGenericType;

        private ExtRegistry() {
        }

        static /* synthetic */ short access$208(ExtRegistry x0) {
            short s = x0.registeredClassIdCounter;
            x0.registeredClassIdCounter = (short)(s + 1);
            return s;
        }
    }

    private static class ClassNameBytes {
        private final long packageHash;
        private final long classNameHash;

        private ClassNameBytes(long packageHash, long classNameHash) {
            this.packageHash = packageHash;
            this.classNameHash = classNameHash;
        }

        public boolean equals(Object o) {
            ClassNameBytes that = (ClassNameBytes)o;
            return this.packageHash == that.packageHash && this.classNameHash == that.classNameHash;
        }

        public int hashCode() {
            int result = 31 + (int)(this.packageHash ^ this.packageHash >>> 32);
            result = result * 31 + (int)(this.classNameHash ^ this.classNameHash >>> 32);
            return result;
        }
    }
}

