/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TranslogStats
implements JsonpSerializable {
    private final long earliestLastModifiedAge;
    private final long operations;
    @Nullable
    private final String size;
    private final long sizeInBytes;
    private final int uncommittedOperations;
    @Nullable
    private final String uncommittedSize;
    private final long uncommittedSizeInBytes;
    public static final JsonpDeserializer<TranslogStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TranslogStats::setupTranslogStatsDeserializer);

    private TranslogStats(Builder builder) {
        this.earliestLastModifiedAge = ApiTypeHelper.requireNonNull(builder.earliestLastModifiedAge, this, "earliestLastModifiedAge");
        this.operations = ApiTypeHelper.requireNonNull(builder.operations, this, "operations");
        this.size = builder.size;
        this.sizeInBytes = ApiTypeHelper.requireNonNull(builder.sizeInBytes, this, "sizeInBytes");
        this.uncommittedOperations = ApiTypeHelper.requireNonNull(builder.uncommittedOperations, this, "uncommittedOperations");
        this.uncommittedSize = builder.uncommittedSize;
        this.uncommittedSizeInBytes = ApiTypeHelper.requireNonNull(builder.uncommittedSizeInBytes, this, "uncommittedSizeInBytes");
    }

    public static TranslogStats of(Function<Builder, ObjectBuilder<TranslogStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long earliestLastModifiedAge() {
        return this.earliestLastModifiedAge;
    }

    public final long operations() {
        return this.operations;
    }

    @Nullable
    public final String size() {
        return this.size;
    }

    public final long sizeInBytes() {
        return this.sizeInBytes;
    }

    public final int uncommittedOperations() {
        return this.uncommittedOperations;
    }

    @Nullable
    public final String uncommittedSize() {
        return this.uncommittedSize;
    }

    public final long uncommittedSizeInBytes() {
        return this.uncommittedSizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("earliest_last_modified_age");
        generator.write(this.earliestLastModifiedAge);
        generator.writeKey("operations");
        generator.write(this.operations);
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size);
        }
        generator.writeKey("size_in_bytes");
        generator.write(this.sizeInBytes);
        generator.writeKey("uncommitted_operations");
        generator.write(this.uncommittedOperations);
        if (this.uncommittedSize != null) {
            generator.writeKey("uncommitted_size");
            generator.write(this.uncommittedSize);
        }
        generator.writeKey("uncommitted_size_in_bytes");
        generator.write(this.uncommittedSizeInBytes);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTranslogStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::earliestLastModifiedAge, JsonpDeserializer.longDeserializer(), "earliest_last_modified_age");
        op.add(Builder::operations, JsonpDeserializer.longDeserializer(), "operations");
        op.add(Builder::size, JsonpDeserializer.stringDeserializer(), "size");
        op.add(Builder::sizeInBytes, JsonpDeserializer.longDeserializer(), "size_in_bytes");
        op.add(Builder::uncommittedOperations, JsonpDeserializer.integerDeserializer(), "uncommitted_operations");
        op.add(Builder::uncommittedSize, JsonpDeserializer.stringDeserializer(), "uncommitted_size");
        op.add(Builder::uncommittedSizeInBytes, JsonpDeserializer.longDeserializer(), "uncommitted_size_in_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TranslogStats> {
        private Long earliestLastModifiedAge;
        private Long operations;
        @Nullable
        private String size;
        private Long sizeInBytes;
        private Integer uncommittedOperations;
        @Nullable
        private String uncommittedSize;
        private Long uncommittedSizeInBytes;

        public final Builder earliestLastModifiedAge(long value) {
            this.earliestLastModifiedAge = value;
            return this;
        }

        public final Builder operations(long value) {
            this.operations = value;
            return this;
        }

        public final Builder size(@Nullable String value) {
            this.size = value;
            return this;
        }

        public final Builder sizeInBytes(long value) {
            this.sizeInBytes = value;
            return this;
        }

        public final Builder uncommittedOperations(int value) {
            this.uncommittedOperations = value;
            return this;
        }

        public final Builder uncommittedSize(@Nullable String value) {
            this.uncommittedSize = value;
            return this;
        }

        public final Builder uncommittedSizeInBytes(long value) {
            this.uncommittedSizeInBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TranslogStats build() {
            this._checkSingleUse();
            return new TranslogStats(this);
        }
    }
}

