/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.registry.support.command;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.weibo.api.motan.registry.support.command.RpcCommand;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RpcCommandUtil {
    private static PatternEvaluator evaluator = new PatternEvaluator();

    public static RpcCommand stringToCommand(String commandString) {
        try {
            RpcCommand rpcCommand = (RpcCommand)JSONObject.parseObject((String)commandString, RpcCommand.class);
            if (rpcCommand != null) {
                rpcCommand.sort();
            }
            return rpcCommand;
        }
        catch (Exception e) {
            LoggerUtil.error("\u6307\u4ee4\u914d\u7f6e\u9519\u8bef\uff1a\u4e0d\u662f\u5408\u6cd5\u7684JSON\u683c\u5f0f!");
            return null;
        }
    }

    public static String commandToString(RpcCommand command) {
        if (command == null) {
            return null;
        }
        return JSONObject.toJSONString((Object)command);
    }

    public static boolean match(String expression, String path) {
        if (expression == null || expression.length() == 0) {
            return false;
        }
        return evaluator.match(expression, path);
    }

    private static class PatternEvaluator {
        Pattern pattern = Pattern.compile("[a-zA-Z0-9_$.*]+");
        Set<Character> all = ImmutableSet.of((Object)Character.valueOf('('), (Object)Character.valueOf(')'), (Object)Character.valueOf('0'), (Object)Character.valueOf('1'), (Object)Character.valueOf('!'), (Object)Character.valueOf('&'), (Object[])new Character[]{Character.valueOf('|')});
        Map<Character, ImmutableSet<Character>> following = ImmutableMap.builder().put((Object)Character.valueOf('('), (Object)ImmutableSet.of((Object)Character.valueOf('0'), (Object)Character.valueOf('1'), (Object)Character.valueOf('!'))).put((Object)Character.valueOf(')'), (Object)ImmutableSet.of((Object)Character.valueOf('|'), (Object)Character.valueOf('&'), (Object)Character.valueOf(')'))).put((Object)Character.valueOf('0'), (Object)ImmutableSet.of((Object)Character.valueOf('|'), (Object)Character.valueOf('&'), (Object)Character.valueOf(')'))).put((Object)Character.valueOf('1'), (Object)ImmutableSet.of((Object)Character.valueOf('|'), (Object)Character.valueOf('&'), (Object)Character.valueOf(')'))).put((Object)Character.valueOf('!'), (Object)ImmutableSet.of((Object)Character.valueOf('('), (Object)Character.valueOf('0'), (Object)Character.valueOf('1'), (Object)Character.valueOf('!'))).put((Object)Character.valueOf('&'), (Object)ImmutableSet.of((Object)Character.valueOf('('), (Object)Character.valueOf('0'), (Object)Character.valueOf('1'), (Object)Character.valueOf('!'))).put((Object)Character.valueOf('|'), (Object)ImmutableSet.of((Object)Character.valueOf('('), (Object)Character.valueOf('0'), (Object)Character.valueOf('1'), (Object)Character.valueOf('!'))).build();

        private PatternEvaluator() {
        }

        boolean match(String expression, String path) {
            Matcher matcher = this.pattern.matcher(expression.replaceAll("\\s+", ""));
            StringBuffer buffer = new StringBuffer();
            while (matcher.find()) {
                String s = matcher.group();
                int idx = s.indexOf(42);
                if (idx != -1) {
                    matcher.appendReplacement(buffer, path.startsWith(s.substring(0, idx)) ? "1" : "0");
                    continue;
                }
                matcher.appendReplacement(buffer, s.equals(path) ? "1" : "0");
            }
            matcher.appendTail(buffer);
            String result1 = buffer.toString();
            LinkedList<LinkedList> outer = new LinkedList<LinkedList>();
            LinkedList<Character> inner = new LinkedList<Character>();
            inner.push(Character.valueOf('#'));
            outer.push(inner);
            int i = 0;
            int len = result1.length();
            while (outer.size() > 0 && i < len) {
                LinkedList sub = (LinkedList)outer.peekLast();
                block6: while (sub.size() > 0 && i < len) {
                    char curr = result1.charAt(i++);
                    this.support(curr);
                    char prev = ((Character)sub.peekFirst()).charValue();
                    if (prev != '#') {
                        this.supportFollowing(prev, curr);
                    }
                    switch (curr) {
                        case '(': {
                            sub = new LinkedList();
                            sub.push(Character.valueOf('#'));
                            outer.push(sub);
                            continue block6;
                        }
                        case ')': {
                            outer.removeFirst();
                            ((LinkedList)outer.peekFirst()).push(Character.valueOf(this.evalWithinParentheses(sub)));
                            sub = (LinkedList)outer.peekFirst();
                            continue block6;
                        }
                    }
                    sub.push(Character.valueOf(curr));
                }
            }
            if (outer.size() != 1) {
                throw new IllegalArgumentException("\u8bed\u6cd5\u9519\u8bef, \u53ef\u80fd\u5706\u62ec\u53f7\u6ca1\u6709\u95ed\u5408");
            }
            char result = this.evalWithinParentheses((LinkedList)outer.peekLast());
            return result == '1';
        }

        char evalWithinParentheses(LinkedList<Character> list) {
            int curr;
            int operand = list.pop().charValue();
            if (operand != 48 && operand != 49) {
                this.syntaxError();
            }
            while (!list.isEmpty()) {
                curr = list.pop().charValue();
                if (curr == 33) {
                    operand = operand == 48 ? 49 : 48;
                    continue;
                }
                if (curr == 35) break;
                if (operand == 48 || operand == 49) {
                    list.addLast(Character.valueOf((char)operand));
                    list.addLast(Character.valueOf((char)curr));
                    operand = 0;
                    continue;
                }
                operand = curr;
            }
            list.addLast(Character.valueOf((char)operand));
            list.addLast(Character.valueOf('#'));
            operand = list.pop().charValue();
            while (!list.isEmpty()) {
                curr = list.pop().charValue();
                if (curr == 38) {
                    char c = list.pop().charValue();
                    operand = operand == 49 && c == '1' ? 49 : 48;
                    continue;
                }
                if (curr == 35) break;
                if (operand == 48 || operand == 49) {
                    list.addLast(Character.valueOf((char)operand));
                    list.addLast(Character.valueOf((char)curr));
                    operand = 0;
                    continue;
                }
                operand = curr;
            }
            list.addLast(Character.valueOf((char)operand));
            operand = 48;
            while (!list.isEmpty() && (operand = list.pop().charValue()) != 49) {
            }
            return (char)operand;
        }

        void syntaxError() {
            throw new IllegalArgumentException("\u8bed\u6cd5\u9519\u8bef, \u4ec5\u652f\u6301\u62ec\u53f7(),\u975e!,\u4e0e&,\u6216|\u8fd9\u51e0\u4e2a\u8fd0\u7b97\u7b26, \u4f18\u5148\u7ea7\u4f9d\u6b21\u9012\u51cf.");
        }

        void syntaxError(String s) {
            throw new IllegalArgumentException("\u8bed\u6cd5\u9519\u8bef: " + s);
        }

        void support(char c) {
            if (!this.all.contains(Character.valueOf(c))) {
                this.syntaxError("\u4e0d\u652f\u6301\u5b57\u7b26 " + c);
            }
        }

        void supportFollowing(char prev, char c) {
            if (!this.following.get(Character.valueOf(prev)).contains((Object)Character.valueOf(c))) {
                this.syntaxError("prev=" + prev + ", c=" + c);
            }
        }
    }
}

