/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.ClaimsMutator;
import io.jsonwebtoken.impl.AbstractAudienceCollection;
import io.jsonwebtoken.impl.DefaultClaims;
import io.jsonwebtoken.impl.ParameterMap;
import io.jsonwebtoken.impl.lang.DelegatingMapMutator;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.lang.Parameters;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.MapMutator;
import io.jsonwebtoken.lang.Strings;
import java.util.Date;
import java.util.Set;

public class DelegatingClaimsMutator<T extends MapMutator<String, Object, T> & ClaimsMutator<T>>
extends DelegatingMapMutator<String, Object, ParameterMap, T>
implements ClaimsMutator<T> {
    private static final Parameter<String> AUDIENCE_STRING = Parameters.string(DefaultClaims.AUDIENCE.getId(), DefaultClaims.AUDIENCE.getName());

    protected DelegatingClaimsMutator() {
        super(new ParameterMap(DefaultClaims.PARAMS));
    }

    @Override
    <F> T put(Parameter<F> param, F value) {
        ((ParameterMap)this.DELEGATE).put(param, value);
        return this.self();
    }

    <F> F get(Parameter<F> param) {
        return ((ParameterMap)this.DELEGATE).get(param);
    }

    public T setIssuer(String iss) {
        return this.issuer(iss);
    }

    public T issuer(String iss) {
        return this.put((Parameter)DefaultClaims.ISSUER, (Object)iss);
    }

    public T setSubject(String sub) {
        return this.subject(sub);
    }

    public T subject(String sub) {
        return this.put((Parameter)DefaultClaims.SUBJECT, (Object)sub);
    }

    public T setAudience(String aud) {
        return (T)((MapMutator)this.audience().single(aud));
    }

    private Set<String> getAudience() {
        if (!((Parameter)((ParameterMap)this.DELEGATE).PARAMS.get((Object)AUDIENCE_STRING.getId())).supports(Collections.emptySet())) {
            String existing = this.get(AUDIENCE_STRING);
            this.remove(AUDIENCE_STRING.getId());
            this.setDelegate(((ParameterMap)this.DELEGATE).replace(DefaultClaims.AUDIENCE));
            this.put((Parameter)DefaultClaims.AUDIENCE, (Object)Collections.setOf((Object[])new String[]{existing}));
        }
        return this.get(DefaultClaims.AUDIENCE);
    }

    private T audienceSingle(String aud) {
        if (!Strings.hasText((String)aud)) {
            return this.put((Parameter)DefaultClaims.AUDIENCE, (Object)null);
        }
        this.remove(AUDIENCE_STRING.getId());
        this.setDelegate(((ParameterMap)this.DELEGATE).replace(AUDIENCE_STRING));
        return this.put((Parameter)AUDIENCE_STRING, (Object)aud);
    }

    public ClaimsMutator.AudienceCollection<T> audience() {
        return new AbstractAudienceCollection<T>((MapMutator)this.self(), this.getAudience()){

            public T single(String audience) {
                return DelegatingClaimsMutator.this.audienceSingle(audience);
            }

            @Override
            public T and() {
                DelegatingClaimsMutator.this.put(DefaultClaims.AUDIENCE, Collections.asSet(this.getCollection()));
                return (MapMutator)super.and();
            }
        };
    }

    public T setExpiration(Date exp) {
        return this.expiration(exp);
    }

    public T expiration(Date exp) {
        return this.put((Parameter)DefaultClaims.EXPIRATION, (Object)exp);
    }

    public T setNotBefore(Date nbf) {
        return this.notBefore(nbf);
    }

    public T notBefore(Date nbf) {
        return this.put((Parameter)DefaultClaims.NOT_BEFORE, (Object)nbf);
    }

    public T setIssuedAt(Date iat) {
        return this.issuedAt(iat);
    }

    public T issuedAt(Date iat) {
        return this.put((Parameter)DefaultClaims.ISSUED_AT, (Object)iat);
    }

    public T setId(String jti) {
        return this.id(jti);
    }

    public T id(String jti) {
        return this.put((Parameter)DefaultClaims.JTI, (Object)jti);
    }
}

