/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ai.common.strategy;

import java.util.Objects;
import org.apache.shenyu.common.enums.AiModelProviderEnum;
import org.apache.shenyu.plugin.ai.common.strategy.AiModel;
import org.apache.shenyu.plugin.ai.common.strategy.openai.OpenAI;

public final class AiModelFactory {
    private AiModelFactory() {
    }

    public static AiModel createAiModel(AiModelProviderEnum provider) {
        if (Objects.isNull(provider)) {
            throw new IllegalArgumentException("not supported provider");
        }
        switch (provider) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case OPEN_AI: 
            case DEEP_SEEK: 
            case ALIYUN: 
            case OPEN_API: 
            case MOONSHOT: 
        }
        return new OpenAI();
    }
}

