/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.sample;

import com.aliyun.openservices.log.Client;
import com.aliyun.openservices.log.common.AliyunCloudMonitorSource;
import com.aliyun.openservices.log.common.Ingestion;
import com.aliyun.openservices.log.common.IngestionConfiguration;
import com.aliyun.openservices.log.common.JobSchedule;
import com.aliyun.openservices.log.common.JobScheduleType;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.request.CreateIngestionRequest;
import java.util.Arrays;

class CloudMonitorSample {
    private final String endPoint = "your_endpoint";
    private final String accessId = "your_access_id";
    private final String accessKey = "your_access_key";
    private final Client client = new Client("your_endpoint", "your_access_id", "your_access_key");
    private final String project = "your_project_name";
    private final String logStore = "your_log_store";
    private final String displayName = "your_display_name";
    private final String interval = "1h";

    CloudMonitorSample() {
    }

    public void createIngestTask() {
        Ingestion ingestion = new Ingestion();
        ingestion.setName("cloud-monitor-data");
        ingestion.setDisplayName("your_display_name");
        IngestionConfiguration configuration = new IngestionConfiguration();
        configuration.setLogstore("your_log_store");
        AliyunCloudMonitorSource source = new AliyunCloudMonitorSource();
        source.setAccessKeyID("your_access_id");
        source.setAccessKeySecret("your_access_key");
        source.setNamespaces(Arrays.asList("ecs", "xxx"));
        source.setOutputType("SLSMetric");
        configuration.setSource(source);
        ingestion.setConfiguration(configuration);
        JobSchedule schedule = new JobSchedule();
        schedule.setInterval("1h");
        schedule.setType(JobScheduleType.FIXED_RATE);
        ingestion.setSchedule(schedule);
        try {
            this.client.createIngestion(new CreateIngestionRequest("your_project_name", ingestion));
        }
        catch (LogException e) {
            System.err.println("Create cloud monitor ingestion Error ! " + e.GetErrorMessage());
        }
    }
}

